/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.ui.SubmitTaskDataJob;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.internal.tasks.ui.actions.NewSubTaskAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.SynchronizeEditorAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.ToggleTaskActivationAction;
import org.eclipse.mylyn.internal.tasks.ui.editors.AbstractTaskEditorPart;
import org.eclipse.mylyn.internal.tasks.ui.editors.AttributeEditorFactory;
import org.eclipse.mylyn.internal.tasks.ui.editors.AttributeEditorToolkit;
import org.eclipse.mylyn.internal.tasks.ui.editors.AttributeManager;
import org.eclipse.mylyn.internal.tasks.ui.editors.ContentOutlineTools;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.internal.tasks.ui.editors.IAttributeManagerListener;
import org.eclipse.mylyn.internal.tasks.ui.editors.IRepositoryTaskAttributeListener;
import org.eclipse.mylyn.internal.tasks.ui.editors.IRepositoryTaskSelection;
import org.eclipse.mylyn.internal.tasks.ui.editors.RepositoryTaskOutlineNode;
import org.eclipse.mylyn.internal.tasks.ui.editors.RepositoryTaskOutlinePage;
import org.eclipse.mylyn.internal.tasks.ui.editors.RepositoryTaskSelection;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorActionPart;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorAttachmentPart;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorAttributePart;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorCommentPart;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorDescriptionPart;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorPeoplePart;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorPlanningPart;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorRichTextPart;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorSummaryPart;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.tasks.core.ITaskListChangeListener;
import org.eclipse.mylyn.tasks.core.RepositoryAttachment;
import org.eclipse.mylyn.tasks.core.RepositoryTaskAttribute;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;
import org.eclipse.mylyn.tasks.core.TaskComment;
import org.eclipse.mylyn.tasks.core.TaskContainerDelta;
import org.eclipse.mylyn.tasks.core.TaskList;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.mylyn.tasks.ui.editors.NewTaskEditorInput;
import org.eclipse.mylyn.tasks.ui.editors.RepositoryTaskEditorInput;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorInput;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.themes.IThemeManager;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public abstract class AbstractTaskEditorPage
extends FormPage {
    private static final String ERROR_NOCONNECTIVITY = "Unable to submit at this time. Check connectivity and retry.";
    private static final String LABEL_HISTORY = "History";
    private static final Font TITLE_FONT = JFaceResources.getBannerFont();
    private TaskEditorActionPart actionPart;
    private ToggleTaskActivationAction activateAction;
    private AttributeManager attributeManager;
    private final List<IRepositoryTaskAttributeListener> attributesListeners = new ArrayList<IRepositoryTaskAttributeListener>();
    private Section attributesSection;
    private Color colorIncoming;
    private TaskEditorCommentPart commentPart;
    private AbstractRepositoryConnector connector;
    private final HashMap<Object, Control> controlBySelectableObject = new HashMap();
    private TaskEditorDescriptionPart descriptionPart;
    private Composite editorComposite;
    private boolean expandedStateAttributes = false;
    private boolean firstFocus = true;
    private ScrolledForm form;
    private boolean formBusy = false;
    private Action historyAction;
    private IRepositoryTaskSelection lastSelected = null;
    private Menu menu;
    private boolean needsAttachments;
    private boolean needsComments;
    private boolean needsHeader;
    private boolean needsPlanning;
    private TaskEditorRichTextPart newCommentPart;
    private NewSubTaskAction newSubTaskAction;
    private Action openBrowserAction;
    private RepositoryTaskOutlinePage outlinePage = null;
    private TaskEditorPlanningPart planningPart;
    private boolean reflow = true;
    private TaskRepository repository;
    private final List<ISelectionChangedListener> selectionChangedListeners = new ArrayList<ISelectionChangedListener>();
    private final ISelectionListener selectionListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (part instanceof ContentOutline && selection instanceof StructuredSelection) {
                Object select = ((StructuredSelection)selection).getFirstElement();
                if (select instanceof RepositoryTaskOutlineNode) {
                    RepositoryTaskOutlineNode n = (RepositoryTaskOutlineNode)select;
                    if (AbstractTaskEditorPage.this.lastSelected != null && ContentOutlineTools.getHandle(n).equals(ContentOutlineTools.getHandle(AbstractTaskEditorPage.this.lastSelected))) {
                        return;
                    }
                    AbstractTaskEditorPage.this.lastSelected = n;
                    boolean highlight = true;
                    if (n.getKey().equals("Comments")) {
                        highlight = false;
                    }
                    Object data = n.getData();
                    if (n.getKey().equals("New Comment")) {
                        if (AbstractTaskEditorPage.this.commentPart != null) {
                            AbstractTaskEditorPage.this.commentPart.setFocus();
                        }
                    } else if (n.getKey().equals("Description")) {
                        if (AbstractTaskEditorPage.this.descriptionPart != null) {
                            AbstractTaskEditorPage.this.descriptionPart.setFocus();
                        }
                    } else if (data != null) {
                        AbstractTaskEditorPage.this.select(data, highlight);
                    }
                }
                part.setFocus();
            }
        }
    };
    private final ISelectionProvider selectionProvider = new ISelectionProvider(){

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            AbstractTaskEditorPage.this.selectionChangedListeners.add(listener);
        }

        public ISelection getSelection() {
            TaskComment selectedComment = null;
            if (AbstractTaskEditorPage.this.commentPart != null) {
                selectedComment = AbstractTaskEditorPage.this.commentPart.getSelectedComment();
            }
            RepositoryTaskSelection selection = new RepositoryTaskSelection(AbstractTaskEditorPage.this.taskData.getId(), AbstractTaskEditorPage.this.taskData.getRepositoryUrl(), AbstractTaskEditorPage.this.taskData.getRepositoryKind(), "", selectedComment, AbstractTaskEditorPage.this.taskData.getSummary());
            selection.setIsDescription(true);
            return selection;
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            AbstractTaskEditorPage.this.selectionChangedListeners.remove(listener);
        }

        public void setSelection(ISelection selection) {
        }
    };
    private TaskEditorSummaryPart summaryPart;
    private SynchronizeEditorAction synchronizeEditorAction;
    private AbstractTask task;
    private RepositoryTaskData taskData;
    private final ITaskListChangeListener TASKLIST_CHANGE_LISTENER = new ITaskListChangeListener(){

        public void containersChanged(Set<TaskContainerDelta> containers) {
            AbstractTask taskToRefresh = null;
            for (TaskContainerDelta taskContainerDelta : containers) {
                if (AbstractTaskEditorPage.this.task == null || !AbstractTaskEditorPage.this.task.equals((Object)taskContainerDelta.getContainer()) || !taskContainerDelta.getKind().equals((Object)TaskContainerDelta.Kind.CONTENT)) continue;
                taskToRefresh = (AbstractTask)taskContainerDelta.getContainer();
                break;
            }
            if (taskToRefresh != null) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (AbstractTaskEditorPage.this.task.getSynchronizationState() == AbstractTask.RepositoryTaskSyncState.INCOMING || AbstractTaskEditorPage.this.task.getSynchronizationState() == AbstractTask.RepositoryTaskSyncState.CONFLICT) {
                            AbstractTaskEditorPage.this.getParentEditor().setMessage("Task has incoming changes, synchronize to view", 2, (IHyperlinkListener)new HyperlinkAdapter(){

                                public void linkActivated(HyperlinkEvent e) {
                                    AbstractTaskEditorPage.this.refreshEditor();
                                }
                            });
                            if (AbstractTaskEditorPage.this.actionPart != null) {
                                AbstractTaskEditorPage.this.actionPart.setSubmitEnabled(false);
                            }
                        } else {
                            AbstractTaskEditorPage.this.refreshEditor();
                        }
                    }
                });
            }
        }
    };
    private RepositoryTaskOutlineNode taskOutlineModel = null;
    private FormToolkit toolkit;
    private boolean initialized;

    public AbstractTaskEditorPage(FormEditor editor) {
        super(editor, "id", "label");
    }

    public void addAttributeListener(IRepositoryTaskAttributeListener listener) {
        this.attributesListeners.add(listener);
    }

    private void addHeaderControls() {
        ControlContribution repositoryLabelControl = new ControlContribution("Title"){

            protected Control createControl(Composite parent) {
                Composite composite = AbstractTaskEditorPage.this.toolkit.createComposite(parent);
                composite.setLayout((Layout)new RowLayout());
                composite.setBackground(null);
                String label = AbstractTaskEditorPage.this.repository.getRepositoryLabel();
                if (label.indexOf("//") != -1) {
                    label = label.substring(AbstractTaskEditorPage.this.repository.getUrl().indexOf("//") + 2);
                }
                Hyperlink link = new Hyperlink(composite, 0);
                link.setText(label);
                link.setFont(TITLE_FONT);
                link.setForeground(AbstractTaskEditorPage.this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
                link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent e) {
                        TasksUiUtil.openEditRepositoryWizard(AbstractTaskEditorPage.this.repository);
                    }
                });
                return composite;
            }
        };
        if (this.getParentEditor().getTopForm() != null) {
            IToolBarManager toolBarManager = this.getParentEditor().getTopForm().getToolBarManager();
            toolBarManager.removeAll();
            toolBarManager.update(true);
            toolBarManager.add((IContributionItem)repositoryLabelControl);
            this.fillToolBar(this.getParentEditor().getTopForm().getToolBarManager());
            if (this.task != null && this.taskData != null && !this.taskData.isNew()) {
                this.activateAction = new ToggleTaskActivationAction(this.task, toolBarManager);
                toolBarManager.add((IContributionItem)new Separator("activation"));
                toolBarManager.add((IAction)this.activateAction);
            }
            toolBarManager.update(true);
        }
    }

    public void addSelectableControl(Object item, Control control) {
        this.controlBySelectableObject.put(item, control);
    }

    public void appendTextToNewComment(String text) {
        this.newCommentPart.appendText(text);
        this.newCommentPart.setFocus();
    }

    public void close() {
        Display activeDisplay = this.getSite().getShell().getDisplay();
        activeDisplay.asyncExec(new Runnable(){

            public void run() {
                if (AbstractTaskEditorPage.this.getSite() != null && AbstractTaskEditorPage.this.getSite().getPage() != null && !AbstractTaskEditorPage.this.getManagedForm().getForm().isDisposed()) {
                    if (AbstractTaskEditorPage.this.getParentEditor() != null) {
                        AbstractTaskEditorPage.this.getSite().getPage().closeEditor((IEditorPart)AbstractTaskEditorPage.this.getParentEditor(), false);
                    } else {
                        AbstractTaskEditorPage.this.getSite().getPage().closeEditor((IEditorPart)AbstractTaskEditorPage.this, false);
                    }
                }
            }
        });
    }

    private void createActionsSection(Composite composite) {
        Section section = this.createSection(composite, this.getSectionLabel(SECTION_NAME.ACTIONS_SECTION));
        GridDataFactory.fillDefaults().align(4, 128).grab(true, true).applyTo((Control)section);
        this.actionPart = new TaskEditorActionPart(this);
        this.initializePart(section, this.actionPart);
    }

    private void createAttachmentSection(Composite composite) {
        Section section = this.createSection(composite, this.getSectionLabel(SECTION_NAME.ATTACHMENTS_SECTION));
        section.setText(String.valueOf(section.getText()) + " (" + this.taskData.getAttachments().size() + ")");
        section.setExpanded(false);
        TaskEditorAttachmentPart attachmentPart = new TaskEditorAttachmentPart(this);
        attachmentPart.setSupportsDelete(this.supportsAttachmentDelete());
        this.initializePart(section, attachmentPart);
    }

    private void createAttributeManager(IEditorInput input) {
        TaskList taskList = TasksUiPlugin.getTaskListManager().getTaskList();
        if (input instanceof NewTaskEditorInput) {
            NewTaskEditorInput editorInput = (NewTaskEditorInput)input;
            this.task = new LocalTask("" + taskList.getNextLocalTaskId(), "*");
            this.task.setUrl(editorInput.getRepository().getUrl());
            taskList.addTask(this.task, (AbstractTaskContainer)taskList.getDefaultCategory());
            TasksUiPlugin.getTaskDataManager().setNewTaskData(this.task.getRepositoryUrl(), this.task.getTaskId(), editorInput.getTaskData());
            this.attributeManager = this.createAttributeManager(editorInput.getRepository(), "local", this.task.getTaskId());
        } else if (input instanceof RepositoryTaskEditorInput) {
            RepositoryTaskEditorInput editorInput = (RepositoryTaskEditorInput)input;
            this.task = editorInput.getRepositoryTask();
            this.attributeManager = this.createAttributeManager(editorInput.getRepository(), editorInput.getRepository().getUrl(), editorInput.getId());
        } else if (input instanceof TaskEditorInput) {
            TaskEditorInput editorInput = (TaskEditorInput)input;
            this.task = editorInput.getTask();
            TaskRepository taskRepository = TasksUiPlugin.getRepositoryManager().getRepository(this.task.getUrl());
            this.attributeManager = this.createAttributeManager(taskRepository, "local", this.task.getTaskId());
        }
    }

    protected abstract AttributeManager createAttributeManager(TaskRepository var1, String var2, String var3);

    private void createAttributeSection() {
        this.attributesSection = this.createSection(this.editorComposite, this.getSectionLabel(SECTION_NAME.ATTRIBTUES_SECTION));
        this.attributesSection.setExpanded(this.expandedStateAttributes || this.getAttributeManager().hasVisibleOutgoingChanges(this.taskData));
        TaskEditorAttributePart attributePart = new TaskEditorAttributePart(this);
        this.initializePart(this.attributesSection, attributePart);
    }

    private void createCommentSection(Composite composite) {
        Section commentsSection = this.createSection(composite, this.getSectionLabel(SECTION_NAME.COMMENTS_SECTION));
        this.commentPart = new TaskEditorCommentPart(this, commentsSection);
        this.commentPart.setSupportsDelete(this.supportsCommentDelete());
        this.initializePart(commentsSection, this.commentPart);
    }

    private void createDescriptionSection(Composite composite) {
        RepositoryTaskAttribute attribute = this.getAttributeManager().getTaskData().getAttribute("task.common.description");
        if (attribute != null) {
            Section descriptionSection = this.createSection(composite, this.getSectionLabel(SECTION_NAME.DESCRIPTION_SECTION));
            this.descriptionPart = new TaskEditorDescriptionPart(this, attribute);
            this.initializePart(descriptionSection, this.descriptionPart);
        }
    }

    protected void createFormContent(IManagedForm managedForm) {
        IThemeManager themeManager = this.getSite().getWorkbenchWindow().getWorkbench().getThemeManager();
        this.colorIncoming = themeManager.getCurrentTheme().getColorRegistry().get("org.eclipse.mylyn.tasks.ui.colors.incoming.background");
        super.createFormContent(managedForm);
        this.form = managedForm.getForm();
        this.toolkit = managedForm.getToolkit();
        this.registerDropListener((Control)this.form);
        this.editorComposite = this.form.getBody();
        GridLayout editorLayout = new GridLayout();
        this.editorComposite.setLayout((Layout)editorLayout);
        this.editorComposite.setLayoutData((Object)new GridData(1808));
        if (this.taskData == null) {
            this.getParentEditor().setMessage("Task data not available. Press synchronize button (right) to retrieve latest data.", 2);
        } else {
            this.createSections();
        }
        this.addHeaderControls();
    }

    private void createNewCommentSection(Composite composite) {
        RepositoryTaskAttribute attribute = this.getAttributeManager().getTaskData().getAttribute("task.common.comment.new");
        if (attribute != null) {
            Section newCommentSection = this.toolkit.createSection(composite, 256);
            newCommentSection.setText(this.getSectionLabel(SECTION_NAME.NEWCOMMENT_SECTION));
            newCommentSection.setLayout((Layout)new GridLayout());
            newCommentSection.setLayoutData((Object)new GridData(1808));
            this.newCommentPart = new TaskEditorRichTextPart(this, attribute);
            this.initializePart(newCommentSection, this.newCommentPart);
        }
    }

    private void createPeopleSection(Composite composite) {
        Section peopleSection = this.createSection(composite, this.getSectionLabel(SECTION_NAME.PEOPLE_SECTION));
        GridDataFactory.fillDefaults().align(4, 128).grab(true, true).applyTo((Control)peopleSection);
        TaskEditorPeoplePart peoplePart = new TaskEditorPeoplePart(this);
        this.initializePart(peopleSection, peoplePart);
    }

    private void createPlanningSection(Composite composite) {
        Section planningSection = this.createSection(composite, this.getSectionLabel(SECTION_NAME.PLANNING_SECTION));
        GridDataFactory.fillDefaults().align(4, 128).grab(true, true).applyTo((Control)planningSection);
        this.planningPart = new TaskEditorPlanningPart(this);
        this.initializePart(planningSection, this.planningPart);
    }

    private Section createSection(Composite composite, String title) {
        Section section = this.toolkit.createSection(composite, 258);
        section.setText(title);
        section.setExpanded(true);
        section.setLayoutData((Object)new GridData(768));
        return section;
    }

    private void createSections() {
        this.createSummarySection(this.editorComposite);
        this.createAttributeSection();
        if (this.needsAttachments()) {
            this.createAttachmentSection(this.editorComposite);
        }
        this.createDescriptionSection(this.editorComposite);
        if (this.needsComments()) {
            this.createCommentSection(this.editorComposite);
            this.createNewCommentSection(this.editorComposite);
        }
        if (this.needsPlanning()) {
            this.createPlanningSection(this.editorComposite);
        }
        Composite bottomComposite = this.toolkit.createComposite(this.editorComposite);
        bottomComposite.setLayout((Layout)new GridLayout(2, false));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)bottomComposite);
        this.createActionsSection(bottomComposite);
        this.createPeopleSection(bottomComposite);
        bottomComposite.pack(true);
        this.form.reflow(true);
        this.getSite().getPage().addSelectionListener(this.selectionListener);
        this.getSite().setSelectionProvider(this.selectionProvider);
    }

    private void createSummarySection(Composite composite) {
        this.summaryPart = new TaskEditorSummaryPart(this);
        this.getManagedForm().addPart((IFormPart)this.summaryPart);
        this.summaryPart.setInput(this.connector, this.repository, this.taskData);
        this.summaryPart.setNeedsHeader(this.needsHeader());
        this.summaryPart.createControl(composite, this.toolkit);
        this.summaryPart.getControl().setLayoutData((Object)new GridData(4, 1, true, false));
    }

    protected void deleteAttachment(RepositoryAttachment attachment) {
    }

    protected void deleteComment(TaskComment comment) {
    }

    public void dispose() {
        TasksUiPlugin.getTaskListManager().getTaskList().removeChangeListener(this.TASKLIST_CHANGE_LISTENER);
        this.getSite().getPage().removeSelectionListener(this.selectionListener);
        if (this.activateAction != null) {
            this.activateAction.dispose();
        }
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        if (!this.isDirty()) {
            return;
        }
        this.getManagedForm().commit(true);
        this.attributeManager.save();
        if (this.task != null) {
            this.task.setSynchronizationState(AbstractTask.RepositoryTaskSyncState.OUTGOING);
            TasksUiPlugin.getTaskListManager().getTaskList().notifyTaskChanged(this.task, false);
        }
        this.getManagedForm().dirtyStateChanged();
    }

    public void doSaveAs() {
        throw new UnsupportedOperationException();
    }

    protected void fillToolBar(IToolBarManager toolBarManager) {
        if (this.taskData != null && !this.taskData.isNew()) {
            if (this.task != null) {
                this.synchronizeEditorAction = new SynchronizeEditorAction();
                this.synchronizeEditorAction.selectionChanged((IStructuredSelection)new StructuredSelection((Object)this));
                toolBarManager.add((IAction)this.synchronizeEditorAction);
                this.newSubTaskAction = new NewSubTaskAction();
                this.newSubTaskAction.selectionChanged((IAction)this.newSubTaskAction, (ISelection)new StructuredSelection((Object)this.task));
                if (this.newSubTaskAction.isEnabled()) {
                    toolBarManager.add((IAction)this.newSubTaskAction);
                }
            }
            if (this.getHistoryUrl() != null) {
                this.historyAction = new Action(){

                    public void run() {
                        TasksUiUtil.openUrl(AbstractTaskEditorPage.this.getHistoryUrl(), false);
                    }
                };
                this.historyAction.setImageDescriptor(TasksUiImages.TASK_REPOSITORY_HISTORY);
                this.historyAction.setToolTipText(LABEL_HISTORY);
                toolBarManager.add((IAction)this.historyAction);
            }
            if (this.connector != null) {
                String taskUrlToOpen;
                String taskUrl = this.connector.getTaskUrl(this.taskData.getRepositoryUrl(), this.taskData.getTaskKey());
                if (taskUrl == null && this.task != null && this.task.hasValidUrl()) {
                    taskUrl = this.task.getUrl();
                }
                if ((taskUrlToOpen = taskUrl) != null) {
                    this.openBrowserAction = new Action(){

                        public void run() {
                            TasksUiUtil.openUrl(taskUrlToOpen, false);
                        }
                    };
                    this.openBrowserAction.setImageDescriptor(TasksUiImages.BROWSER_OPEN_TASK);
                    this.openBrowserAction.setToolTipText("Open with Web Browser");
                    toolBarManager.add((IAction)this.openBrowserAction);
                }
            }
        }
    }

    protected void fireSelectionChanged(final SelectionChangedEvent event) {
        Object[] listeners;
        Object[] objectArray = listeners = this.selectionChangedListeners.toArray();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            final ISelectionChangedListener l = (ISelectionChangedListener)element;
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.selectionChanged(event);
                }
            });
            ++n2;
        }
    }

    private void focusOn(Control selectionComposite, boolean highlight) {
        int pos = 0;
        if (selectionComposite != null) {
            pos = 0;
            Control s = selectionComposite;
            if (s.isDisposed()) {
                return;
            }
            s.setEnabled(true);
            s.setFocus();
            s.forceFocus();
            while (s != null && s != this.getEditorComposite()) {
                if (s.isDisposed()) continue;
                pos += s.getLocation().y;
                s = s.getParent();
            }
            pos -= 60;
        }
        if (!this.form.getBody().isDisposed()) {
            this.form.setOrigin(0, pos);
        }
    }

    public Object getAdapter(Class adapter) {
        if (IContentOutlinePage.class.equals((Object)adapter)) {
            if (this.outlinePage == null && this.taskOutlineModel != null) {
                this.outlinePage = new RepositoryTaskOutlinePage(this.taskOutlineModel);
            }
            return this.outlinePage;
        }
        return super.getAdapter(adapter);
    }

    protected abstract AttributeEditorFactory getAttributeEditorFactory();

    public abstract AttributeEditorToolkit getAttributeEditorToolkit();

    protected AttributeManager getAttributeManager() {
        return this.attributeManager;
    }

    protected Color getColorIncoming() {
        return this.colorIncoming;
    }

    public AbstractRepositoryConnector getConnector() {
        return this.connector;
    }

    public Composite getEditorComposite() {
        return this.editorComposite;
    }

    protected String getHistoryUrl() {
        return null;
    }

    public RepositoryTaskOutlinePage getOutline() {
        return this.outlinePage;
    }

    public TaskEditor getParentEditor() {
        return (TaskEditor)this.getEditor();
    }

    private String getSectionLabel(SECTION_NAME labelName) {
        return labelName.getPrettyName();
    }

    public AbstractTask getTask() {
        return this.task;
    }

    public TaskRepository getTaskRepository() {
        return this.repository;
    }

    public void init(IEditorSite site, IEditorInput input) {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.createAttributeManager(input);
        this.repository = this.attributeManager.getTaskRepository();
        this.connector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector(this.repository.getConnectorKind());
        this.attributeManager.addAttributeManagerListener(new IAttributeManagerListener(){

            public void attributeChanged(RepositoryTaskAttribute attribute) {
                AbstractTaskEditorPage.this.getManagedForm().dirtyStateChanged();
            }
        });
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.refreshInput();
        TasksUiPlugin.getTaskListManager().getTaskList().addChangeListener(this.TASKLIST_CHANGE_LISTENER);
    }

    private void initializePart(Section section, AbstractTaskEditorPart part) {
        this.getManagedForm().addPart((IFormPart)part);
        part.setInput(this.connector, this.repository, this.taskData);
        part.createControl((Composite)section, this.toolkit);
        section.setClient(part.getControl());
        if (section.getTextClient() == null) {
            ToolBarManager toolBarManager = new ToolBarManager(0x800000);
            part.fillToolBar(toolBarManager);
            if (toolBarManager.getSize() > 0) {
                Composite toolbarComposite = this.toolkit.createComposite((Composite)section);
                toolbarComposite.setBackground(null);
                RowLayout rowLayout = new RowLayout();
                rowLayout.marginTop = 0;
                rowLayout.marginBottom = 0;
                toolbarComposite.setLayout((Layout)rowLayout);
                toolBarManager.createControl(toolbarComposite);
                section.setTextClient((Control)toolbarComposite);
            }
        }
    }

    public boolean isDirty() {
        return this.getAttributeManager().isDirty() || this.getManagedForm() != null && this.getManagedForm().isDirty();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean needsAttachments() {
        return this.needsAttachments;
    }

    public boolean needsComments() {
        return this.needsComments;
    }

    public boolean needsHeader() {
        return this.needsHeader;
    }

    public boolean needsPlanning() {
        return this.needsPlanning;
    }

    public void refreshEditor() {
        if (this.task != null) {
            TasksUiPlugin.getSynchronizationManager().setTaskRead(this.task, true);
        }
        if (this.getManagedForm().getForm().isDisposed()) {
            return;
        }
        try {
            this.setGlobalBusy(true);
            this.doSave((IProgressMonitor)new NullProgressMonitor());
            this.controlBySelectableObject.clear();
            this.refreshInput();
            if (this.task != null) {
                TasksUiPlugin.getSynchronizationManager().setTaskRead(this.task, true);
            }
            if (this.taskData == null) {
                this.getParentEditor().setMessage("Task data not available. Press synchronize button (right) to retrieve latest data.", 2);
            } else {
                this.menu = this.editorComposite.getMenu();
                this.removeSections();
                this.editorComposite.setMenu(this.menu);
                this.createSections();
                this.getParentEditor().setMessage(null, 0);
                this.getParentEditor().setActivePage(this.getId());
                if (this.taskOutlineModel != null && this.outlinePage != null && !this.outlinePage.getControl().isDisposed()) {
                    this.outlinePage.getOutlineTreeViewer().setInput((Object)this.taskOutlineModel);
                    this.outlinePage.getOutlineTreeViewer().refresh(true);
                }
                if (this.actionPart != null) {
                    this.actionPart.setSubmitEnabled(true);
                }
            }
            this.getManagedForm().dirtyStateChanged();
        }
        finally {
            this.setGlobalBusy(false);
        }
    }

    private void refreshInput() {
        this.attributeManager.refreshInput();
        this.taskData = this.attributeManager.getTaskData();
        this.needsComments = !this.taskData.isNew();
        this.needsAttachments = !this.taskData.isNew();
        this.needsHeader = !this.taskData.isNew();
        this.needsPlanning = this.taskData.isNew();
        this.taskOutlineModel = RepositoryTaskOutlineNode.parseBugReport(this.taskData);
    }

    private void registerDropListener(Control control) {
        DropTarget target = new DropTarget(control, 17);
        TextTransfer textTransfer = TextTransfer.getInstance();
        FileTransfer fileTransfer = FileTransfer.getInstance();
        Transfer[] types = new Transfer[]{textTransfer, fileTransfer};
        target.setTransfer(types);
    }

    public void removeAttributeListener(IRepositoryTaskAttributeListener listener) {
        this.attributesListeners.remove(listener);
    }

    private void removeSections() {
        this.menu = this.editorComposite.getMenu();
        this.setMenu(this.editorComposite, null);
        Control[] controlArray = this.editorComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
    }

    public void removeSelectableControl(Object item) {
        this.controlBySelectableObject.remove(item);
    }

    protected void resetLayout() {
        if (this.reflow) {
            this.form.layout(true, true);
            this.form.reflow(true);
        }
    }

    public boolean select(Object o, boolean highlight) {
        Control control = this.controlBySelectableObject.get(o);
        if (control != null && !control.isDisposed()) {
            ExpandableComposite ex;
            if (control instanceof ExpandableComposite && !(ex = (ExpandableComposite)control).isExpanded()) {
                EditorUtil.toggleExpandableComposite(true, ex);
            }
            Composite comp = control.getParent();
            while (comp != null) {
                if (comp instanceof Section) {
                    ((Section)comp).setExpanded(true);
                } else if (comp instanceof ExpandableComposite) {
                    ExpandableComposite ex2 = (ExpandableComposite)comp;
                    if (!ex2.isExpanded()) {
                        EditorUtil.toggleExpandableComposite(true, ex2);
                    }
                    if (ex2.getData() != null && ex2.getData() instanceof Composite) {
                        ((Composite)ex2.getData()).setVisible(true);
                    }
                }
                comp = comp.getParent();
            }
            this.focusOn(control, highlight);
        } else if (o instanceof RepositoryTaskData) {
            this.focusOn(null, highlight);
        } else {
            return false;
        }
        return true;
    }

    public void setExpandAttributeSection(boolean expandAttributeSection) {
        this.expandedStateAttributes = expandAttributeSection;
    }

    public void setFocus() {
        if (this.summaryPart != null) {
            if (this.firstFocus) {
                this.summaryPart.setFocus();
                this.firstFocus = false;
            }
        } else {
            this.form.setFocus();
        }
    }

    public void setGlobalBusy(boolean busy) {
        if (this.getParentEditor() != null) {
            this.getParentEditor().showBusy(busy);
        } else {
            this.showBusy(busy);
        }
    }

    private void setMenu(Composite comp, Menu menu) {
        if (!comp.isDisposed()) {
            comp.setMenu(null);
            Control[] controlArray = comp.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                child.setMenu(null);
                if (child instanceof Composite) {
                    this.setMenu((Composite)child, menu);
                }
                ++n2;
            }
        }
    }

    public void setReflow(boolean refreshEnabled) {
        this.reflow = refreshEnabled;
        this.form.setRedraw(this.reflow);
    }

    public void showBusy(boolean busy) {
        if (!this.getManagedForm().getForm().isDisposed() && busy != this.formBusy) {
            if (this.synchronizeEditorAction != null) {
                this.synchronizeEditorAction.setEnabled(!busy);
            }
            if (this.activateAction != null) {
                this.activateAction.setEnabled(!busy);
            }
            if (this.openBrowserAction != null) {
                this.openBrowserAction.setEnabled(!busy);
            }
            if (this.historyAction != null) {
                this.historyAction.setEnabled(!busy);
            }
            if (this.actionPart != null) {
                this.actionPart.setSubmitEnabled(!busy);
            }
            if (this.newSubTaskAction != null) {
                this.newSubTaskAction.setEnabled(!busy);
            }
            EditorUtil.setEnabledState(this.editorComposite, !busy);
            this.formBusy = busy;
        }
    }

    public void submitToRepository() {
        this.setGlobalBusy(true);
        this.doSave((IProgressMonitor)new NullProgressMonitor());
        SubmitTaskDataJob submitJob = new SubmitTaskDataJob(this.connector, this.repository, this.taskData);
        submitJob.setAttachContext(this.actionPart.getAttachContext());
        submitJob.addJobChangeListener((IJobChangeListener)new SubmitTaskJobListener());
        submitJob.schedule();
    }

    protected boolean supportsAttachmentDelete() {
        return false;
    }

    protected boolean supportsCommentDelete() {
        return false;
    }

    protected boolean supportsRefreshAttributes() {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum SECTION_NAME {
        ACTIONS_SECTION("Actions"),
        ATTACHMENTS_SECTION("Attachments"),
        ATTRIBTUES_SECTION("Attributes"),
        COMMENTS_SECTION("Comments"),
        DESCRIPTION_SECTION("Description"),
        NEWCOMMENT_SECTION("New Comment"),
        PEOPLE_SECTION("People"),
        PLANNING_SECTION("Personal Planning"),
        RELATEDBUGS_SECTION("Related Tasks");

        private String prettyName;

        private SECTION_NAME(String prettyName) {
            this.prettyName = prettyName;
        }

        public String getPrettyName() {
            return this.prettyName;
        }
    }

    private class SubmitTaskJobListener
    extends JobChangeAdapter {
        private SubmitTaskJobListener() {
        }

        public void done(IJobChangeEvent event) {
            final SubmitTaskDataJob job = (SubmitTaskDataJob)event.getJob();
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (job.getError() == null) {
                        AbstractTask task = job.getTask();
                        if (task != null) {
                            SubmitTaskJobListener.this.updateTask(task);
                        }
                        AbstractTaskEditorPage.this.refreshEditor();
                    } else {
                        SubmitTaskJobListener.this.handleSubmitError(job.getError());
                    }
                    AbstractTaskEditorPage.this.setGlobalBusy(false);
                }
            });
        }

        private void handleSubmitError(IStatus status) {
            if (AbstractTaskEditorPage.this.form != null && !AbstractTaskEditorPage.this.form.isDisposed()) {
                if (status.getCode() == 5) {
                    AbstractTaskEditorPage.this.getParentEditor().setMessage(AbstractTaskEditorPage.ERROR_NOCONNECTIVITY, 3);
                    StatusHandler.log((IStatus)status);
                } else if (status.getCode() == 9) {
                    StatusHandler.displayStatus((String)"Comment required", (IStatus)status);
                    if (!AbstractTaskEditorPage.this.getManagedForm().getForm().isDisposed() && AbstractTaskEditorPage.this.newCommentPart != null) {
                        AbstractTaskEditorPage.this.newCommentPart.setFocus();
                    }
                } else if (status.getCode() == 3) {
                    if (TasksUiUtil.openEditRepositoryWizard(AbstractTaskEditorPage.this.repository) == 0) {
                        AbstractTaskEditorPage.this.submitToRepository();
                        return;
                    }
                } else {
                    StatusHandler.displayStatus((String)"Submit failed", (IStatus)status);
                }
            }
        }

        private void updateTask(AbstractTask task) {
            TasksUiPlugin.getTaskListManager().getTaskList().moveTask(task, (AbstractTaskContainer)AbstractTaskEditorPage.this.actionPart.getCategory());
            AbstractTaskEditorPage.this.task = task;
            AbstractTaskEditorPage.this.getAttributeManager().setStorageUrl(task.getRepositoryUrl());
            AbstractTaskEditorPage.this.getAttributeManager().setStorageId(task.getTaskId());
        }
    }
}

