/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.Expression;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.mylyn.internal.tasks.ui.PersonProposalLabelProvider;
import org.eclipse.mylyn.internal.tasks.ui.PersonProposalProvider;
import org.eclipse.mylyn.internal.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.internal.tasks.ui.editors.RepositoryTextViewer;
import org.eclipse.mylyn.internal.tasks.ui.editors.RichTextAttributeEditor;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorActionContributor;
import org.eclipse.mylyn.tasks.core.RepositoryTaskAttribute;
import org.eclipse.mylyn.tasks.ui.editors.AbstractRenderingEngine;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ActiveShellExpression;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.keys.IBindingService;

public class AttributeEditorToolkit {
    private TaskEditorActionContributor actionContributor;
    private IHandlerActivation spellFixHandlerActivation;
    private final IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);

    public void adapt(AbstractAttributeEditor editor) {
        if (editor.getControl() instanceof Text && this.hasContentAssist(editor.getTaskAttribute())) {
            Text text = (Text)editor.getControl();
            IContentProposalProvider contentProposalProvider = this.createContentProposalProvider(editor.getTaskAttribute());
            ILabelProvider labelPropsalProvider = this.createLabelProposalProvider(editor.getTaskAttribute());
            if (contentProposalProvider != null && labelPropsalProvider != null) {
                ContentAssistCommandAdapter adapter = this.applyContentAssist(text, contentProposalProvider);
                adapter.setLabelProvider(labelPropsalProvider);
                adapter.setProposalAcceptanceStyle(2);
            }
        } else if (editor instanceof RichTextAttributeEditor) {
            RichTextAttributeEditor richTextEditor = (RichTextAttributeEditor)editor;
            boolean spellCheck = this.hasSpellChecking(editor.getTaskAttribute());
            final SourceViewer viewer = richTextEditor.getViewer();
            viewer.getControl().addFocusListener((FocusListener)new StyledTextFocusListener(viewer, spellCheck));
            viewer.addSelectionChangedListener((ISelectionChangedListener)this.actionContributor);
            viewer.addTextListener(new ITextListener(){

                public void textChanged(TextEvent event) {
                    AttributeEditorToolkit.this.actionContributor.updateSelectableActions(viewer.getSelection());
                }
            });
            if (viewer instanceof RepositoryTextViewer) {
                RepositoryTextViewer textViewer = (RepositoryTextViewer)viewer;
                MenuManager menuManager = textViewer.getMenuManager();
                this.configureContextMenuManager(menuManager, (TextViewer)textViewer);
                textViewer.setMenu(menuManager.createContextMenu((Control)viewer.getTextWidget()));
            }
        }
    }

    protected ContentAssistCommandAdapter applyContentAssist(Text text, IContentProposalProvider proposalProvider) {
        ControlDecoration controlDecoration = new ControlDecoration((Control)text, 16512);
        controlDecoration.setMarginWidth(0);
        controlDecoration.setShowHover(true);
        controlDecoration.setShowOnlyOnFocus(true);
        FieldDecoration contentProposalImage = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL");
        controlDecoration.setImage(contentProposalImage.getImage());
        TextContentAdapter textContentAdapter = new TextContentAdapter();
        ContentAssistCommandAdapter adapter = new ContentAssistCommandAdapter((Control)text, (IControlContentAdapter)textContentAdapter, proposalProvider, "org.eclipse.ui.edit.text.contentAssist.proposals", new char[0]);
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
        controlDecoration.setDescriptionText(NLS.bind((String)"Content Assist Available ({0})", (Object)bindingService.getBestActiveBindingFormattedFor(adapter.getCommandId())));
        return adapter;
    }

    protected IContentProposalProvider createContentProposalProvider(RepositoryTaskAttribute attribute) {
        return new PersonProposalProvider(null, attribute.getTaskData());
    }

    protected ILabelProvider createLabelProposalProvider(RepositoryTaskAttribute attribute) {
        return new PersonProposalLabelProvider();
    }

    public AbstractRenderingEngine getRenderingEngine(RepositoryTaskAttribute attribute) {
        return null;
    }

    boolean hasContentAssist(RepositoryTaskAttribute taskAttribute) {
        return false;
    }

    private boolean hasSpellChecking(RepositoryTaskAttribute taskAttribute) {
        return false;
    }

    protected void configureContextMenuManager(MenuManager menuManager, TextViewer textViewer) {
    }

    private class StyledTextFocusListener
    implements FocusListener {
        private final SourceViewer viewer;
        private final boolean spellCheck;

        public StyledTextFocusListener(SourceViewer viewer, boolean spellCheck) {
            this.viewer = viewer;
            this.spellCheck = spellCheck;
        }

        private void activate() {
            if (this.spellCheck) {
                this.deactivate();
                if (AttributeEditorToolkit.this.spellFixHandlerActivation == null) {
                    AttributeEditorToolkit.this.spellFixHandlerActivation = AttributeEditorToolkit.this.handlerService.activateHandler("org.eclipse.jdt.ui.edit.text.java.correction.assist.proposals", this.createQuickFixActionHandler(this.viewer), (Expression)new ActiveShellExpression(this.viewer.getTextWidget().getShell()));
                }
            }
        }

        private IHandler createQuickFixActionHandler(final SourceViewer viewer) {
            Action quickFixAction = new Action(){

                public void run() {
                    if (viewer.canDoOperation(22)) {
                        viewer.doOperation(22);
                    }
                }
            };
            quickFixAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.correction.assist.proposals");
            return new ActionHandler((IAction)quickFixAction);
        }

        private void deactivate() {
            if (this.spellCheck && AttributeEditorToolkit.this.spellFixHandlerActivation != null) {
                AttributeEditorToolkit.this.handlerService.deactivateHandler(AttributeEditorToolkit.this.spellFixHandlerActivation);
                AttributeEditorToolkit.this.spellFixHandlerActivation = null;
            }
        }

        public void focusGained(FocusEvent e) {
            AttributeEditorToolkit.this.actionContributor.updateSelectableActions(this.viewer.getSelection());
            this.activate();
        }

        public void focusLost(FocusEvent e) {
            StyledText st = (StyledText)e.widget;
            st.setSelectionRange(st.getCaretOffset(), 0);
            AttributeEditorToolkit.this.actionContributor.forceActionsEnabled();
            this.deactivate();
        }
    }
}

