/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.mylyn.internal.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.internal.tasks.ui.editors.AttributeManager;
import org.eclipse.mylyn.internal.tasks.ui.editors.RichTextAttributeEditor;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskUrlHyperlink;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.RepositoryStatus;
import org.eclipse.mylyn.tasks.core.RepositoryTaskAttribute;
import org.eclipse.mylyn.tasks.ui.editors.AbstractRenderingEngine;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PreviewAttributeEditor
extends AbstractAttributeEditor {
    private final RichTextAttributeEditor editor;
    private boolean ignoreLocationEvents;
    private final AbstractRenderingEngine renderingEngine;

    public PreviewAttributeEditor(AttributeManager manager, RepositoryTaskAttribute taskAttribute, AbstractRenderingEngine renderingEngine, RichTextAttributeEditor editor) {
        super(manager, taskAttribute);
        Assert.isNotNull((Object)editor);
        Assert.isNotNull((Object)renderingEngine);
        this.editor = editor;
        this.renderingEngine = renderingEngine;
    }

    private Browser addBrowser(Composite parent, int style) {
        Browser browser = new Browser(parent, style);
        browser.addLocationListener((LocationListener)new LocationAdapter(){

            public void changing(LocationEvent event) {
                if (PreviewAttributeEditor.this.ignoreLocationEvents) {
                    return;
                }
                if (event.location != null && !event.location.startsWith("about")) {
                    event.doit = false;
                    TaskUrlHyperlink link = new TaskUrlHyperlink((IRegion)new Region(0, 0), event.location);
                    link.open();
                }
            }
        });
        return browser;
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        Composite sectionComposite = toolkit.createComposite(parent);
        sectionComposite.setLayout((Layout)new GridLayout(1, false));
        Composite editorComposite = toolkit.createComposite(sectionComposite);
        editorComposite.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        GridData gd = new GridData(1808);
        gd.widthHint = 500;
        gd.minimumHeight = 140;
        gd.grabExcessHorizontalSpace = true;
        editorComposite.setLayoutData((Object)gd);
        StackLayout descriptionLayout = new StackLayout();
        editorComposite.setLayout((Layout)descriptionLayout);
        this.editor.createControl(editorComposite, toolkit);
        Composite buttonComposite = toolkit.createComposite(sectionComposite);
        buttonComposite.setLayout((Layout)new GridLayout());
        this.createPreviewButton(buttonComposite, (TextViewer)this.editor.getViewer(), editorComposite, descriptionLayout, toolkit);
    }

    private void createPreviewButton(Composite buttonComposite, TextViewer editor, Composite editorComposite, StackLayout editorLayout, FormToolkit toolkit) {
        new Object(toolkit, buttonComposite, editorComposite, editor, editorLayout){
            private static final String LABEL_BUTTON_EDIT = "Edit";
            private static final String LABEL_BUTTON_PREVIEW = "Preview";
            private int buttonState = 0;
            private Browser previewBrowser;
            private Button previewButton;
            {
                this.previewButton = formToolkit.createButton(composite, LABEL_BUTTON_PREVIEW, 8);
                GridData previewButtonData = new GridData(32);
                previewButtonData.widthHint = 100;
                this.previewButton.setLayoutData((Object)previewButtonData);
                this.previewButton.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        if (previewBrowser == null) {
                            previewBrowser = PreviewAttributeEditor.this.addBrowser(composite2, 0);
                        }
                        2 v0 = this;
                        int n = v0.buttonState + 1;
                        v0.buttonState = n;
                        buttonState = n % 2;
                        if (buttonState == 1) {
                            PreviewAttributeEditor.this.setText(previewBrowser, "Loading preview...");
                            PreviewAttributeEditor.this.previewWiki(previewBrowser, textViewer.getTextWidget().getText());
                        }
                        previewButton.setText(buttonState == 0 ? 2.LABEL_BUTTON_PREVIEW : 2.LABEL_BUTTON_EDIT);
                        stackLayout.topControl = buttonState == 0 ? textViewer.getControl() : previewBrowser;
                        composite2.layout();
                    }
                });
            }
        };
    }

    private void previewWiki(final Browser browser, String sourceText) {
        final class PreviewWikiJob
        extends Job {
            private String htmlText;
            private IStatus jobStatus;
            private final String sourceText;

            public PreviewWikiJob(String sourceText) {
                super("Formatting Wiki Text");
                if (sourceText == null) {
                    throw new IllegalArgumentException("source text must not be null");
                }
                this.sourceText = sourceText;
            }

            public String getHtmlText() {
                return this.htmlText;
            }

            public IStatus getStatus() {
                return this.jobStatus;
            }

            protected IStatus run(IProgressMonitor monitor) {
                if (PreviewAttributeEditor.this.renderingEngine == null) {
                    this.jobStatus = new RepositoryStatus(PreviewAttributeEditor.this.getAttributeEditorManager().getTaskRepository(), 1, "org.eclipse.mylyn.tasks.ui", 7, "The repository does not support HTML preview.");
                    return Status.OK_STATUS;
                }
                this.jobStatus = Status.OK_STATUS;
                try {
                    this.htmlText = PreviewAttributeEditor.this.renderingEngine.renderAsHtml(PreviewAttributeEditor.this.getAttributeEditorManager().getTaskRepository(), this.sourceText, monitor);
                }
                catch (CoreException e) {
                    this.jobStatus = e.getStatus();
                }
                return Status.OK_STATUS;
            }
        }
        final PreviewWikiJob job = new PreviewWikiJob(sourceText);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){
            {
            }

            public void done(IJobChangeEvent event) {
                if (!PreviewAttributeEditor.this.getControl().isDisposed()) {
                    if (job.getStatus().isOK()) {
                        PreviewAttributeEditor.this.getControl().getDisplay().asyncExec(new Runnable(){
                            {
                            }

                            public void run() {
                                PreviewAttributeEditor.this.setText(browser, job.getHtmlText());
                            }
                        });
                    } else {
                        PreviewAttributeEditor.this.getControl().getDisplay().asyncExec(new Runnable(){
                            {
                            }

                            public void run() {
                                StatusHandler.displayStatus((String)"Error", (IStatus)job.getStatus());
                            }
                        });
                    }
                }
                super.done(event);
            }
        });
        job.setUser(true);
        job.schedule();
    }

    private void setText(Browser browser, String html) {
        try {
            this.ignoreLocationEvents = true;
            browser.setText(html != null ? html : "");
        }
        finally {
            this.ignoreLocationEvents = false;
        }
    }
}

