/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.util.Iterator;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.mylyn.internal.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.internal.tasks.ui.editors.AttributeManager;
import org.eclipse.mylyn.internal.tasks.ui.editors.LayoutHint;
import org.eclipse.mylyn.internal.tasks.ui.editors.RepositoryTextViewer;
import org.eclipse.mylyn.tasks.core.RepositoryTaskAttribute;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.editors.TaskTextViewerConfiguration;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.themes.IThemeManager;

public class RichTextAttributeEditor
extends AbstractAttributeEditor {
    private RepositoryTextViewer viewer;
    private boolean spellCheckingEnabled;
    private final int style;

    public RichTextAttributeEditor(AttributeManager manager, RepositoryTaskAttribute taskAttribute) {
        this(manager, taskAttribute, RichTextAttributeEditor.getDefaultStyle(taskAttribute));
    }

    private static int getDefaultStyle(RepositoryTaskAttribute taskAttribute) {
        return taskAttribute.isReadOnly() ? 2 : 514;
    }

    public RichTextAttributeEditor(AttributeManager manager, RepositoryTaskAttribute taskAttribute, int style) {
        super(manager, taskAttribute);
        this.style = style;
        this.setLayoutHint(new LayoutHint(LayoutHint.RowSpan.MULTIPLE, LayoutHint.ColumnSpan.MULTIPLE));
    }

    private void configureAsTextEditor(Document document) {
        AnnotationModel annotationModel = new AnnotationModel();
        this.viewer.showAnnotations(false);
        this.viewer.showAnnotationsOverview(false);
        DefaultMarkerAnnotationAccess annotationAccess = new DefaultMarkerAnnotationAccess();
        final SourceViewerDecorationSupport support = new SourceViewerDecorationSupport((ISourceViewer)this.viewer, null, (IAnnotationAccess)annotationAccess, EditorsUI.getSharedTextColors());
        Iterator e = new MarkerAnnotationPreferences().getAnnotationPreferences().iterator();
        while (e.hasNext()) {
            support.setAnnotationPreference((AnnotationPreference)e.next());
        }
        support.install(EditorsUI.getPreferenceStore());
        this.viewer.getTextWidget().setIndent(2);
        this.viewer.getTextWidget().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                support.uninstall();
            }
        });
        this.viewer.setDocument((IDocument)document, (IAnnotationModel)annotationModel);
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        TaskRepository taskRepository = this.getAttributeEditorManager().getTaskRepository();
        this.viewer = new RepositoryTextViewer(taskRepository, parent, 0x800040 | this.style);
        TaskTextViewerConfiguration viewerConfig = new TaskTextViewerConfiguration(this.spellCheckingEnabled);
        this.viewer.configure((SourceViewerConfiguration)viewerConfig);
        Document document = new Document(this.getValue());
        if (this.getTaskAttribute().isReadOnly()) {
            this.viewer.setEditable(false);
            this.viewer.setDocument((IDocument)document);
        } else {
            this.viewer.setEditable(true);
            this.configureAsTextEditor(document);
            this.viewer.addTextListener(new ITextListener(){

                public void textChanged(TextEvent event) {
                    RichTextAttributeEditor.this.setValue(RichTextAttributeEditor.this.viewer.getTextWidget().getText());
                }
            });
            this.viewer.getControl().setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        }
        IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
        Font font = themeManager.getCurrentTheme().getFontRegistry().get("org.eclipse.mylyn.tasks.ui.fonts.task.editor.comment");
        this.viewer.getTextWidget().setFont(font);
        toolkit.adapt((Control)this.viewer.getTextWidget(), true, true);
        this.setControl((Control)this.viewer.getTextWidget());
    }

    public String getValue() {
        return this.getAttributeMapper().getValue(this.getTaskAttribute());
    }

    public SourceViewer getViewer() {
        return this.viewer;
    }

    public boolean isSpellCheckingEnabled() {
        return this.spellCheckingEnabled;
    }

    public void setSpellCheckingEnabled(boolean spellCheckingEnabled) {
        this.spellCheckingEnabled = spellCheckingEnabled;
    }

    public void setValue(String value) {
        this.getAttributeMapper().setValue(this.getTaskAttribute(), value);
        this.attributeChanged();
    }
}

