/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.mylyn.internal.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.internal.tasks.ui.editors.AttributeManager;
import org.eclipse.mylyn.tasks.core.RepositoryTaskAttribute;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SingleSelectionAttributeEditor
extends AbstractAttributeEditor {
    private String[] values;
    private CCombo combo;

    public SingleSelectionAttributeEditor(AttributeManager manager, RepositoryTaskAttribute taskAttribute) {
        super(manager, taskAttribute);
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        this.combo = new CCombo(parent, 0x800008);
        toolkit.adapt((Control)this.combo, true, true);
        this.combo.setFont(TEXT_FONT);
        this.combo.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        Map labelByValue = this.getAttributeMapper().getOptions(this.getTaskAttribute());
        if (labelByValue != null) {
            String[] stringArray = this.values = labelByValue.keySet().toArray(new String[0]);
            int n = this.values.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                this.combo.add((String)labelByValue.get(value));
                ++n2;
            }
        }
        this.select(this.getValue(), this.getValueLabel());
        if (this.values != null) {
            this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    int index = SingleSelectionAttributeEditor.this.combo.getSelectionIndex();
                    if (index > -1) {
                        Assert.isNotNull((Object)SingleSelectionAttributeEditor.this.values);
                        Assert.isLegal((index >= 0 && index <= SingleSelectionAttributeEditor.this.values.length - 1 ? 1 : 0) != 0);
                        SingleSelectionAttributeEditor.this.setValue(SingleSelectionAttributeEditor.this.values[index]);
                    }
                }
            });
        }
        this.setControl((Control)this.combo);
    }

    public String getValue() {
        return this.getAttributeMapper().getValue(this.getTaskAttribute());
    }

    public String getValueLabel() {
        return this.getAttributeMapper().getValueLabel(this.getTaskAttribute());
    }

    private void select(String value, String label) {
        if (this.values != null) {
            int i = 0;
            while (i < this.values.length) {
                if (this.values[i].equals(value)) {
                    this.combo.select(i);
                    break;
                }
                ++i;
            }
        } else {
            this.combo.setText(label);
        }
    }

    public void setValue(String value) {
        this.getAttributeMapper().setValue(this.getTaskAttribute(), value);
        this.attributeChanged();
    }
}

