/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.internal.tasks.core.UnmatchedTaskContainer;
import org.eclipse.mylyn.internal.tasks.ui.AddExistingTaskJob;
import org.eclipse.mylyn.internal.tasks.ui.IDynamicSubMenuContributor;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.internal.tasks.ui.actions.AbstractTaskEditorAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.AttachAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.AttachScreenshotAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.CopyTaskDetailsAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.NewTaskFromSelectionAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.OpenWithBrowserAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.ShowInTaskListAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.SynchronizeEditorAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.TaskActivateAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.TaskDeactivateAction;
import org.eclipse.mylyn.internal.tasks.ui.editors.AbstractTaskEditorPage;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskPlanningEditor;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.ui.editors.AbstractRepositoryTaskEditor;
import org.eclipse.mylyn.tasks.ui.editors.NewTaskEditorInput;
import org.eclipse.mylyn.tasks.ui.editors.RepositoryTaskEditorInput;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.mylyn.tasks.ui.editors.TaskFormPage;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.SubActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.internal.ObjectActionContributorManager;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.progress.IProgressService;

public class TaskEditorActionContributor
extends MultiPageEditorActionBarContributor
implements ISelectionChangedListener {
    private SubActionBars sourceActionBars;
    private TaskEditor editor;
    private OpenWithBrowserAction openWithBrowserAction = new OpenWithBrowserAction();
    private CopyTaskDetailsAction copyTaskDetailsAction = new CopyTaskDetailsAction();
    private AbstractTaskEditorAction attachAction = new AttachAction();
    private AbstractTaskEditorAction attachScreenshotAction = new AttachScreenshotAction();
    private SynchronizeEditorAction synchronizeEditorAction = new SynchronizeEditorAction();
    private ShowInTaskListAction showInTaskListAction = new ShowInTaskListAction();
    private NewTaskFromSelectionAction newTaskFromSelectionAction = new NewTaskFromSelectionAction();
    private GlobalAction cutAction;
    private GlobalAction undoAction;
    private GlobalAction redoAction;
    private GlobalAction copyAction;
    private GlobalAction pasteAction;
    private GlobalAction selectAllAction;
    protected List<TextViewer> textViewers = new ArrayList<TextViewer>();

    public TaskEditorActionContributor() {
        this.cutAction = new GlobalAction(ActionFactory.CUT.getId());
        this.cutAction.setText(WorkbenchMessages.Workbench_cut);
        this.cutAction.setToolTipText(WorkbenchMessages.Workbench_cutToolTip);
        this.cutAction.setImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_CUT"));
        this.cutAction.setHoverImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_CUT"));
        this.cutAction.setDisabledImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_CUT_DISABLED"));
        this.cutAction.setActionDefinitionId("org.eclipse.ui.edit.cut");
        this.pasteAction = new GlobalAction(ActionFactory.PASTE.getId());
        this.pasteAction.setText(WorkbenchMessages.Workbench_paste);
        this.pasteAction.setToolTipText(WorkbenchMessages.Workbench_pasteToolTip);
        this.pasteAction.setImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_PASTE"));
        this.pasteAction.setHoverImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_PASTE"));
        this.pasteAction.setDisabledImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_PASTE_DISABLED"));
        this.pasteAction.setActionDefinitionId("org.eclipse.ui.edit.paste");
        this.copyAction = new GlobalAction(ActionFactory.COPY.getId());
        this.copyAction.setText(WorkbenchMessages.Workbench_copy);
        this.copyAction.setImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_COPY"));
        this.copyAction.setHoverImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_COPY"));
        this.copyAction.setDisabledImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_COPY_DISABLED"));
        this.copyAction.setActionDefinitionId("org.eclipse.ui.edit.copy");
        this.undoAction = new GlobalAction(ActionFactory.UNDO.getId());
        this.undoAction.setText(WorkbenchMessages.Workbench_undo);
        this.undoAction.setImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_UNDO"));
        this.undoAction.setHoverImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_UNDO"));
        this.undoAction.setDisabledImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_UNDO_DISABLED"));
        this.undoAction.setActionDefinitionId("org.eclipse.ui.edit.undo");
        this.redoAction = new GlobalAction(ActionFactory.REDO.getId());
        this.redoAction.setText(WorkbenchMessages.Workbench_redo);
        this.redoAction.setImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_REDO"));
        this.redoAction.setHoverImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_REDO"));
        this.redoAction.setDisabledImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_REDO_DISABLED"));
        this.redoAction.setActionDefinitionId("org.eclipse.ui.edit.redo");
        this.selectAllAction = new GlobalAction(ActionFactory.SELECT_ALL.getId());
        this.selectAllAction.setText(WorkbenchMessages.Workbench_selectAll);
        this.selectAllAction.setActionDefinitionId("org.eclipse.ui.edit.selectAll");
        this.selectAllAction.setEnabled(true);
    }

    public void addClipboardActions(IMenuManager manager) {
        manager.add((IAction)this.undoAction);
        manager.add((IAction)this.redoAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.cutAction);
        manager.add((IAction)this.copyAction);
        manager.add((IAction)this.copyTaskDetailsAction);
        manager.add((IAction)this.pasteAction);
        manager.add((IAction)this.selectAllAction);
        manager.add((IAction)this.newTaskFromSelectionAction);
        manager.add((IContributionItem)new Separator());
    }

    public void contextMenuAboutToShow(IMenuManager mng) {
        IFormPage page = this.getEditor().getActivePageInstance();
        boolean addClipboard = page instanceof TaskPlanningEditor || page instanceof AbstractRepositoryTaskEditor || page instanceof AbstractTaskEditorPage;
        this.contextMenuAboutToShow(mng, addClipboard);
    }

    public void contextMenuAboutToShow(IMenuManager manager, boolean addClipboard) {
        if (this.editor != null) {
            this.updateSelectableActions(this.editor.getSelection());
        }
        if (addClipboard) {
            this.addClipboardActions(manager);
        }
        if (this.editor.getTaskEditorInput() == null && !(this.editor.getEditorInput() instanceof NewTaskEditorInput)) {
            MenuManager subMenuManager = new MenuManager("Add to Task List");
            ArrayList categories = new ArrayList(TasksUiPlugin.getTaskListManager().getTaskList().getCategories());
            Collections.sort(categories);
            for (final AbstractTaskCategory category : categories) {
                if (category instanceof UnmatchedTaskContainer) continue;
                Action action = new Action(){

                    public void run() {
                        TaskEditorActionContributor.this.moveToCategory(category);
                    }
                };
                String text = category.getSummary();
                action.setText(text);
                action.setImageDescriptor(TasksUiImages.CATEGORY);
                subMenuManager.add((IAction)action);
            }
            this.copyTaskDetailsAction.selectionChanged((IStructuredSelection)new StructuredSelection((Object)this.editor.getSelection()));
            manager.add((IContributionItem)subMenuManager);
            return;
        }
        if (this.editor.getEditorInput() instanceof NewTaskEditorInput) {
            return;
        }
        final AbstractTask task = this.editor.getTaskEditorInput().getTask();
        if (task == null) {
            return;
        }
        StructuredSelection selection = new StructuredSelection((Object)task);
        this.openWithBrowserAction.selectionChanged((IStructuredSelection)selection);
        this.copyTaskDetailsAction.selectionChanged((IStructuredSelection)selection);
        this.attachAction.selectionChanged((IStructuredSelection)selection);
        this.attachAction.setEditor(this.editor);
        this.attachScreenshotAction.selectionChanged((IStructuredSelection)selection);
        this.attachScreenshotAction.setEditor(this.editor);
        this.synchronizeEditorAction.selectionChanged((IStructuredSelection)new StructuredSelection((Object)this.getEditor()));
        this.showInTaskListAction.selectionChanged((IStructuredSelection)selection);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.synchronizeEditorAction);
        manager.add((IAction)this.openWithBrowserAction);
        if (task.isActive()) {
            manager.add((IAction)new TaskDeactivateAction(){

                public void run() {
                    super.run(task);
                }
            });
        } else {
            manager.add((IAction)new TaskActivateAction(){

                public void run() {
                    super.run(task);
                }
            });
        }
        manager.add((IAction)this.showInTaskListAction);
        manager.add((IContributionItem)new Separator());
        for (String menuPath : TasksUiPlugin.getDefault().getDynamicMenuMap().keySet()) {
            for (IDynamicSubMenuContributor contributor : TasksUiPlugin.getDefault().getDynamicMenuMap().get(menuPath)) {
                if (!"tasks".equals(menuPath)) continue;
                ArrayList<AbstractTaskContainer> selectedElements = new ArrayList<AbstractTaskContainer>();
                selectedElements.add((AbstractTaskContainer)task);
                MenuManager subMenuManager = contributor.getSubMenuManager(selectedElements);
                if (subMenuManager == null) continue;
                manager.add((IContributionItem)subMenuManager);
            }
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.attachAction);
        manager.add((IAction)this.attachScreenshotAction);
        manager.add((IContributionItem)new Separator());
        ObjectActionContributorManager.getManager().contributeObjectActions((IWorkbenchPart)this.editor, manager, new ISelectionProvider(){

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public ISelection getSelection() {
                return new StructuredSelection((Object)task);
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public void setSelection(ISelection selection) {
            }
        });
        manager.add((IContributionItem)new GroupMarker("additions"));
    }

    private void moveToCategory(AbstractTaskCategory category) {
        IEditorInput input = this.getEditor().getEditorInput();
        if (input instanceof RepositoryTaskEditorInput) {
            RepositoryTaskEditorInput repositoryTaskEditorInput = (RepositoryTaskEditorInput)input;
            final IProgressService svc = PlatformUI.getWorkbench().getProgressService();
            final AddExistingTaskJob job = new AddExistingTaskJob(repositoryTaskEditorInput.getRepository(), repositoryTaskEditorInput.getId(), category);
            job.schedule();
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    svc.showInDialog(TaskEditorActionContributor.this.getEditor().getSite().getShell(), (Job)job);
                }
            });
        }
    }

    public void updateSelectableActions(ISelection selection) {
        if (this.editor != null) {
            this.cutAction.selectionChanged(selection);
            this.copyAction.selectionChanged(selection);
            this.pasteAction.selectionChanged(selection);
            this.undoAction.selectionChanged(selection);
            this.redoAction.selectionChanged(selection);
            this.selectAllAction.selectionChanged(selection);
            this.newTaskFromSelectionAction.selectionChanged(selection);
        }
    }

    public void contributeToMenu(IMenuManager mm) {
    }

    public void contributeToStatusLine(IStatusLineManager slm) {
    }

    public void contributeToToolBar(IToolBarManager tbm) {
    }

    public void contributeToCoolBar(ICoolBarManager cbm) {
    }

    public void dispose() {
        this.sourceActionBars.dispose();
        super.dispose();
    }

    public void init(IActionBars bars) {
        super.init(bars);
        this.sourceActionBars = new SubActionBars(bars);
    }

    public void init(IActionBars bars, IWorkbenchPage page) {
        super.init(bars, page);
        this.registerGlobalHandlers(bars);
    }

    public TaskEditor getEditor() {
        return this.editor;
    }

    public IStatusLineManager getStatusLineManager() {
        return this.getActionBars().getStatusLineManager();
    }

    public void setActiveEditor(IEditorPart targetEditor) {
        if (targetEditor instanceof TaskEditor) {
            this.editor = (TaskEditor)targetEditor;
            this.updateSelectableActions(this.editor.getSelection());
        }
    }

    public void setActivePage(IEditorPart newEditor) {
        if (this.getEditor() != null) {
            this.updateSelectableActions(this.getEditor().getSelection());
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateSelectableActions(event.getSelection());
    }

    public void registerGlobalHandlers(IActionBars bars) {
        bars.setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)this.cutAction);
        bars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.pasteAction);
        bars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
        bars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.undoAction);
        bars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.redoAction);
        bars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)this.selectAllAction);
        bars.updateActionBars();
    }

    public void unregisterGlobalHandlers(IActionBars bars) {
        bars.setGlobalActionHandler(ActionFactory.CUT.getId(), null);
        bars.setGlobalActionHandler(ActionFactory.PASTE.getId(), null);
        bars.setGlobalActionHandler(ActionFactory.COPY.getId(), null);
        bars.setGlobalActionHandler(ActionFactory.UNDO.getId(), null);
        bars.setGlobalActionHandler(ActionFactory.REDO.getId(), null);
        bars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), null);
        bars.updateActionBars();
    }

    public void forceActionsEnabled() {
        this.cutAction.setEnabled(true);
        this.copyAction.setEnabled(true);
        this.pasteAction.setEnabled(true);
        this.selectAllAction.setEnabled(true);
        this.undoAction.setEnabled(false);
        this.redoAction.setEnabled(false);
    }

    private boolean canPerformAction(String actionId) {
        Control focusControl = this.getFocusControl();
        if (focusControl instanceof StyledText) {
            for (TextViewer viewer : this.textViewers) {
                if (viewer.getTextWidget() != focusControl) continue;
                return this.canDoGlobalAction(actionId, viewer);
            }
        } else {
            return !actionId.equals(ActionFactory.UNDO.getId()) && !actionId.equals(ActionFactory.REDO.getId());
        }
        return false;
    }

    private Control getFocusControl() {
        IFormPage activePage = this.getEditor().getActivePageInstance();
        if (activePage == null) {
            return null;
        }
        IManagedForm form = activePage.getManagedForm();
        if (form == null) {
            return null;
        }
        ScrolledForm control = form.getForm();
        if (control == null || control.isDisposed()) {
            return null;
        }
        Display display = control.getDisplay();
        Control focusControl = display.getFocusControl();
        if (focusControl == null || focusControl.isDisposed()) {
            return null;
        }
        return focusControl;
    }

    private void doAction(String actionId) {
        Control focusControl = this.getFocusControl();
        if (focusControl == null) {
            return;
        }
        if (this.canPerformDirectly(actionId, focusControl)) {
            return;
        }
        if (focusControl instanceof StyledText) {
            for (TextViewer viewer : this.textViewers) {
                if (viewer.getTextWidget() != focusControl) continue;
                this.doGlobalAction(actionId, viewer);
                return;
            }
        }
    }

    private boolean doGlobalAction(String actionId, TextViewer textViewer) {
        if (actionId.equals(ActionFactory.CUT.getId())) {
            textViewer.doOperation(3);
            return true;
        }
        if (actionId.equals(ActionFactory.COPY.getId())) {
            textViewer.doOperation(4);
            return true;
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            textViewer.doOperation(5);
            return true;
        }
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            textViewer.doOperation(6);
            return true;
        }
        if (actionId.equals(ActionFactory.UNDO.getId())) {
            textViewer.doOperation(1);
            return true;
        }
        if (actionId.equals(ActionFactory.REDO.getId())) {
            textViewer.doOperation(2);
            return true;
        }
        if (actionId.equals(ActionFactory.SELECT_ALL.getId())) {
            textViewer.doOperation(7);
            return true;
        }
        return false;
    }

    private boolean canPerformDirectly(String id, Control control) {
        if (control instanceof Text) {
            Text text = (Text)control;
            if (id.equals(ActionFactory.CUT.getId())) {
                text.cut();
                return true;
            }
            if (id.equals(ActionFactory.COPY.getId())) {
                text.copy();
                return true;
            }
            if (id.equals(ActionFactory.PASTE.getId())) {
                text.paste();
                return true;
            }
            if (id.equals(ActionFactory.SELECT_ALL.getId())) {
                text.selectAll();
                return true;
            }
            if (id.equals(ActionFactory.DELETE.getId())) {
                int count = text.getSelectionCount();
                if (count == 0) {
                    int caretPos = text.getCaretPosition();
                    text.setSelection(caretPos, caretPos + 1);
                }
                text.insert("");
                return true;
            }
        }
        return false;
    }

    public void addTextViewer(TextViewer textViewer) {
        this.textViewers.add(textViewer);
    }

    private boolean canDoGlobalAction(String actionId, TextViewer textViewer) {
        if (actionId.equals(ActionFactory.CUT.getId())) {
            return textViewer.canDoOperation(3);
        }
        if (actionId.equals(ActionFactory.COPY.getId())) {
            return textViewer.canDoOperation(4);
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            return textViewer.canDoOperation(5);
        }
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            return textViewer.canDoOperation(6);
        }
        if (actionId.equals(ActionFactory.UNDO.getId())) {
            return textViewer.canDoOperation(1);
        }
        if (actionId.equals(ActionFactory.REDO.getId())) {
            return textViewer.canDoOperation(2);
        }
        if (actionId.equals(ActionFactory.SELECT_ALL.getId())) {
            return textViewer.canDoOperation(7);
        }
        return false;
    }

    private class GlobalAction
    extends Action {
        private String actionId;

        public GlobalAction(String actionId) {
            this.actionId = actionId;
        }

        public void run() {
            if (TaskEditorActionContributor.this.getEditor().getActivePageInstance() instanceof TaskFormPage) {
                TaskFormPage editor = (TaskFormPage)TaskEditorActionContributor.this.getEditor().getActivePageInstance();
                editor.doAction(this.actionId);
                TaskEditorActionContributor.this.updateSelectableActions(TaskEditorActionContributor.this.getEditor().getSelection());
            } else {
                TaskEditorActionContributor.this.doAction(this.actionId);
                TaskEditorActionContributor.this.updateSelectableActions(TaskEditorActionContributor.this.getEditor().getSelection());
            }
        }

        public void selectionChanged(ISelection selection) {
            if (TaskEditorActionContributor.this.getEditor().getActivePageInstance() instanceof TaskFormPage) {
                TaskFormPage editor = (TaskFormPage)TaskEditorActionContributor.this.getEditor().getActivePageInstance();
                this.setEnabled(editor.canPerformAction(this.actionId));
            } else {
                this.setEnabled(TaskEditorActionContributor.this.canPerformAction(this.actionId));
            }
        }
    }
}

