/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.internal.tasks.ui.editors.AbstractTaskEditorPage;
import org.eclipse.mylyn.internal.tasks.ui.editors.AbstractTaskEditorPart;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.tasks.core.RepositoryOperation;
import org.eclipse.mylyn.tasks.core.TaskList;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class TaskEditorActionPart
extends AbstractTaskEditorPart {
    private static final int DEFAULT_FIELD_WIDTH = 150;
    private static final String LABEL_BUTTON_SUBMIT = "Submit";
    private static final int RADIO_OPTION_WIDTH = 120;
    private Control[] radioOptions;
    private Button[] radios;
    private Button submitButton;
    private Button attachContextButton;
    private boolean needsAttachContext = true;
    private boolean needsAddToCategory;
    private Button addToCategory;
    private CCombo categoryChooser;
    private AbstractTaskCategory category;

    public TaskEditorActionPart(AbstractTaskEditorPage taskEditorPage) {
        super(taskEditorPage);
    }

    protected void addAttachContextButton(Composite buttonComposite, AbstractTask task, FormToolkit toolkit) {
        this.attachContextButton = toolkit.createButton(buttonComposite, "Attach Context", 32);
        this.attachContextButton.setImage(TasksUiImages.getImage(TasksUiImages.CONTEXT_ATTACH));
    }

    private void createActionButtons(Composite buttonComposite, FormToolkit toolkit) {
        this.submitButton = toolkit.createButton(buttonComposite, LABEL_BUTTON_SUBMIT, 0);
        GridData submitButtonData = new GridData(32);
        submitButtonData.widthHint = 100;
        this.submitButton.setImage(TasksUiImages.getImage(TasksUiImages.REPOSITORY_SUBMIT));
        this.submitButton.setLayoutData((Object)submitButtonData);
        this.submitButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TaskEditorActionPart.this.getTaskEditorPage().submitToRepository();
            }
        });
        this.setSubmitEnabled(true);
        toolkit.createLabel(buttonComposite, "    ");
        AbstractTask task = TasksUiPlugin.getTaskListManager().getTaskList().getTask(this.getTaskRepository().getUrl(), this.getTaskData().getId());
        if (this.needsAttachContext && task != null) {
            this.addAttachContextButton(buttonComposite, task, toolkit);
        }
    }

    private void createCategoryChooser(Composite buttonComposite, FormToolkit toolkit) {
        this.addToCategory = this.getManagedForm().getToolkit().createButton(buttonComposite, "Add to Category", 32);
        this.categoryChooser = new CCombo(buttonComposite, 0x800008);
        this.categoryChooser.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.categoryChooser.setLayoutData((Object)GridDataFactory.swtDefaults().hint(150, -1).create());
        toolkit.adapt((Control)this.categoryChooser, true, true);
        this.categoryChooser.setFont(TEXT_FONT);
        TaskList taskList = TasksUiPlugin.getTaskListManager().getTaskList();
        ArrayList categories = new ArrayList(taskList.getCategories());
        Collections.sort(categories, new Comparator<AbstractTaskContainer>(){

            @Override
            public int compare(AbstractTaskContainer c1, AbstractTaskContainer c2) {
                if (c1.equals((Object)TasksUiPlugin.getTaskListManager().getTaskList().getDefaultCategory())) {
                    return -1;
                }
                if (c2.equals((Object)TasksUiPlugin.getTaskListManager().getTaskList().getDefaultCategory())) {
                    return 1;
                }
                return c1.getSummary().compareToIgnoreCase(c2.getSummary());
            }
        });
        for (AbstractTaskContainer category : categories) {
            this.categoryChooser.add(category.getSummary());
        }
        this.categoryChooser.select(0);
        this.categoryChooser.setEnabled(false);
        this.categoryChooser.setData(categories);
        this.addToCategory.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TaskEditorActionPart.this.categoryChooser.setEnabled(TaskEditorActionPart.this.addToCategory.getSelection());
            }
        });
        GridDataFactory.fillDefaults().hint(150, -1).span(3, -1).applyTo((Control)this.categoryChooser);
    }

    public void commit(boolean onSave) {
        if (this.needsAddToCategory()) {
            this.category = this.getCategoryInternal();
        }
        super.commit(onSave);
    }

    public AbstractTaskCategory getCategory() {
        return this.category;
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        Composite buttonComposite = toolkit.createComposite(parent);
        GridLayout buttonLayout = new GridLayout();
        GridDataFactory.fillDefaults().align(4, 128).applyTo((Control)buttonComposite);
        buttonLayout.numColumns = 4;
        buttonComposite.setLayout((Layout)buttonLayout);
        if (this.needsAddToCategory) {
            this.createCategoryChooser(buttonComposite, toolkit);
        }
        this.createRadioButtons(buttonComposite, toolkit);
        this.createActionButtons(buttonComposite, toolkit);
        this.setControl((Control)buttonComposite);
    }

    private void createRadioButtons(Composite buttonComposite, FormToolkit toolkit) {
        int i = 0;
        Button selected = null;
        this.radios = new Button[this.getTaskData().getOperations().size()];
        this.radioOptions = new Control[this.getTaskData().getOperations().size()];
        for (RepositoryOperation o : this.getTaskData().getOperations()) {
            this.radios[i] = toolkit.createButton(buttonComposite, "", 16);
            this.radios[i].setFont(TEXT_FONT);
            GridData radioData = new GridData(32);
            radioData.horizontalSpan = !o.hasOptions() && !o.isInput() ? 4 : 1;
            radioData.heightHint = 20;
            String opName = o.getOperationName();
            opName = opName.replaceAll("</.*>", "");
            opName = opName.replaceAll("<.*>", "");
            this.radios[i].setText(opName);
            this.radios[i].setLayoutData((Object)radioData);
            this.radios[i].addSelectionListener((SelectionListener)new RadioButtonListener());
            if (o.hasOptions()) {
                radioData = new GridData(32);
                radioData.horizontalSpan = 3;
                radioData.heightHint = 20;
                radioData.widthHint = 120;
                this.radioOptions[i] = new CCombo(buttonComposite, 0x800008);
                this.radioOptions[i].setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
                toolkit.adapt(this.radioOptions[i], true, true);
                this.radioOptions[i].setFont(TEXT_FONT);
                this.radioOptions[i].setLayoutData((Object)radioData);
                Object[] a = o.getOptionNames().toArray();
                Arrays.sort(a);
                int j = 0;
                while (j < a.length) {
                    if (a[j] != null) {
                        ((CCombo)this.radioOptions[i]).add((String)a[j]);
                        if (((String)a[j]).equals(o.getOptionSelection())) {
                            ((CCombo)this.radioOptions[i]).select(j);
                        }
                    }
                    ++j;
                }
                ((CCombo)this.radioOptions[i]).addSelectionListener((SelectionListener)new RadioButtonListener());
            } else if (o.isInput()) {
                radioData = new GridData(32);
                radioData.horizontalSpan = 3;
                radioData.widthHint = 110;
                String assignmentValue = "";
                this.radioOptions[i] = toolkit.createText(buttonComposite, assignmentValue);
                this.radioOptions[i].setFont(TEXT_FONT);
                this.radioOptions[i].setLayoutData((Object)radioData);
                ((Text)this.radioOptions[i]).setText(o.getInputValue());
                ((Text)this.radioOptions[i]).addModifyListener((ModifyListener)new RadioButtonListener());
            }
            if (i == 0 || o.isChecked()) {
                if (selected != null) {
                    selected.setSelection(false);
                }
                selected = this.radios[i];
                this.radios[i].setSelection(true);
                if (o.hasOptions() && o.getOptionSelection() != null) {
                    int j = 0;
                    String[] stringArray = ((CCombo)this.radioOptions[i]).getItems();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s = stringArray[n2];
                        if (s.compareTo(o.getOptionSelection()) == 0) {
                            ((CCombo)this.radioOptions[i]).select(j);
                        }
                        ++j;
                        ++n2;
                    }
                }
                this.getTaskData().setSelectedOperation(o);
            }
            ++i;
        }
        toolkit.paintBordersFor(buttonComposite);
    }

    boolean getAttachContext() {
        if (this.attachContextButton == null || this.attachContextButton.isDisposed()) {
            return false;
        }
        return this.attachContextButton.getSelection();
    }

    private AbstractTaskCategory getCategoryInternal() {
        int index = this.categoryChooser.getSelectionIndex();
        if (this.addToCategory.getSelection() && index != -1) {
            return (AbstractTaskCategory)((List)this.categoryChooser.getData()).get(index);
        }
        return null;
    }

    boolean needsAddToCategory() {
        return this.needsAddToCategory;
    }

    boolean needsAttachContext() {
        return this.needsAttachContext;
    }

    public void setNeedsAddToCategory(boolean needsAddToCategory) {
        this.needsAddToCategory = needsAddToCategory;
    }

    void setNeedsAttachContext(boolean attachContextEnabled) {
        this.needsAttachContext = attachContextEnabled;
    }

    void setSubmitEnabled(boolean enabled) {
        if (this.submitButton != null && !this.submitButton.isDisposed()) {
            this.submitButton.setEnabled(enabled);
            if (enabled) {
                this.submitButton.setToolTipText("Submit to " + this.getTaskRepository().getUrl());
            }
        }
    }

    private class RadioButtonListener
    implements SelectionListener,
    ModifyListener {
        private RadioButtonListener() {
        }

        public void modifyText(ModifyEvent e) {
            Button selected = null;
            Button[] buttonArray = TaskEditorActionPart.this.radios;
            int n = buttonArray.length;
            int n2 = 0;
            while (n2 < n) {
                Button element = buttonArray[n2];
                if (element.getSelection()) {
                    selected = element;
                }
                ++n2;
            }
            int i = 0;
            while (i < TaskEditorActionPart.this.radios.length) {
                if (TaskEditorActionPart.this.radios[i] != e.widget && TaskEditorActionPart.this.radios[i] != selected) {
                    TaskEditorActionPart.this.radios[i].setSelection(false);
                }
                if (e.widget == TaskEditorActionPart.this.radios[i]) {
                    RepositoryOperation o = TaskEditorActionPart.this.getTaskData().getOperation(TaskEditorActionPart.this.radios[i].getText());
                    TaskEditorActionPart.this.getTaskData().setSelectedOperation(o);
                    TaskEditorActionPart.this.getTaskEditorPage().getAttributeManager().operationChanged(o);
                } else if (e.widget == TaskEditorActionPart.this.radioOptions[i]) {
                    RepositoryOperation o = TaskEditorActionPart.this.getTaskData().getOperation(TaskEditorActionPart.this.radios[i].getText());
                    o.setInputValue(((Text)TaskEditorActionPart.this.radioOptions[i]).getText());
                    if (TaskEditorActionPart.this.getTaskData().getSelectedOperation() != null) {
                        TaskEditorActionPart.this.getTaskData().getSelectedOperation().setChecked(false);
                    }
                    o.setChecked(true);
                    TaskEditorActionPart.this.getTaskData().setSelectedOperation(o);
                    TaskEditorActionPart.this.radios[i].setSelection(true);
                    if (selected != null && selected != TaskEditorActionPart.this.radios[i]) {
                        selected.setSelection(false);
                    }
                    TaskEditorActionPart.this.getTaskEditorPage().getAttributeManager().operationChanged(o);
                }
                ++i;
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            Button selected = null;
            Button[] buttonArray = TaskEditorActionPart.this.radios;
            int n = buttonArray.length;
            int n2 = 0;
            while (n2 < n) {
                Button element = buttonArray[n2];
                if (element.getSelection()) {
                    selected = element;
                }
                ++n2;
            }
            int i = 0;
            while (i < TaskEditorActionPart.this.radios.length) {
                if (TaskEditorActionPart.this.radios[i] != e.widget && TaskEditorActionPart.this.radios[i] != selected) {
                    TaskEditorActionPart.this.radios[i].setSelection(false);
                }
                if (e.widget == TaskEditorActionPart.this.radios[i]) {
                    RepositoryOperation o = TaskEditorActionPart.this.getTaskData().getOperation(TaskEditorActionPart.this.radios[i].getText());
                    TaskEditorActionPart.this.getTaskData().setSelectedOperation(o);
                    TaskEditorActionPart.this.getTaskEditorPage().getAttributeManager().operationChanged(o);
                } else if (e.widget == TaskEditorActionPart.this.radioOptions[i]) {
                    RepositoryOperation o = TaskEditorActionPart.this.getTaskData().getOperation(TaskEditorActionPart.this.radios[i].getText());
                    o.setOptionSelection(((CCombo)TaskEditorActionPart.this.radioOptions[i]).getItem(((CCombo)TaskEditorActionPart.this.radioOptions[i]).getSelectionIndex()));
                    if (TaskEditorActionPart.this.getTaskData().getSelectedOperation() != null) {
                        TaskEditorActionPart.this.getTaskData().getSelectedOperation().setChecked(false);
                    }
                    o.setChecked(true);
                    TaskEditorActionPart.this.getTaskData().setSelectedOperation(o);
                    TaskEditorActionPart.this.radios[i].setSelection(true);
                    if (selected != null && selected != TaskEditorActionPart.this.radios[i]) {
                        selected.setSelection(false);
                    }
                    TaskEditorActionPart.this.getTaskEditorPage().getAttributeManager().operationChanged(o);
                }
                ++i;
            }
        }
    }
}

