/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.io.File;
import java.util.Date;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.internal.tasks.ui.actions.AttachAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.AttachScreenshotAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.CopyAttachmentToClipboardJob;
import org.eclipse.mylyn.internal.tasks.ui.actions.DownloadAttachmentJob;
import org.eclipse.mylyn.internal.tasks.ui.editors.AbstractTaskEditorPage;
import org.eclipse.mylyn.internal.tasks.ui.editors.AbstractTaskEditorPart;
import org.eclipse.mylyn.internal.tasks.ui.editors.AttachmentTableLabelProvider;
import org.eclipse.mylyn.internal.tasks.ui.editors.AttachmentsTableContentProvider;
import org.eclipse.mylyn.internal.tasks.ui.editors.RepositoryAttachmentEditorInput;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.RepositoryAttachment;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.internal.ObjectActionContributorManager;
import org.eclipse.ui.internal.WorkbenchImages;

public class TaskEditorAttachmentPart
extends AbstractTaskEditorPart {
    private static final String ATTACHMENT_DEFAULT_NAME = "attachment";
    private static final String CTYPE_ZIP = "zip";
    private static final String CTYPE_OCTET_STREAM = "octet-stream";
    private static final String CTYPE_TEXT = "text";
    private static final String CTYPE_HTML = "html";
    private static final String LABEL_TEXT_EDITOR = "Text Editor";
    private static final String LABEL_COPY_URL_TO_CLIPBOARD = "Copy &URL";
    private static final String LABEL_COPY_TO_CLIPBOARD = "Copy Contents";
    private static final String LABEL_SAVE = "Save...";
    private static final String LABEL_BROWSER = "Browser";
    private static final String LABEL_DEFAULT_EDITOR = "Default Editor";
    private final String[] attachmentsColumns = new String[]{"Name", "Description", "Type", "Size", "Creator", "Created"};
    private final int[] attachmentsColumnWidths = new int[]{140, 160, 100, 70, 100, 100};
    private Table attachmentsTable;
    private TableViewer attachmentsTableViewer;
    private boolean supportsDelete;

    public TaskEditorAttachmentPart(AbstractTaskEditorPage taskEditorPage) {
        super(taskEditorPage);
    }

    private void createAttachmentTable(FormToolkit toolkit, Composite attachmentsComposite) {
        this.attachmentsTable = toolkit.createTable(attachmentsComposite, 67588);
        this.attachmentsTable.setLinesVisible(true);
        this.attachmentsTable.setHeaderVisible(true);
        this.attachmentsTable.setLayout((Layout)new GridLayout());
        GridData tableGridData = new GridData(4, 4, true, true);
        this.attachmentsTable.setLayoutData((Object)tableGridData);
        int i = 0;
        while (i < this.attachmentsColumns.length) {
            TableColumn column = new TableColumn(this.attachmentsTable, 16384, i);
            column.setText(this.attachmentsColumns[i]);
            column.setWidth(this.attachmentsColumnWidths[i]);
            ++i;
        }
        this.attachmentsTable.getColumn(3).setAlignment(131072);
        this.attachmentsTableViewer = new TableViewer(this.attachmentsTable);
        this.attachmentsTableViewer.setUseHashlookup(true);
        this.attachmentsTableViewer.setColumnProperties(this.attachmentsColumns);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.attachmentsTableViewer, (int)2);
        AbstractTaskDataHandler taskDataHandler = this.getConnector().getTaskDataHandler();
        if (taskDataHandler != null) {
            this.attachmentsTableViewer.setSorter(new ViewerSorter(){

                public int compare(Viewer viewer, Object e1, Object e2) {
                    RepositoryAttachment attachment1 = (RepositoryAttachment)e1;
                    RepositoryAttachment attachment2 = (RepositoryAttachment)e2;
                    Date created1 = TaskEditorAttachmentPart.this.getTaskData().getAttributeFactory().getDateForAttributeType("task.common.attachment.date", attachment1.getDateCreated());
                    Date created2 = TaskEditorAttachmentPart.this.getTaskData().getAttributeFactory().getDateForAttributeType("task.common.attachment.date", attachment2.getDateCreated());
                    if (created1 != null && created2 != null) {
                        return created1.compareTo(created2);
                    }
                    if (created1 == null && created2 != null) {
                        return -1;
                    }
                    if (created1 != null && created2 == null) {
                        return 1;
                    }
                    return 0;
                }
            });
        }
        this.attachmentsTableViewer.setContentProvider((IContentProvider)new AttachmentsTableContentProvider(this.getTaskData().getAttachments()));
        this.attachmentsTableViewer.setLabelProvider((IBaseLabelProvider)new AttachmentTableLabelProvider(null, (ILabelProvider)new LabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()));
        this.attachmentsTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (!event.getSelection().isEmpty()) {
                    StructuredSelection selection = (StructuredSelection)event.getSelection();
                    RepositoryAttachment attachment = (RepositoryAttachment)selection.getFirstElement();
                    TasksUiUtil.openUrl(attachment.getUrl(), false);
                }
            }
        });
        this.attachmentsTableViewer.setInput((Object)this.getTaskData());
    }

    private void createAttachmentTableMenu() {
        final Action openWithBrowserAction = new Action(LABEL_BROWSER){

            public void run() {
                RepositoryAttachment attachment = (RepositoryAttachment)((StructuredSelection)TaskEditorAttachmentPart.this.attachmentsTableViewer.getSelection()).getFirstElement();
                if (attachment != null) {
                    TasksUiUtil.openUrl(attachment.getUrl(), false);
                }
            }
        };
        final Action openWithDefaultAction = new Action(LABEL_DEFAULT_EDITOR){

            public void run() {
                RepositoryAttachment attachment = (RepositoryAttachment)((StructuredSelection)TaskEditorAttachmentPart.this.attachmentsTableViewer.getSelection()).getFirstElement();
                if (attachment == null) {
                    return;
                }
                if (attachment.getContentType().endsWith(TaskEditorAttachmentPart.CTYPE_HTML)) {
                    TasksUiUtil.openUrl(attachment.getUrl(), false);
                    return;
                }
                RepositoryAttachmentEditorInput input = new RepositoryAttachmentEditorInput(TaskEditorAttachmentPart.this.getTaskRepository(), attachment);
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                if (page == null) {
                    return;
                }
                IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(input.getName());
                try {
                    page.openEditor((IEditorInput)input, desc.getId());
                }
                catch (PartInitException e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Unable to open editor for: " + attachment.getDescription(), (Throwable)e));
                }
            }
        };
        final Action openWithTextEditorAction = new Action(LABEL_TEXT_EDITOR){

            public void run() {
                RepositoryAttachment attachment = (RepositoryAttachment)((StructuredSelection)TaskEditorAttachmentPart.this.attachmentsTableViewer.getSelection()).getFirstElement();
                RepositoryAttachmentEditorInput input = new RepositoryAttachmentEditorInput(TaskEditorAttachmentPart.this.getTaskRepository(), attachment);
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                if (page == null) {
                    return;
                }
                try {
                    page.openEditor((IEditorInput)input, "org.eclipse.ui.DefaultTextEditor");
                }
                catch (PartInitException e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Unable to open editor for: " + attachment.getDescription(), (Throwable)e));
                }
            }
        };
        final Action saveAction = new Action(LABEL_SAVE){

            public void run() {
                RepositoryAttachment attachment = (RepositoryAttachment)((StructuredSelection)TaskEditorAttachmentPart.this.attachmentsTableViewer.getSelection()).getFirstElement();
                FileDialog fileChooser = new FileDialog(TaskEditorAttachmentPart.this.attachmentsTable.getShell(), 8192);
                String fname = attachment.getAttributeValue("filename");
                if (fname.equals("")) {
                    String ctype = attachment.getContentType();
                    fname = ctype.endsWith(TaskEditorAttachmentPart.CTYPE_HTML) ? "attachment.html" : (ctype.startsWith(TaskEditorAttachmentPart.CTYPE_TEXT) ? "attachment.txt" : (ctype.endsWith(TaskEditorAttachmentPart.CTYPE_OCTET_STREAM) ? TaskEditorAttachmentPart.ATTACHMENT_DEFAULT_NAME : (ctype.endsWith(TaskEditorAttachmentPart.CTYPE_ZIP) ? "attachment.zip" : "attachment." + ctype.substring(ctype.indexOf("/") + 1))));
                }
                fileChooser.setFileName(fname);
                String filePath = fileChooser.open();
                if (filePath == null) {
                    return;
                }
                DownloadAttachmentJob job = new DownloadAttachmentJob(attachment, new File(filePath));
                job.setUser(true);
                job.schedule();
            }
        };
        final Action copyURLToClipAction = new Action(LABEL_COPY_URL_TO_CLIPBOARD){

            public void run() {
                RepositoryAttachment attachment = (RepositoryAttachment)((StructuredSelection)TaskEditorAttachmentPart.this.attachmentsTableViewer.getSelection()).getFirstElement();
                Clipboard clip = new Clipboard(PlatformUI.getWorkbench().getDisplay());
                clip.setContents(new Object[]{attachment.getUrl()}, new Transfer[]{TextTransfer.getInstance()});
                clip.dispose();
            }
        };
        final Action copyToClipAction = new Action(LABEL_COPY_TO_CLIPBOARD){

            public void run() {
                RepositoryAttachment attachment = (RepositoryAttachment)((StructuredSelection)TaskEditorAttachmentPart.this.attachmentsTableViewer.getSelection()).getFirstElement();
                CopyAttachmentToClipboardJob job = new CopyAttachmentToClipboardJob(attachment);
                job.setUser(true);
                job.schedule();
            }
        };
        final MenuManager popupMenu = new MenuManager();
        Menu menu = popupMenu.createContextMenu((Control)this.attachmentsTable);
        this.attachmentsTable.setMenu(menu);
        final MenuManager openMenu = new MenuManager("Open With");
        popupMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                popupMenu.removeAll();
                ISelection selection = TaskEditorAttachmentPart.this.attachmentsTableViewer.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                RepositoryAttachment att = (RepositoryAttachment)((StructuredSelection)selection).getFirstElement();
                popupMenu.add((IContributionItem)openMenu);
                openMenu.removeAll();
                RepositoryAttachmentEditorInput input = new RepositoryAttachmentEditorInput(TaskEditorAttachmentPart.this.getTaskRepository(), att);
                IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(input.getName());
                if (desc != null) {
                    openMenu.add((IAction)openWithDefaultAction);
                }
                openMenu.add((IAction)openWithBrowserAction);
                openMenu.add((IAction)openWithTextEditorAction);
                popupMenu.add((IContributionItem)new Separator());
                popupMenu.add((IAction)saveAction);
                popupMenu.add((IAction)copyURLToClipAction);
                if (att.getContentType().startsWith(TaskEditorAttachmentPart.CTYPE_TEXT) || att.getContentType().endsWith("xml")) {
                    popupMenu.add((IAction)copyToClipAction);
                }
                popupMenu.add((IContributionItem)new Separator("actions"));
                ObjectActionContributorManager.getManager().contributeObjectActions((IWorkbenchPart)TaskEditorAttachmentPart.this.getTaskEditorPage(), (IMenuManager)popupMenu, (ISelectionProvider)TaskEditorAttachmentPart.this.attachmentsTableViewer);
            }
        });
    }

    private void createButtons(Composite attachmentsComposite, FormToolkit toolkit) {
        Composite attachmentControlsComposite = toolkit.createComposite(attachmentsComposite);
        attachmentControlsComposite.setLayout((Layout)new GridLayout(2, false));
        attachmentControlsComposite.setLayoutData((Object)new GridData(1));
        Button attachFileButton = toolkit.createButton(attachmentControlsComposite, "Attach...", 8);
        attachFileButton.setImage(WorkbenchImages.getImage((String)"IMG_OBJ_FILE"));
        Button attachScreenshotButton = toolkit.createButton(attachmentControlsComposite, "Attach Screenshot...", 8);
        attachScreenshotButton.setImage(TasksUiImages.getImage(TasksUiImages.IMAGE_CAPTURE));
        final AbstractTask task = TasksUiPlugin.getTaskListManager().getTaskList().getTask(this.getTaskRepository().getUrl(), this.getTaskData().getId());
        if (task == null) {
            attachFileButton.setEnabled(false);
            attachScreenshotButton.setEnabled(false);
        }
        attachFileButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AttachAction attachFileAction = new AttachAction();
                attachFileAction.selectionChanged((IStructuredSelection)new StructuredSelection((Object)task));
                attachFileAction.setEditor(TaskEditorAttachmentPart.this.getTaskEditor());
                attachFileAction.run();
            }
        });
        attachScreenshotButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AttachScreenshotAction attachScreenshotAction = new AttachScreenshotAction();
                attachScreenshotAction.selectionChanged((IStructuredSelection)new StructuredSelection((Object)task));
                attachScreenshotAction.setEditor(TaskEditorAttachmentPart.this.getTaskEditor());
                attachScreenshotAction.run();
            }
        });
        Button deleteAttachmentButton = null;
        if (this.supportsDelete()) {
            deleteAttachmentButton = toolkit.createButton(attachmentControlsComposite, "Delete Attachment...", 8);
            deleteAttachmentButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    AbstractTask task = TasksUiPlugin.getTaskListManager().getTaskList().getTask(TaskEditorAttachmentPart.this.getTaskRepository().getUrl(), TaskEditorAttachmentPart.this.getTaskData().getId());
                    if (task == null) {
                        return;
                    }
                    if (TaskEditorAttachmentPart.this.getTaskEditorPage().isDirty() || task.getSynchronizationState().equals((Object)AbstractTask.RepositoryTaskSyncState.OUTGOING)) {
                        MessageDialog.openInformation((Shell)TaskEditorAttachmentPart.this.getControl().getShell(), (String)"Task not synchronized or dirty editor", (String)"Commit edits or synchronize task before deleting attachments.");
                        return;
                    }
                    if (TaskEditorAttachmentPart.this.attachmentsTableViewer != null && TaskEditorAttachmentPart.this.attachmentsTableViewer.getSelection() != null && ((StructuredSelection)TaskEditorAttachmentPart.this.attachmentsTableViewer.getSelection()).getFirstElement() != null) {
                        RepositoryAttachment attachment = (RepositoryAttachment)((StructuredSelection)TaskEditorAttachmentPart.this.attachmentsTableViewer.getSelection()).getFirstElement();
                        TaskEditorAttachmentPart.this.getTaskEditorPage().deleteAttachment(attachment);
                        TaskEditorAttachmentPart.this.getTaskEditorPage().submitToRepository();
                    }
                }
            });
        }
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        Composite attachmentsComposite = toolkit.createComposite(parent);
        attachmentsComposite.setLayout((Layout)new GridLayout(1, false));
        attachmentsComposite.setLayoutData((Object)new GridData(1808));
        if (this.getTaskData().getAttachments().size() > 0) {
            this.createAttachmentTable(toolkit, attachmentsComposite);
            this.createAttachmentTableMenu();
        } else {
            toolkit.createLabel(attachmentsComposite, "No attachments");
        }
        this.createButtons(attachmentsComposite, toolkit);
        this.setControl((Control)attachmentsComposite);
    }

    public void setSupportsDelete(boolean supportsDelete) {
        this.supportsDelete = supportsDelete;
    }

    public boolean supportsDelete() {
        return this.supportsDelete;
    }
}

