/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.internal.tasks.core.AbstractAttributeMapper;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.internal.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.internal.tasks.ui.editors.AbstractTaskEditorPage;
import org.eclipse.mylyn.internal.tasks.ui.editors.AbstractTaskEditorPart;
import org.eclipse.mylyn.internal.tasks.ui.editors.AttributeEditorFactory;
import org.eclipse.mylyn.internal.tasks.ui.editors.LayoutHint;
import org.eclipse.mylyn.internal.tasks.ui.views.ResetRepositoryConfigurationAction;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.RepositoryTaskAttribute;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskEditorAttributePart
extends AbstractTaskEditorPart {
    private static final int MULTI_ROW_HEIGHT = 55;
    private static final int COLUMN_WIDTH = 140;
    private static final int MULTI_COLUMN_WIDTH = 380;

    public TaskEditorAttributePart(AbstractTaskEditorPage taskEditorPage) {
        super(taskEditorPage);
    }

    private void createAttributeControls(Composite attributesComposite, FormToolkit toolkit) {
        List<AbstractAttributeEditor> attributeEditors = this.createAttributeEditors();
        int columnCount = ((GridLayout)attributesComposite.getLayout()).numColumns;
        ((GridLayout)attributesComposite.getLayout()).verticalSpacing = 6;
        int currentColumn = 1;
        int currentPriority = 0;
        for (AbstractAttributeEditor attributeEditor : attributeEditors) {
            int priority;
            int n = priority = attributeEditor.getLayoutHint() != null ? attributeEditor.getLayoutHint().getPriority() : 10;
            if (priority != currentPriority) {
                currentPriority = priority;
                if (currentColumn > 1) {
                    while (currentColumn <= columnCount) {
                        this.getManagedForm().getToolkit().createLabel(attributesComposite, "");
                        ++currentColumn;
                    }
                    currentColumn = 1;
                }
            }
            if (attributeEditor.hasLabel()) {
                attributeEditor.createLabelControl(attributesComposite, toolkit);
                Label label = attributeEditor.getLabelControl();
                GridDataFactory.fillDefaults().align(131072, 0x1000000).applyTo((Control)label);
                ++currentColumn;
            }
            attributeEditor.createControl(attributesComposite, toolkit);
            LayoutHint layoutHint = attributeEditor.getLayoutHint();
            GridData gd = new GridData(4, 0x1000000, false, false);
            if (layoutHint != null && (layoutHint.rowSpan != LayoutHint.RowSpan.SINGLE || layoutHint.columnSpan != LayoutHint.ColumnSpan.SINGLE)) {
                if (layoutHint.rowSpan == LayoutHint.RowSpan.MULTIPLE) {
                    gd.heightHint = 55;
                }
                if (layoutHint.columnSpan == LayoutHint.ColumnSpan.SINGLE) {
                    gd.widthHint = 140;
                    gd.horizontalSpan = 1;
                } else {
                    gd.widthHint = 380;
                    gd.horizontalSpan = columnCount - currentColumn + 1;
                }
            } else {
                gd.widthHint = 140;
                gd.horizontalSpan = 1;
            }
            attributeEditor.getControl().setLayoutData((Object)gd);
            currentColumn += gd.horizontalSpan;
            currentColumn %= columnCount;
        }
    }

    private List<AbstractAttributeEditor> createAttributeEditors() {
        ArrayList<AbstractAttributeEditor> attributeEditors = new ArrayList<AbstractAttributeEditor>();
        AttributeEditorFactory attributeEditorFactory = this.getTaskEditorPage().getAttributeEditorFactory();
        AbstractAttributeMapper attributeMapper = this.getTaskData().getAttributeFactory().getAttributeMapper();
        for (RepositoryTaskAttribute attribute : this.getTaskData().getAttributes()) {
            String type;
            if (attribute.isHidden() || attribute.isReadOnly() && (attribute.getValue() == null || attribute.getValue().length() == 0) || (type = attributeMapper.getType(attribute)) == null) continue;
            attributeEditorFactory.createEditor(type, attribute);
            AbstractAttributeEditor attributeEditor = attributeEditorFactory.createEditor(type, attribute);
            if (attributeEditor == null) continue;
            attributeEditors.add(attributeEditor);
        }
        Collections.sort(attributeEditors, new Comparator<AbstractAttributeEditor>(){

            @Override
            public int compare(AbstractAttributeEditor o1, AbstractAttributeEditor o2) {
                int p1 = o1.getLayoutHint() != null ? o1.getLayoutHint().getPriority() : 10;
                int p2 = o2.getLayoutHint() != null ? o2.getLayoutHint().getPriority() : 10;
                return p1 - p2;
            }
        });
        return attributeEditors;
    }

    @Override
    public void createControl(Composite parent, FormToolkit toolkit) {
        Composite attributesComposite = toolkit.createComposite(parent);
        attributesComposite.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Control focus = event.display.getFocusControl();
                if (focus instanceof Text && !((Text)focus).getEditable()) {
                    TaskEditorAttributePart.this.getManagedForm().getForm().setFocus();
                }
            }
        });
        GridLayout attributesLayout = new GridLayout();
        attributesLayout.numColumns = 4;
        attributesLayout.horizontalSpacing = 5;
        attributesLayout.verticalSpacing = 6;
        attributesComposite.setLayout((Layout)attributesLayout);
        GridData attributesData = new GridData(1808);
        attributesData.horizontalSpan = 1;
        attributesData.grabExcessVerticalSpace = false;
        attributesComposite.setLayoutData((Object)attributesData);
        this.createAttributeControls(attributesComposite, toolkit);
        toolkit.paintBordersFor(attributesComposite);
        this.setControl((Control)attributesComposite);
    }

    @Override
    protected void fillToolBar(ToolBarManager toolBar) {
        ResetRepositoryConfigurationAction repositoryConfigRefresh = new ResetRepositoryConfigurationAction(){

            public void performUpdate(TaskRepository repository, AbstractRepositoryConnector connector, IProgressMonitor monitor) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        TaskEditorAttributePart.this.getTaskEditorPage().setGlobalBusy(true);
                    }
                });
                try {
                    AbstractTask task;
                    super.performUpdate(repository, connector, monitor);
                    if (connector != null && (task = TasksUiPlugin.getTaskListManager().getTaskList().getTask(TaskEditorAttributePart.this.getTaskRepository().getUrl(), TaskEditorAttributePart.this.getTaskData().getId())) != null) {
                        TasksUiPlugin.getSynchronizationManager().synchronize(connector, task, true, (IJobChangeListener)new JobChangeAdapter(){

                            public void done(IJobChangeEvent event) {
                                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                                    public void run() {
                                        TaskEditorAttributePart.this.getTaskEditorPage().refreshEditor();
                                    }
                                });
                            }
                        });
                    }
                }
                catch (Exception exception) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            TaskEditorAttributePart.this.getTaskEditorPage().refreshEditor();
                        }
                    });
                }
            }
        };
        repositoryConfigRefresh.setImageDescriptor(TasksUiImages.REPOSITORY_SYNCHRONIZE);
        repositoryConfigRefresh.selectionChanged((IStructuredSelection)new StructuredSelection((Object)this.getTaskRepository()));
        repositoryConfigRefresh.setToolTipText("Refresh attributes");
        toolBar.add((IAction)repositoryConfigRefresh);
    }
}

