/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.mylyn.internal.tasks.core.CommentQuoter;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.internal.tasks.ui.editors.AbstractTaskEditorPage;
import org.eclipse.mylyn.internal.tasks.ui.editors.AbstractTaskEditorPart;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.internal.tasks.ui.editors.RichTextAttributeEditor;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.TaskComment;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.Section;

public class TaskEditorCommentPart
extends AbstractTaskEditorPart {
    private static final int DESCRIPTION_WIDTH = 553;
    private static final String LABEL_REPLY = "Reply";
    private TaskComment selectedComment;
    private final Section commentsSection;
    private boolean supportsDelete;
    private final List<ExpandableComposite> commentComposites = new ArrayList<ExpandableComposite>();

    public TaskEditorCommentPart(AbstractTaskEditorPage taskEditorPage, Section commentsSection) {
        super(taskEditorPage);
        this.commentsSection = commentsSection;
    }

    public void createControl(Composite composite, final FormToolkit toolkit) {
        this.commentsSection.setText(String.valueOf(this.commentsSection.getText()) + " (" + this.getTaskData().getComments().size() + ")");
        if (this.getTaskData().getComments().size() == 0) {
            this.commentsSection.setEnabled(false);
        }
        Composite addCommentsComposite = toolkit.createComposite((Composite)this.commentsSection);
        this.commentsSection.setClient((Control)addCommentsComposite);
        GridLayout addCommentsLayout = new GridLayout();
        addCommentsLayout.numColumns = 1;
        addCommentsComposite.setLayout((Layout)addCommentsLayout);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)addCommentsComposite);
        boolean foundNew = false;
        for (final TaskComment taskComment : this.getTaskData().getComments()) {
            final ExpandableComposite expandableComposite = toolkit.createExpandableComposite(addCommentsComposite, 8196);
            expandableComposite.setTitleBarForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
            Composite toolbarComp = toolkit.createComposite((Composite)expandableComposite);
            RowLayout rowLayout = new RowLayout();
            rowLayout.pack = true;
            rowLayout.marginLeft = 0;
            rowLayout.marginBottom = 0;
            rowLayout.marginTop = 0;
            toolbarComp.setLayout((Layout)rowLayout);
            toolbarComp.setBackground(null);
            ImageHyperlink formHyperlink = toolkit.createImageHyperlink(toolbarComp, 0);
            formHyperlink.setBackground(null);
            formHyperlink.setFont(expandableComposite.getFont());
            formHyperlink.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
            if (taskComment.getAuthor() != null && taskComment.getAuthor().equalsIgnoreCase(this.getTaskRepository().getUserName())) {
                formHyperlink.setImage(TasksUiImages.getImage(TasksUiImages.PERSON_ME_NARROW));
            } else {
                formHyperlink.setImage(TasksUiImages.getImage(TasksUiImages.PERSON_NARROW));
            }
            String authorName = taskComment.getAuthorName();
            String tooltipText = taskComment.getAuthor();
            if (authorName.length() == 0) {
                authorName = taskComment.getAuthor();
                tooltipText = null;
            }
            formHyperlink.setText(String.valueOf(taskComment.getNumber()) + ": " + authorName + ", " + this.formatDate(taskComment.getCreated()));
            formHyperlink.setToolTipText(tooltipText);
            formHyperlink.setEnabled(true);
            formHyperlink.setUnderlined(false);
            final Composite toolbarButtonComp = toolkit.createComposite(toolbarComp);
            RowLayout buttonCompLayout = new RowLayout();
            buttonCompLayout.marginBottom = 0;
            buttonCompLayout.marginTop = 0;
            toolbarButtonComp.setLayout((Layout)buttonCompLayout);
            toolbarButtonComp.setBackground(null);
            if (this.supportsDelete()) {
                ImageHyperlink deleteComment = new ImageHyperlink(toolbarButtonComp, 0);
                toolkit.adapt((Control)deleteComment, true, true);
                deleteComment.setImage(TasksUiImages.getImage(TasksUiImages.REMOVE));
                deleteComment.setToolTipText("Remove");
                deleteComment.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent e) {
                        TaskEditorCommentPart.this.getTaskEditorPage().deleteComment(taskComment);
                        TaskEditorCommentPart.this.getTaskEditorPage().submitToRepository();
                    }
                });
            }
            final ImageHyperlink replyLink = this.createReplyHyperlink(toolbarButtonComp, toolkit, taskComment);
            formHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    EditorUtil.toggleExpandableComposite(!expandableComposite.isExpanded(), expandableComposite);
                }

                public void linkEntered(HyperlinkEvent e) {
                    replyLink.setUnderlined(true);
                    super.linkEntered(e);
                }

                public void linkExited(HyperlinkEvent e) {
                    replyLink.setUnderlined(false);
                    super.linkExited(e);
                }
            });
            expandableComposite.setTextClient((Control)toolbarComp);
            toolbarButtonComp.setVisible(expandableComposite.isExpanded());
            expandableComposite.setData((Object)toolbarButtonComp);
            expandableComposite.setLayout((Layout)new GridLayout());
            expandableComposite.setLayoutData((Object)new GridData(768));
            final Composite ecComposite = toolkit.createComposite((Composite)expandableComposite);
            GridLayout ecLayout = new GridLayout();
            ecLayout.marginHeight = 0;
            ecLayout.marginBottom = 3;
            ecLayout.marginLeft = 15;
            ecComposite.setLayout((Layout)ecLayout);
            ecComposite.setLayoutData((Object)new GridData(768));
            expandableComposite.setClient((Control)ecComposite);
            this.commentComposites.add(expandableComposite);
            this.getTaskEditorPage().addSelectableControl(taskComment, (Control)expandableComposite);
            expandableComposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                public void expansionStateChanged(ExpansionEvent e) {
                    toolbarButtonComp.setVisible(expandableComposite.isExpanded());
                    SourceViewer viewer = null;
                    if (e.getState() && expandableComposite.getData("viewer") == null) {
                        RichTextAttributeEditor editor = new RichTextAttributeEditor(TaskEditorCommentPart.this.getTaskEditorPage().getAttributeManager(), taskComment.getAttribute("task.common.comment.text"));
                        editor.setDecorationEnabled(false);
                        editor.createControl(ecComposite, toolkit);
                        viewer = editor.getViewer();
                        expandableComposite.setData("viewer", (Object)viewer.getTextWidget());
                        viewer.getTextWidget().addFocusListener(new FocusListener(){

                            public void focusGained(FocusEvent e) {
                                TaskEditorCommentPart.this.selectedComment = taskComment;
                            }

                            public void focusLost(FocusEvent e) {
                                TaskEditorCommentPart.this.selectedComment = null;
                            }
                        });
                        StyledText styledText = viewer.getTextWidget();
                        GridDataFactory.fillDefaults().hint(553, -1).applyTo((Control)styledText);
                        TaskEditorCommentPart.this.getTaskEditorPage().resetLayout();
                    } else {
                        if (expandableComposite.getData("viewer") instanceof StyledText) {
                            ((StyledText)expandableComposite.getData("viewer")).dispose();
                            expandableComposite.setData("viewer", null);
                        }
                        TaskEditorCommentPart.this.getTaskEditorPage().resetLayout();
                    }
                }
            });
            AbstractTask repositoryTask = this.getTaskEditorPage().getTask();
            if (repositoryTask != null && repositoryTask.getLastReadTimeStamp() == null || this.getTaskEditorPage().getAttributeManager().getOldTaskData() == null) {
                EditorUtil.toggleExpandableComposite(true, expandableComposite);
                foundNew = true;
                continue;
            }
            if (!this.getTaskEditorPage().getAttributeManager().isNewComment(taskComment)) continue;
            expandableComposite.setBackground(this.getTaskEditorPage().getColorIncoming());
            EditorUtil.toggleExpandableComposite(true, expandableComposite);
            foundNew = true;
        }
        if (foundNew) {
            this.commentsSection.setExpanded(true);
        } else if (this.getTaskData().getComments() == null || this.getTaskData().getComments().size() == 0) {
            this.commentsSection.setExpanded(false);
        } else if (this.getTaskEditorPage().getAttributeManager().getTaskData() != null && this.getTaskEditorPage().getAttributeManager().getOldTaskData() != null) {
            List newTaskComments = this.getTaskEditorPage().getAttributeManager().getTaskData().getComments();
            List oldTaskComments = this.getTaskEditorPage().getAttributeManager().getOldTaskData().getComments();
            if (newTaskComments == null || oldTaskComments == null) {
                this.commentsSection.setExpanded(true);
            } else {
                this.commentsSection.setExpanded(newTaskComments.size() != oldTaskComments.size());
            }
        }
        this.setControl((Control)addCommentsComposite);
    }

    private ImageHyperlink createReplyHyperlink(Composite composite, FormToolkit toolkit, final TaskComment taskComment) {
        ImageHyperlink replyLink = new ImageHyperlink(composite, 0);
        toolkit.adapt((Control)replyLink, true, true);
        replyLink.setImage(TasksUiImages.getImage(TasksUiImages.REPLY));
        replyLink.setToolTipText(LABEL_REPLY);
        replyLink.setBackground(null);
        replyLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                StringBuilder strBuilder = new StringBuilder();
                strBuilder.append(" (In reply to comment #" + taskComment.getNumber() + ")\n");
                CommentQuoter quoter = new CommentQuoter();
                strBuilder.append(quoter.quote(taskComment.getText()));
                TaskEditorCommentPart.this.getTaskEditorPage().appendTextToNewComment(strBuilder.toString());
            }
        });
        return replyLink;
    }

    protected void fillToolBar(ToolBarManager barManager) {
        if (this.getTaskData().getComments().isEmpty()) {
            return;
        }
        Action collapseAllAction = new Action(""){

            public void run() {
                TaskEditorCommentPart.this.hideAllComments();
            }
        };
        collapseAllAction.setImageDescriptor(TasksUiImages.COLLAPSE_ALL);
        collapseAllAction.setToolTipText("Collapse All Comments");
        barManager.add((IAction)collapseAllAction);
        Action expandAllAction = new Action(""){

            public void run() {
                TaskEditorCommentPart.this.expandAllComments();
            }
        };
        expandAllAction.setImageDescriptor(TasksUiImages.EXPAND_ALL);
        expandAllAction.setToolTipText("Expand All Comments");
        barManager.add((IAction)expandAllAction);
    }

    private void hideAllComments() {
        try {
            this.getTaskEditorPage().setReflow(false);
            for (ExpandableComposite composite : this.commentComposites) {
                if (composite.isDisposed() || !composite.isExpanded()) continue;
                EditorUtil.toggleExpandableComposite(false, composite);
            }
        }
        finally {
            this.getTaskEditorPage().setReflow(true);
        }
    }

    private void expandAllComments() {
        try {
            this.getTaskEditorPage().setReflow(false);
            if (this.commentsSection != null) {
                this.commentsSection.setExpanded(true);
            }
            for (ExpandableComposite composite : this.commentComposites) {
                if (composite.isDisposed() || composite.isExpanded()) continue;
                EditorUtil.toggleExpandableComposite(true, composite);
            }
        }
        finally {
            this.getTaskEditorPage().setReflow(true);
        }
    }

    public void setSupportsDelete(boolean supportsDelete) {
        this.supportsDelete = supportsDelete;
    }

    private boolean supportsDelete() {
        return this.supportsDelete;
    }

    public TaskComment getSelectedComment() {
        return this.selectedComment;
    }

    public String formatDate(String dateString) {
        return dateString;
    }
}

