/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.util.Calendar;
import org.eclipse.core.runtime.Assert;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityUtil;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.internal.tasks.ui.editors.AbstractTaskEditorPage;
import org.eclipse.mylyn.internal.tasks.ui.editors.AbstractTaskEditorPart;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.ui.DatePicker;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class TaskEditorPlanningPart
extends AbstractTaskEditorPart {
    private static final int DEFAULT_ESTIMATED_TIME = 1;
    private DatePicker scheduledForDate;
    private Spinner estimatedTime;

    public TaskEditorPlanningPart(AbstractTaskEditorPage taskEditorPage) {
        super(taskEditorPage);
    }

    public void commit(boolean onSave) {
        AbstractTask task = this.getTaskEditorPage().getTask();
        Assert.isNotNull((Object)task);
        Calendar selectedDate = null;
        if (this.scheduledForDate != null) {
            selectedDate = this.scheduledForDate.getDate();
        }
        if (selectedDate != null) {
            TasksUiPlugin.getTaskActivityManager().setScheduledFor(task, selectedDate.getTime());
        }
        if (this.estimatedTime != null) {
            task.setEstimatedTimeHours(this.estimatedTime.getSelection());
        }
        super.commit(onSave);
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        Composite sectionClient = this.getManagedForm().getToolkit().createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 7;
        layout.makeColumnsEqualWidth = false;
        sectionClient.setLayout((Layout)layout);
        GridData clientDataLayout = new GridData(32);
        sectionClient.setLayoutData((Object)clientDataLayout);
        this.getManagedForm().getToolkit().createLabel(sectionClient, "Scheduled for:");
        this.scheduledForDate = new DatePicker(sectionClient, 0x800000, "Choose Date");
        this.scheduledForDate.setBackground(Display.getDefault().getSystemColor(1));
        this.scheduledForDate.setData("FormWidgetFactory.drawBorder", "textBorder");
        Calendar newTaskSchedule = Calendar.getInstance();
        int scheduledEndHour = TasksUiPlugin.getDefault().getPreferenceStore().getInt("org.eclipse.mylyn.tasks.ui.planning.end.hour");
        if (newTaskSchedule.get(11) >= scheduledEndHour) {
            TaskActivityUtil.snapForwardNumDays((Calendar)newTaskSchedule, (int)1);
        } else {
            TaskActivityUtil.snapEndOfWorkDay((Calendar)newTaskSchedule);
        }
        this.scheduledForDate.setDate(newTaskSchedule);
        ImageHyperlink clearReminder = this.getManagedForm().getToolkit().createImageHyperlink(sectionClient, 0);
        clearReminder.setImage(TasksUiImages.getImage(TasksUiImages.REMOVE));
        clearReminder.setToolTipText("Clear");
        clearReminder.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                TaskEditorPlanningPart.this.scheduledForDate.setDate(null);
            }
        });
        Label dummy = this.getManagedForm().getToolkit().createLabel(sectionClient, "");
        GridData dummyLabelDataLayout = new GridData(64);
        dummyLabelDataLayout.horizontalSpan = 1;
        dummyLabelDataLayout.widthHint = 30;
        dummy.setLayoutData((Object)dummyLabelDataLayout);
        this.getManagedForm().getToolkit().createLabel(sectionClient, "Estimated hours:");
        this.estimatedTime = new Spinner(sectionClient, 0x800000);
        this.estimatedTime.setDigits(0);
        this.estimatedTime.setMaximum(100);
        this.estimatedTime.setMinimum(0);
        this.estimatedTime.setIncrement(1);
        this.estimatedTime.setSelection(1);
        this.estimatedTime.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        GridData estimatedDataLayout = new GridData();
        estimatedDataLayout.widthHint = 30;
        this.estimatedTime.setLayoutData((Object)estimatedDataLayout);
        ImageHyperlink clearEstimated = this.getManagedForm().getToolkit().createImageHyperlink(sectionClient, 0);
        clearEstimated.setImage(TasksUiImages.getImage(TasksUiImages.REMOVE));
        clearEstimated.setToolTipText("Clear");
        clearEstimated.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                TaskEditorPlanningPart.this.estimatedTime.setSelection(0);
            }
        });
        this.getManagedForm().getToolkit().paintBordersFor(sectionClient);
        this.setControl((Control)sectionClient);
    }
}

