/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.mylyn.internal.tasks.ui.editors.AbstractTaskEditorPage;
import org.eclipse.mylyn.internal.tasks.ui.editors.AbstractTaskEditorPart;
import org.eclipse.mylyn.internal.tasks.ui.editors.PreviewAttributeEditor;
import org.eclipse.mylyn.internal.tasks.ui.editors.RichTextAttributeEditor;
import org.eclipse.mylyn.tasks.core.RepositoryTaskAttribute;
import org.eclipse.mylyn.tasks.ui.editors.AbstractRenderingEngine;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class TaskEditorRichTextPart
extends AbstractTaskEditorPart {
    private RichTextAttributeEditor editor;
    private final RepositoryTaskAttribute attribute;

    public TaskEditorRichTextPart(AbstractTaskEditorPage taskEditorPage, RepositoryTaskAttribute attribute) {
        super(taskEditorPage);
        Assert.isNotNull((Object)attribute);
        this.attribute = attribute;
    }

    public void appendText(String text) {
        if (this.editor == null) {
            return;
        }
        StringBuilder strBuilder = new StringBuilder();
        String oldText = this.editor.getViewer().getDocument().get();
        if (strBuilder.length() != 0) {
            strBuilder.append("\n");
        }
        strBuilder.append(oldText);
        strBuilder.append(text);
        this.editor.getViewer().getDocument().set(strBuilder.toString());
        RepositoryTaskAttribute attribute = this.getTaskData().getAttribute("task.common.comment.new");
        if (attribute != null) {
            attribute.setValue(strBuilder.toString());
            this.getTaskEditorPage().getAttributeManager().attributeChanged(attribute);
        }
        this.editor.getViewer().getTextWidget().setCaretOffset(strBuilder.length());
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        final Composite composite = toolkit.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        this.editor = new RichTextAttributeEditor(this.getTaskEditorPage().getAttributeManager(), this.attribute);
        AbstractRenderingEngine renderingEngine = this.getTaskEditorPage().getAttributeEditorToolkit().getRenderingEngine(this.attribute);
        if (renderingEngine != null) {
            PreviewAttributeEditor previewEditor = new PreviewAttributeEditor(this.getTaskEditorPage().getAttributeManager(), this.attribute, renderingEngine, this.editor);
            previewEditor.createControl(composite, toolkit);
            GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo(previewEditor.getControl());
        } else {
            this.editor.createControl(composite, toolkit);
            if (this.attribute.isReadOnly()) {
                GridDataFactory.fillDefaults().hint(500, -1).applyTo(this.editor.getControl());
            } else {
                final GridData gd = new GridData(768);
                gd.widthHint = 500;
                gd.minimumHeight = 140;
                gd.grabExcessHorizontalSpace = true;
                this.editor.getControl().setLayoutData((Object)gd);
                this.editor.getControl().setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
                composite.addControlListener((ControlListener)new ControlAdapter(){
                    private boolean first;

                    public void controlResized(ControlEvent e) {
                        if (!this.first) {
                            this.first = true;
                            int width = composite.getSize().x;
                            Point size = TaskEditorRichTextPart.this.editor.getViewer().getTextWidget().computeSize(width, -1, true);
                            gd.widthHint = width;
                            gd.heightHint = Math.min(Math.max(140, size.y), 560);
                            composite.layout();
                        }
                    }
                });
            }
        }
        toolkit.paintBordersFor(composite);
        this.setControl((Control)composite);
    }

    public void setFocus() {
        if (this.editor != null) {
            this.editor.getControl().setFocus();
        }
    }
}

