/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.mylyn.internal.tasks.core.AbstractAttributeMapper;
import org.eclipse.mylyn.internal.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.internal.tasks.ui.editors.AbstractTaskEditorPage;
import org.eclipse.mylyn.internal.tasks.ui.editors.AbstractTaskEditorPart;
import org.eclipse.mylyn.internal.tasks.ui.editors.AttributeEditorFactory;
import org.eclipse.mylyn.internal.tasks.ui.editors.RichTextAttributeEditor;
import org.eclipse.mylyn.tasks.core.RepositoryTaskAttribute;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class TaskEditorSummaryPart
extends AbstractTaskEditorPart {
    private static final int COLUMN_MARGIN = 6;
    private Composite headerComposite;
    private boolean needsHeader;
    private RichTextAttributeEditor summaryEditor;

    public TaskEditorSummaryPart(AbstractTaskEditorPage taskEditorPage) {
        super(taskEditorPage);
    }

    private void addAttribute(Composite composite, FormToolkit toolkit, RepositoryTaskAttribute attribute) {
        if (attribute == null) {
            return;
        }
        AttributeEditorFactory attributeEditorFactory = this.getTaskEditorPage().getAttributeEditorFactory();
        AbstractAttributeMapper attributeMapper = this.getTaskData().getAttributeFactory().getAttributeMapper();
        String type = attributeMapper.getType(attribute);
        if (type != null) {
            AbstractAttributeEditor editor = attributeEditorFactory.createEditor(type, attribute);
            editor.createLabelControl(composite, toolkit);
            GridDataFactory.defaultsFor((Control)editor.getLabelControl()).indent(6, 0).applyTo((Control)editor.getLabelControl());
            editor.createControl(composite, toolkit);
        }
    }

    private void addSummaryText(Composite composite, FormToolkit toolkit) {
        RepositoryTaskAttribute attribute = this.getTaskData().getAttribute("task.common.summary");
        this.summaryEditor = new RichTextAttributeEditor(this.getTaskEditorPage().getAttributeManager(), attribute, 4);
        this.summaryEditor.createControl(composite, toolkit);
        GridDataFactory.fillDefaults().grab(true, false).applyTo(this.summaryEditor.getControl());
        this.summaryEditor.getViewer().prependVerifyKeyListener((VerifyKeyListener)new TabVerifyKeyListener());
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        Composite composite = toolkit.createComposite(parent);
        composite.setLayout((Layout)new GridLayout());
        this.addSummaryText(composite, toolkit);
        if (this.needsHeader()) {
            this.createHeaderLayout(composite, toolkit);
        }
        toolkit.paintBordersFor(composite);
        this.setControl((Control)composite);
    }

    protected void createHeaderLayout(Composite composite, FormToolkit toolkit) {
        this.headerComposite = toolkit.createComposite(composite);
        GridLayout layout = new GridLayout(11, false);
        layout.verticalSpacing = 1;
        layout.marginHeight = 1;
        layout.marginWidth = 1;
        this.headerComposite.setLayout((Layout)layout);
        RepositoryTaskAttribute statusAtribute = this.getTaskData().getAttribute("task.common.status");
        this.addAttribute(this.headerComposite, toolkit, statusAtribute);
        RepositoryTaskAttribute priorityAttribute = this.getTaskData().getAttribute("task.common.priority");
        this.addAttribute(this.headerComposite, toolkit, priorityAttribute);
        String key = this.getTaskData().getTaskKey();
        if (key != null) {
            Label label = toolkit.createLabel(this.headerComposite, "ID:");
            label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
            GridDataFactory.defaultsFor((Control)label).indent(6, 0).applyTo((Control)label);
            Text text = new Text(this.headerComposite, 0x800008);
            toolkit.adapt((Control)text, true, true);
            text.setText(key);
        }
        RepositoryTaskAttribute dateCreation = this.getTaskData().getAttribute("task.common.date.created");
        this.addAttribute(this.headerComposite, toolkit, dateCreation);
        RepositoryTaskAttribute dateModified = this.getTaskData().getAttribute("task.common.date.modified");
        this.addAttribute(this.headerComposite, toolkit, dateModified);
    }

    public boolean needsHeader() {
        return this.needsHeader;
    }

    public void setFocus() {
        this.summaryEditor.getViewer().getControl().setFocus();
    }

    public void setNeedsHeader(boolean needsHeader) {
        this.needsHeader = needsHeader;
    }

    private class TabVerifyKeyListener
    implements VerifyKeyListener {
        private TabVerifyKeyListener() {
        }

        public void verifyKey(VerifyEvent event) {
            if (event.keyCode == 9) {
                event.doit = false;
                if (TaskEditorSummaryPart.this.headerComposite != null) {
                    TaskEditorSummaryPart.this.headerComposite.setFocus();
                }
            }
        }
    }
}

