/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.mylyn.internal.tasks.ui.editors.RepositoryTextViewer;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.TaskRepositoryManager;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class TaskHyperlinkDetector
extends AbstractHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        String line;
        IRegion lineInfo;
        if (region == null || textViewer == null) {
            return null;
        }
        IDocument document = textViewer.getDocument();
        if (document == null) {
            return null;
        }
        try {
            lineInfo = document.getLineInformationOfOffset(region.getOffset());
            line = document.get(lineInfo.getOffset(), lineInfo.getLength());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        if (line.length() == 0) {
            return null;
        }
        TaskRepository repository = this.getRepository(textViewer);
        if (repository == null) {
            repository = this.guessRepository(line);
        }
        if (repository == null) {
            return null;
        }
        AbstractRepositoryConnectorUi connectorUi = TasksUiPlugin.getConnectorUi(repository.getConnectorKind());
        if (connectorUi == null) {
            return null;
        }
        return connectorUi.findHyperlinks(repository, line, region.getOffset() - lineInfo.getOffset(), lineInfo.getOffset());
    }

    private TaskRepository getRepository(ITextViewer textViewer) {
        TaskRepository repository = (TaskRepository)this.getAdapter(TaskRepository.class);
        if (repository != null) {
            return repository;
        }
        IResource resource = (IResource)this.getAdapter(IResource.class);
        if (resource == null) {
            IEditorInput input;
            if (textViewer instanceof RepositoryTextViewer) {
                RepositoryTextViewer viewer = (RepositoryTextViewer)textViewer;
                return viewer.getRepository();
            }
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IWorkbenchPart part = activePage.getActivePart();
            if (part != null && part instanceof IEditorPart && (input = ((IEditorPart)part).getEditorInput()) != null) {
                resource = (IResource)input.getAdapter(IResource.class);
            }
        }
        if (resource != null) {
            return TasksUiPlugin.getDefault().getRepositoryForResource(resource, true);
        }
        return null;
    }

    private TaskRepository guessRepository(String text) {
        TaskRepositoryManager manager = TasksUiPlugin.getRepositoryManager();
        for (AbstractRepositoryConnector c : manager.getRepositoryConnectors()) {
            for (TaskRepository repository : manager.getRepositories(c.getConnectorKind())) {
                String[] ids = c.getTaskIdsFromComment(repository, text);
                if (ids == null || ids.length <= 0 || ids[0].length() <= 0) continue;
                return repository;
            }
        }
        return null;
    }
}

