/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.planner;

import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.internal.tasks.ui.planner.CompletedTaskCollector;
import org.eclipse.mylyn.internal.tasks.ui.planner.InProgressTaskCollector;
import org.eclipse.mylyn.internal.tasks.ui.planner.TaskReportGenerator;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.tasks.core.TaskList;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskActivityEditorInput
implements IEditorInput {
    private static final String TASK_ACTIVITY_REPORT = "Task Activity Report";
    private Set<AbstractTask> completedTasks = new HashSet<AbstractTask>();
    private Set<AbstractTask> inProgressTasks = new HashSet<AbstractTask>();
    private Set<AbstractTask> plannedTasks = new HashSet<AbstractTask>();
    private TaskReportGenerator taskReportGenerator = null;
    private Date reportStartDate = null;
    private Date reportEndDate = null;
    private Set<AbstractTaskContainer> categories;

    public TaskActivityEditorInput(Date reportStartDate, Date reportEndDate, Set<AbstractTaskContainer> chosenCategories, TaskList tlist) {
        this.reportStartDate = reportStartDate;
        this.reportEndDate = reportEndDate;
        this.categories = chosenCategories;
        this.taskReportGenerator = new TaskReportGenerator(tlist, chosenCategories);
        CompletedTaskCollector completedTaskCollector = new CompletedTaskCollector(reportStartDate, reportEndDate);
        this.taskReportGenerator.addCollector(completedTaskCollector);
        InProgressTaskCollector inProgressTaskCollector = new InProgressTaskCollector(reportStartDate, reportEndDate);
        this.taskReportGenerator.addCollector(inProgressTaskCollector);
        try {
            IProgressService service = PlatformUI.getWorkbench().getProgressService();
            service.run(false, true, (IRunnableWithProgress)this.taskReportGenerator);
            while (!this.taskReportGenerator.isFinished()) {
                Thread.sleep(500L);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not generate report", (Throwable)e));
        }
        this.completedTasks = completedTaskCollector.getTasks();
        this.inProgressTasks = inProgressTaskCollector.getTasks();
        this.plannedTasks.addAll(TasksUiPlugin.getTaskActivityManager().getActivityThisWeek().getChildren());
        this.plannedTasks.addAll(TasksUiPlugin.getTaskActivityManager().getActivityNextWeek().getChildren());
        this.plannedTasks.addAll(TasksUiPlugin.getTaskActivityManager().getActivityFuture().getChildren());
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return TASK_ACTIVITY_REPORT;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return "Task Planner";
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public Set<AbstractTask> getCompletedTasks() {
        return this.completedTasks;
    }

    public Set<AbstractTask> getInProgressTasks() {
        return this.inProgressTasks;
    }

    public Set<AbstractTask> getPlannedTasks() {
        return this.plannedTasks;
    }

    public long getTotalTimeSpentOnCompletedTasks() {
        long duration = 0L;
        for (AbstractTask t : this.completedTasks) {
            duration += TasksUiPlugin.getTaskActivityManager().getElapsedTime(t);
        }
        return duration;
    }

    public long getTotalTimeSpentOnInProgressTasks() {
        long duration = 0L;
        for (AbstractTask t : this.inProgressTasks) {
            duration += TasksUiPlugin.getTaskActivityManager().getElapsedTime(t);
        }
        return duration;
    }

    public TaskReportGenerator getReportGenerator() {
        return this.taskReportGenerator;
    }

    public boolean createdDuringReportPeriod(AbstractTask task) {
        Date creationDate = task.getCreationDate();
        if (creationDate != null) {
            return creationDate.compareTo(this.reportStartDate) > 0;
        }
        return false;
    }

    public int getTotalTimeEstimated() {
        int duration = 0;
        for (AbstractTask task : this.inProgressTasks) {
            duration += task.getEstimateTimeHours();
        }
        return duration;
    }

    public void removeCompletedTask(AbstractTask task) {
        this.completedTasks.remove(task);
    }

    public void removeInProgressTask(AbstractTask task) {
        this.inProgressTasks.remove(task);
    }

    public void addPlannedTask(AbstractTask task) {
        this.plannedTasks.add(task);
    }

    public void removePlannedTask(AbstractTask task) {
        this.plannedTasks.remove(task);
    }

    public int getPlannedEstimate() {
        int estimated = 0;
        for (AbstractTask task : this.plannedTasks) {
            estimated += task.getEstimateTimeHours();
        }
        return estimated;
    }

    public Date getReportStartDate() {
        return this.reportStartDate;
    }

    public Date getReportEndDate() {
        return this.reportEndDate;
    }

    public Set<AbstractTaskContainer> getCategories() {
        return this.categories;
    }
}

