/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.planner;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.mylyn.internal.tasks.ui.planner.ITaskCollector;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.tasks.core.TaskList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskReportGenerator
implements IRunnableWithProgress {
    private static final String LABEL_JOB = "Mylyn Task Activity Report";
    private boolean finished;
    private TaskList tasklist = null;
    private List<ITaskCollector> collectors = new ArrayList<ITaskCollector>();
    private List<AbstractTask> tasks = new ArrayList<AbstractTask>();
    private Set<AbstractTaskContainer> filterCategories;

    public TaskReportGenerator(TaskList tlist) {
        this(tlist, null);
    }

    public TaskReportGenerator(TaskList tlist, Set<AbstractTaskContainer> filterCategories) {
        this.tasklist = tlist;
        this.filterCategories = filterCategories != null ? filterCategories : new HashSet();
    }

    public void addCollector(ITaskCollector collector) {
        this.collectors.add(collector);
    }

    public void collectTasks() {
        try {
            this.run((IProgressMonitor)new NullProgressMonitor());
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not collect tasks", (Throwable)e));
        }
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        Set rootElements = this.filterCategories.size() == 0 ? this.tasklist.getRootElements() : this.filterCategories;
        int estimatedItemsToProcess = rootElements.size();
        monitor.beginTask(LABEL_JOB, estimatedItemsToProcess);
        for (Object element : rootElements) {
            monitor.worked(1);
            if (element instanceof AbstractTask) {
                AbstractTask task = (AbstractTask)element;
                for (ITaskCollector collector : this.collectors) {
                    collector.consumeTask(task);
                }
                continue;
            }
            if (element instanceof AbstractRepositoryQuery) {
                AbstractRepositoryQuery repositoryQuery = (AbstractRepositoryQuery)element;
                for (AbstractTask task : repositoryQuery.getChildren()) {
                    for (ITaskCollector collector : this.collectors) {
                        collector.consumeTask(task);
                    }
                }
                continue;
            }
            if (!(element instanceof AbstractTaskContainer)) continue;
            AbstractTaskContainer cat = (AbstractTaskContainer)element;
            for (AbstractTask task : cat.getChildren()) {
                for (ITaskCollector collector : this.collectors) {
                    collector.consumeTask(task);
                }
            }
        }
        for (ITaskCollector collector : this.collectors) {
            this.tasks.addAll(collector.getTasks());
        }
        this.finished = true;
        monitor.done();
    }

    public List<AbstractTask> getAllCollectedTasks() {
        return this.tasks;
    }

    public boolean isFinished() {
        return this.finished;
    }
}

