/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.preferences;

import java.io.File;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.mylyn.monitor.ui.MonitorUiPlugin;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class TasksUiPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "org.eclipse.mylyn.tasks.ui.preferences";
    private static final String FOLDER_SELECTION_MESSAGE = "Specify the folder for tasks";
    private static final String TITLE_FOLDER_SELECTION = "Folder Selection";
    private static final String LABEL_ACTIVITY_TIMEOUT = "Stop time accumulation after";
    private static final String LABEL_ACTIVITY_TIMEOUT2 = "minutes of inactivity.";
    private static final String END_HOUR_LABEL = "Work day end (24hr): ";
    private static final String START_HOUR_LABEL = "Work day start (24hr): ";
    private static final String GROUP_WORK_WEEK_LABEL = "Scheduling";
    private static final String GROUP_TASK_TIMING = "Task Timing";
    private static final String FORWARDSLASH = "/";
    private static final String BACKSLASH_MULTI = "\\\\";
    private static final int MS_MINUTES = 60000;
    private Button useRichEditor;
    private Button useWebBrowser;
    private Text synchScheduleTime = null;
    private Button enableBackgroundSynch;
    private Text taskDirectoryText = null;
    private Button browse = null;
    private Button backupNow = null;
    private Button notificationEnabledButton = null;
    private Text backupScheduleTimeText;
    private Text backupFolderText;
    private Spinner hourDayStart;
    private Spinner hourDayEnd;
    private int taskDataDirectoryAction = -1;
    private FormToolkit toolkit;
    private Spinner timeoutMinutes;
    private Button timeoutEnabledButton;
    private ExpandableComposite advancedComposite;

    public TasksUiPreferencePage() {
        this.setPreferenceStore(TasksUiPlugin.getDefault().getPreferenceStore());
        this.toolkit = new FormToolkit(Display.getCurrent());
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        container.setLayout((Layout)layout);
        if (this.getContainer() instanceof IWorkbenchPreferenceContainer) {
            String message = "See <a>''{0}''</a> for configuring Task List colors.";
            new PreferenceLinkArea(container, 0, "org.eclipse.ui.preferencePages.ColorsAndFonts", message, (IWorkbenchPreferenceContainer)this.getContainer(), null);
        }
        this.createTaskRefreshScheduleGroup(container);
        this.createSchedulingGroup(container);
        this.createOpenWith(container);
        Composite advanced = this.createAdvancedSection(container);
        this.createTaskActivityGroup(advanced);
        this.createTaskDataControl(advanced);
        this.updateRefreshGroupEnablements();
        return container;
    }

    private Composite createAdvancedSection(Composite container) {
        this.advancedComposite = this.toolkit.createExpandableComposite(container, 290);
        this.advancedComposite.setFont(container.getFont());
        this.advancedComposite.setBackground(container.getBackground());
        this.advancedComposite.setText("Advanced");
        this.advancedComposite.setLayout((Layout)new GridLayout(1, false));
        this.advancedComposite.setLayoutData((Object)new GridData(768));
        this.advancedComposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                TasksUiPreferencePage.this.getControl().getShell().pack();
            }
        });
        Composite advanced = new Composite((Composite)this.advancedComposite, 0);
        advanced.setLayout((Layout)new GridLayout(1, false));
        this.advancedComposite.setClient((Control)advanced);
        return advanced;
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        String taskDirectory = this.taskDirectoryText.getText();
        if (!(taskDirectory = taskDirectory.replaceAll(BACKSLASH_MULTI, FORWARDSLASH)).equals(TasksUiPlugin.getDefault().getDataDirectory()) && this.taskDataDirectoryAction == 0) {
            TasksUiPlugin.getDefault().getBackupManager().backupNow(true);
            TasksUiPlugin.getDefault().setDataDirectory(taskDirectory);
        }
        this.getPreferenceStore().setValue("org.eclipse.mylyn.tasks.ui.notifications.enabled", this.notificationEnabledButton.getSelection());
        this.getPreferenceStore().setValue("org.eclipse.mylyn.tasks.ui.backup.schedule", this.backupScheduleTimeText.getText());
        this.getPreferenceStore().setValue("org.eclipse.mylyn.tasks.ui.reporting.open.editor", this.useRichEditor.getSelection());
        this.getPreferenceStore().setValue("org.eclipse.mylyn.tasks.ui.repositories.synch.schedule", this.enableBackgroundSynch.getSelection());
        long miliseconds = 60000L * Long.parseLong(this.synchScheduleTime.getText());
        this.getPreferenceStore().setValue("org.eclipse.mylyn.tasks.ui.repositories.synch.schedule.miliseconds", "" + miliseconds);
        MonitorUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.monitor.ui.activity.timeout.enabled", this.timeoutEnabledButton.getSelection());
        MonitorUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.monitor.ui.activity.timeout", this.timeoutMinutes.getSelection() * 60000);
        this.backupNow.setEnabled(true);
        return true;
    }

    public boolean performCancel() {
        this.taskDirectoryText.setText(TasksUiPlugin.getDefault().getDefaultDataDirectory());
        this.notificationEnabledButton.setSelection(this.getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.notifications.enabled"));
        this.backupScheduleTimeText.setText(this.getPreferenceStore().getString("org.eclipse.mylyn.tasks.ui.backup.schedule"));
        this.backupFolderText.setText(TasksUiPlugin.getDefault().getBackupFolderPath());
        this.useRichEditor.setSelection(this.getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.reporting.open.editor"));
        this.enableBackgroundSynch.setSelection(this.getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.repositories.synch.schedule"));
        this.synchScheduleTime.setText(this.getMinutesString());
        this.backupNow.setEnabled(true);
        int minutes = MonitorUiPlugin.getDefault().getPreferenceStore().getInt("org.eclipse.mylyn.monitor.ui.activity.timeout") / 60000;
        this.timeoutMinutes.setSelection(minutes);
        this.timeoutEnabledButton.setSelection(MonitorUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.monitor.ui.activity.timeout.enabled"));
        return true;
    }

    public void performDefaults() {
        super.performDefaults();
        String taskDirectory = TasksUiPlugin.getDefault().getDefaultDataDirectory();
        if (!taskDirectory.equals(TasksUiPlugin.getDefault().getDataDirectory())) {
            this.checkForExistingTasklist(taskDirectory);
            if (this.taskDataDirectoryAction != 1) {
                this.taskDirectoryText.setText(taskDirectory);
                this.backupFolderText.setText(String.valueOf(taskDirectory) + FORWARDSLASH + "backup");
                this.backupNow.setEnabled(false);
            }
        } else {
            this.taskDirectoryText.setText(taskDirectory);
            this.backupFolderText.setText(String.valueOf(taskDirectory) + FORWARDSLASH + "backup");
            this.backupNow.setEnabled(true);
        }
        this.notificationEnabledButton.setSelection(this.getPreferenceStore().getDefaultBoolean("org.eclipse.mylyn.tasks.ui.notifications.enabled"));
        this.backupScheduleTimeText.setText(this.getPreferenceStore().getDefaultString("org.eclipse.mylyn.tasks.ui.backup.schedule"));
        this.useRichEditor.setSelection(this.getPreferenceStore().getDefaultBoolean("org.eclipse.mylyn.tasks.ui.reporting.open.editor"));
        this.enableBackgroundSynch.setSelection(this.getPreferenceStore().getDefaultBoolean("org.eclipse.mylyn.tasks.ui.repositories.synch.schedule"));
        long miliseconds = this.getPreferenceStore().getDefaultLong("org.eclipse.mylyn.tasks.ui.repositories.synch.schedule.miliseconds");
        long minutes = miliseconds / 60000L;
        this.synchScheduleTime.setText("" + minutes);
        int activityTimeoutMinutes = MonitorUiPlugin.getDefault().getPreferenceStore().getDefaultInt("org.eclipse.mylyn.monitor.ui.activity.timeout") / 60000;
        this.timeoutMinutes.setSelection(activityTimeoutMinutes);
        this.timeoutEnabledButton.setSelection(MonitorUiPlugin.getDefault().getPreferenceStore().getDefaultBoolean("org.eclipse.mylyn.monitor.ui.activity.timeout.enabled"));
        this.updateRefreshGroupEnablements();
    }

    private void createTaskRefreshScheduleGroup(Composite parent) {
        Group group = new Group(parent, 16);
        group.setText("Synchronization");
        GridLayout gridLayout = new GridLayout(1, false);
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)new GridData(768));
        Composite enableSynch = new Composite((Composite)group, 0);
        gridLayout = new GridLayout(4, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        enableSynch.setLayout((Layout)gridLayout);
        this.enableBackgroundSynch = new Button(enableSynch, 32);
        this.enableBackgroundSynch.setText("Synchronize with repositories every");
        this.enableBackgroundSynch.setSelection(this.getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.repositories.synch.schedule"));
        this.enableBackgroundSynch.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TasksUiPreferencePage.this.updateRefreshGroupEnablements();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.synchScheduleTime = new Text(enableSynch, 133120);
        GridData gridData = new GridData();
        gridData.widthHint = 25;
        this.synchScheduleTime.setLayoutData((Object)gridData);
        this.synchScheduleTime.setText(this.getMinutesString());
        this.synchScheduleTime.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TasksUiPreferencePage.this.updateRefreshGroupEnablements();
            }
        });
        Label label = new Label(enableSynch, 0);
        label.setText("minutes");
        this.notificationEnabledButton = new Button((Composite)group, 32);
        this.notificationEnabledButton.setText("Display notifications for overdue tasks and incoming changes");
        this.notificationEnabledButton.setSelection(this.getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.notifications.enabled"));
    }

    private void createOpenWith(Composite parent) {
        Group container = new Group(parent, 16);
        container.setLayout((Layout)new GridLayout(3, false));
        container.setLayoutData((Object)new GridData(768));
        container.setText("Task Editing");
        this.useRichEditor = new Button((Composite)container, 16);
        this.useRichEditor.setText("Rich Editor (Recommended)");
        this.useRichEditor.setSelection(this.getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.reporting.open.editor"));
        this.useWebBrowser = new Button((Composite)container, 16);
        this.useWebBrowser.setText("Web Browser");
        this.useWebBrowser.setSelection(!this.getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.reporting.open.editor"));
    }

    private void createTaskDataControl(Composite parent) {
        Group taskDataGroup = new Group(parent, 16);
        taskDataGroup.setText("Task Data");
        taskDataGroup.setLayout((Layout)new GridLayout(1, false));
        taskDataGroup.setLayoutData((Object)new GridData(768));
        Label label = new Label((Composite)taskDataGroup, 0);
        label.setText("Default data directory will move with workspace (Recommended)");
        Composite dataDirComposite = new Composite((Composite)taskDataGroup, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        dataDirComposite.setLayout((Layout)gridLayout);
        dataDirComposite.setLayoutData((Object)new GridData(768));
        label = new Label(dataDirComposite, 0);
        label.setText("Data directory: ");
        String taskDirectory = TasksUiPlugin.getDefault().getDataDirectory();
        taskDirectory = taskDirectory.replaceAll(BACKSLASH_MULTI, FORWARDSLASH);
        this.taskDirectoryText = new Text(dataDirComposite, 2048);
        this.taskDirectoryText.setText(taskDirectory);
        this.taskDirectoryText.setEditable(false);
        this.taskDirectoryText.setLayoutData((Object)new GridData(768));
        this.browse = new Button(dataDirComposite, 131072);
        this.browse.setText("Browse...");
        this.browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(TasksUiPreferencePage.this.getShell());
                dialog.setText(TasksUiPreferencePage.TITLE_FOLDER_SELECTION);
                dialog.setMessage(TasksUiPreferencePage.FOLDER_SELECTION_MESSAGE);
                String dir = TasksUiPreferencePage.this.taskDirectoryText.getText();
                dir = dir.replaceAll(TasksUiPreferencePage.BACKSLASH_MULTI, TasksUiPreferencePage.FORWARDSLASH);
                dialog.setFilterPath(dir);
                dir = dialog.open();
                if (dir == null || dir.equals("")) {
                    return;
                }
                dir = dir.replaceAll(TasksUiPreferencePage.BACKSLASH_MULTI, TasksUiPreferencePage.FORWARDSLASH);
                TasksUiPreferencePage.this.checkForExistingTasklist(dir);
                if (TasksUiPreferencePage.this.taskDataDirectoryAction != 1) {
                    TasksUiPreferencePage.this.taskDirectoryText.setText(dir);
                    TasksUiPreferencePage.this.backupFolderText.setText(String.valueOf(dir) + TasksUiPreferencePage.FORWARDSLASH + "backup");
                    TasksUiPreferencePage.this.backupNow.setEnabled(false);
                }
            }
        });
        Composite backupComposite = new Composite((Composite)taskDataGroup, 0);
        gridLayout = new GridLayout(5, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        backupComposite.setLayout((Layout)gridLayout);
        backupComposite.setLayoutData((Object)new GridData(768));
        label = new Label(backupComposite, 0);
        label.setText("Backup every");
        this.backupScheduleTimeText = new Text(backupComposite, 133120);
        GridData gridData_1 = new GridData();
        gridData_1.widthHint = 13;
        this.backupScheduleTimeText.setLayoutData((Object)gridData_1);
        this.backupScheduleTimeText.setText("" + this.getPreferenceStore().getInt("org.eclipse.mylyn.tasks.ui.backup.schedule"));
        this.backupScheduleTimeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TasksUiPreferencePage.this.updateRefreshGroupEnablements();
            }
        });
        label = new Label(backupComposite, 0);
        label.setText("days to");
        String backupDirectory = TasksUiPlugin.getDefault().getBackupFolderPath();
        backupDirectory = backupDirectory.replaceAll(BACKSLASH_MULTI, FORWARDSLASH);
        this.backupFolderText = new Text(backupComposite, 2048);
        this.backupFolderText.setText(backupDirectory);
        this.backupFolderText.setEditable(false);
        this.backupFolderText.setLayoutData((Object)new GridData(768));
        this.backupNow = new Button(backupComposite, 0);
        this.backupNow.setLayoutData((Object)new GridData(128));
        this.backupNow.setText("Backup Now");
        this.backupNow.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TasksUiPlugin.getDefault().getBackupManager().backupNow(true);
            }
        });
    }

    private void createSchedulingGroup(Composite container) {
        Group group = new Group(container, 16);
        group.setText(GROUP_WORK_WEEK_LABEL);
        group.setLayout((Layout)new GridLayout(5, false));
        group.setLayoutData((Object)new GridData(768));
        Label hourDayStartLabel = new Label((Composite)group, 0);
        hourDayStartLabel.setText(START_HOUR_LABEL);
        this.hourDayStart = new Spinner((Composite)group, 2048);
        this.hourDayStart.setDigits(0);
        this.hourDayStart.setIncrement(1);
        this.hourDayStart.setMaximum(23);
        this.hourDayStart.setMinimum(0);
        this.hourDayStart.setSelection(this.getPreferenceStore().getInt("org.eclipse.mylyn.tasks.ui.planning.start.hour"));
        this.hourDayStart.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TasksUiPreferencePage.this.updateRefreshGroupEnablements();
            }
        });
        Label spacer = new Label((Composite)group, 0);
        GridDataFactory.fillDefaults().hint(40, -1).applyTo((Control)spacer);
        Label hourDayEndLabel = new Label((Composite)group, 0);
        hourDayEndLabel.setText(END_HOUR_LABEL);
        this.hourDayEnd = new Spinner((Composite)group, 2048);
        this.hourDayEnd.setDigits(0);
        this.hourDayEnd.setIncrement(1);
        this.hourDayEnd.setMaximum(23);
        this.hourDayEnd.setMinimum(0);
        this.hourDayEnd.setSelection(this.getPreferenceStore().getInt("org.eclipse.mylyn.tasks.ui.planning.end.hour"));
        this.hourDayEnd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TasksUiPreferencePage.this.updateRefreshGroupEnablements();
            }
        });
    }

    private void createTaskActivityGroup(Composite container) {
        Group group = new Group(container, 16);
        group.setText(GROUP_TASK_TIMING);
        group.setLayout((Layout)new GridLayout(3, false));
        group.setLayoutData((Object)new GridData(768));
        boolean timeoutEnabled = MonitorUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.monitor.ui.activity.timeout.enabled");
        this.timeoutEnabledButton = new Button((Composite)group, 32);
        this.timeoutEnabledButton.setText("Enable inactivity timeouts");
        this.timeoutEnabledButton.setSelection(timeoutEnabled);
        this.timeoutEnabledButton.setToolTipText("If disabled, time accumulates while a task is active with no timeout due to inactivity.");
        this.timeoutEnabledButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TasksUiPreferencePage.this.updateRefreshGroupEnablements();
            }
        });
        GridDataFactory.swtDefaults().span(3, 1).applyTo((Control)this.timeoutEnabledButton);
        Label timeoutLabel = new Label((Composite)group, 0);
        timeoutLabel.setText(LABEL_ACTIVITY_TIMEOUT);
        this.timeoutMinutes = new Spinner((Composite)group, 2048);
        this.timeoutMinutes.setDigits(0);
        this.timeoutMinutes.setIncrement(5);
        this.timeoutMinutes.setMaximum(60);
        this.timeoutMinutes.setMinimum(1);
        long minutes = MonitorUiPlugin.getDefault().getPreferenceStore().getLong("org.eclipse.mylyn.monitor.ui.activity.timeout") / 60000L;
        this.timeoutMinutes.setSelection((int)minutes);
        this.timeoutMinutes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TasksUiPreferencePage.this.updateRefreshGroupEnablements();
            }
        });
        timeoutLabel = new Label((Composite)group, 0);
        timeoutLabel.setText(LABEL_ACTIVITY_TIMEOUT2);
    }

    public void updateRefreshGroupEnablements() {
        long number;
        String errorMessage = null;
        try {
            number = Integer.parseInt(this.backupScheduleTimeText.getText());
            if (number <= 0L) {
                errorMessage = "Backup schedule time must be > 0";
            } else if (this.backupFolderText.getText() == "") {
                errorMessage = "Backup destination folder must be specified";
            }
        }
        catch (NumberFormatException numberFormatException) {
            errorMessage = "Backup schedule time must be valid integer";
        }
        if (this.enableBackgroundSynch.getSelection()) {
            try {
                number = Long.parseLong(this.synchScheduleTime.getText());
                if (number <= 0L) {
                    errorMessage = "Synchronize schedule time must be > 0";
                }
            }
            catch (NumberFormatException numberFormatException) {
                errorMessage = "Synchronize schedule time must be valid integer";
            }
        }
        this.setErrorMessage(errorMessage);
        this.setValid(errorMessage == null);
        this.synchScheduleTime.setEnabled(this.enableBackgroundSynch.getSelection());
        this.timeoutMinutes.setEnabled(this.timeoutEnabledButton.getSelection());
    }

    private String getMinutesString() {
        long miliseconds = this.getPreferenceStore().getLong("org.eclipse.mylyn.tasks.ui.repositories.synch.schedule.miliseconds");
        long minutes = miliseconds / 60000L;
        return "" + minutes;
    }

    private void checkForExistingTasklist(String dir) {
        File newDataFolder = new File(dir);
        if (newDataFolder.exists()) {
            MessageDialog dialogConfirm = new MessageDialog(null, "Change data directory", null, "Your Task List will be backed up to the previous data directory and can be restored via:\n\n\tFile > Import > Mylyn > Task Data\n\nProceed to overwrite with Task List from:\n\n\t " + dir, 4, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 1);
            this.taskDataDirectoryAction = dialogConfirm.open();
            for (TaskEditor taskEditor : TasksUiUtil.getActiveRepositoryTaskEditors()) {
                TasksUiUtil.closeEditorInActivePage(taskEditor.getTaskEditorInput().getTask(), true);
            }
        } else {
            MessageDialog.openWarning((Shell)this.getControl().getShell(), (String)"Change data directory", (String)"Destination folder does not exist.");
        }
    }

    public void dispose() {
        if (this.toolkit != null && this.toolkit.getColors() != null) {
            this.toolkit.dispose();
        }
        super.dispose();
    }
}

