/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.views;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mylyn.internal.tasks.ui.views.IFilteredTreeListener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class AdaptiveRefreshPolicy {
    private int refreshThreshold = 1500;
    private Set<IFilteredTreeListener> listeners = new HashSet<IFilteredTreeListener>();
    private Text filterText = null;
    private String oldText = "";
    protected Job refreshJob;
    protected final IJobChangeListener REFRESH_JOB_LISTENER = new IJobChangeListener(){

        public void aboutToRun(IJobChangeEvent event) {
        }

        public void awake(IJobChangeEvent event) {
        }

        public void done(IJobChangeEvent event) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    for (IFilteredTreeListener listener : AdaptiveRefreshPolicy.this.listeners) {
                        listener.filterTextChanged(AdaptiveRefreshPolicy.this.filterText.getText());
                    }
                }
            });
        }

        public void running(IJobChangeEvent event) {
        }

        public void scheduled(IJobChangeEvent event) {
        }

        public void sleeping(IJobChangeEvent event) {
        }
    };

    public AdaptiveRefreshPolicy(Job refreshJob, Text filterText) {
        this.refreshJob = refreshJob;
        this.filterText = filterText;
        refreshJob.addJobChangeListener(this.REFRESH_JOB_LISTENER);
    }

    public void dispose() {
        if (this.refreshJob != null) {
            this.refreshJob.removeJobChangeListener(this.REFRESH_JOB_LISTENER);
        }
    }

    public void textChanged(String text) {
        if (this.refreshJob == null || this.oldText != null && this.oldText.equals(text)) {
            return;
        }
        this.refreshJob.cancel();
        int refreshDelay = 0;
        int textLength = text.length();
        if (textLength > 0) {
            refreshDelay = (int)((double)this.refreshThreshold / ((double)textLength * 0.6));
        }
        this.refreshJob.addJobChangeListener(this.REFRESH_JOB_LISTENER);
        this.refreshJob.schedule((long)refreshDelay);
        this.oldText = text;
    }

    public void addListener(IFilteredTreeListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IFilteredTreeListener listener) {
        this.listeners.remove(listener);
    }

    public void setRefreshDelay(int refreshDelay) {
        this.refreshThreshold = refreshDelay;
    }
}

