/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.views;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Layout;

public class DatePickerPanel
extends Composite
implements KeyListener,
ISelectionProvider {
    private org.eclipse.swt.widgets.List timeList = null;
    private ISelection selection = null;
    private Calendar date = null;
    private DateTime calendar = null;
    private List<ISelectionChangedListener> selectionListeners = new ArrayList<ISelectionChangedListener>();

    public DatePickerPanel(Composite parent, int style, Calendar initialDate) {
        this(parent, style, initialDate, true);
    }

    public DatePickerPanel(Composite parent, int style, Calendar initialDate, boolean includeTime) {
        super(parent, style);
        this.date = initialDate;
        this.initialize(includeTime);
        this.setDate(this.date);
    }

    private void initialize(boolean includeTime) {
        if (this.date == null) {
            this.date = GregorianCalendar.getInstance();
            this.date.set(11, TasksUiPlugin.getDefault().getPreferenceStore().getInt("org.eclipse.mylyn.tasks.ui.planning.end.hour"));
            this.date.set(12, 0);
            this.date.set(13, 0);
            this.date.set(14, 0);
        }
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = includeTime ? 2 : 2;
        this.setLayout((Layout)gridLayout);
        this.calendar = new DateTime((Composite)this, 1024);
        this.calendar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatePickerPanel.this.date.set(1, DatePickerPanel.this.calendar.getYear());
                DatePickerPanel.this.date.set(2, DatePickerPanel.this.calendar.getMonth());
                DatePickerPanel.this.date.set(5, DatePickerPanel.this.calendar.getDay());
                DatePickerPanel.this.setSelection(new DateSelection(DatePickerPanel.this.date));
                DatePickerPanel.this.notifyListeners(new SelectionChangedEvent((ISelectionProvider)DatePickerPanel.this, DatePickerPanel.this.getSelection()));
            }
        });
        if (includeTime) {
            this.createTimeList(this);
        }
    }

    private void createTimeList(Composite composite) {
        DateFormat dateFormat = DateFormat.getTimeInstance(3);
        Calendar tempCalendar = Calendar.getInstance();
        tempCalendar.set(12, 0);
        tempCalendar.set(13, 0);
        String[] times = new String[24];
        int x = 0;
        while (x < 24) {
            String timeString;
            tempCalendar.set(11, x);
            times[x] = timeString = dateFormat.format(tempCalendar.getTime());
            ++x;
        }
        ListViewer listViewer = new ListViewer(composite);
        listViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        listViewer.setInput((Object)times);
        this.timeList = listViewer.getList();
        listViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DatePickerPanel.this.date.set(11, DatePickerPanel.this.timeList.getSelectionIndex());
                DatePickerPanel.this.date.set(12, 0);
                DatePickerPanel.this.setSelection(new DateSelection(DatePickerPanel.this.date));
                DatePickerPanel.this.notifyListeners(new SelectionChangedEvent((ISelectionProvider)DatePickerPanel.this, DatePickerPanel.this.getSelection()));
            }
        });
        GridDataFactory.fillDefaults().hint(-1, 150).grab(false, true).applyTo((Control)this.timeList);
        if (this.date != null) {
            listViewer.setSelection((ISelection)new StructuredSelection((Object)times[this.date.get(11)]), true);
        } else {
            listViewer.setSelection((ISelection)new StructuredSelection((Object)times[8]), true);
        }
        this.timeList.addKeyListener((KeyListener)this);
    }

    public void setDate(Calendar date) {
        this.date = date;
        this.calendar.setYear(date.get(1));
        this.calendar.setMonth(date.get(2));
        this.calendar.setDay(date.get(5));
    }

    public void keyPressed(KeyEvent e) {
        if (e.keyCode == 27) {
            SelectionChangedEvent changeEvent = new SelectionChangedEvent((ISelectionProvider)this, new ISelection(){

                public boolean isEmpty() {
                    return true;
                }
            });
            this.notifyListeners(changeEvent);
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    private void notifyListeners(SelectionChangedEvent event) {
        for (ISelectionChangedListener listener : this.selectionListeners) {
            listener.selectionChanged(event);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add(listener);
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
    }

    public class DateSelection
    implements ISelection {
        private Calendar date;

        public DateSelection(Calendar calendar) {
            this.date = calendar;
        }

        public boolean isEmpty() {
            return this.date == null;
        }

        public Calendar getDate() {
            return this.date;
        }
    }
}

