/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.views;

import java.util.LinkedHashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.mylyn.internal.tasks.ui.util.TreeWalker;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.progress.WorkbenchJob;

abstract class DelayedRefreshJob
extends WorkbenchJob {
    static final long REFRESH_DELAY_DEFAULT = 200L;
    static final long REFRESH_DELAY_MAX = 500L;
    private final TreeViewer treeViewer;
    private static final int NOT_SCHEDULED = -1;
    private LinkedHashSet<Object> queue = new LinkedHashSet();
    private long scheduleTime = -1L;

    public DelayedRefreshJob(TreeViewer treeViewer, String name) {
        super(name);
        this.treeViewer = treeViewer;
        this.setSystem(true);
    }

    public void forceRefresh() {
        this.queue.add(null);
        this.runInUIThread((IProgressMonitor)new NullProgressMonitor());
    }

    public synchronized void refresh() {
        this.refreshTask(null);
    }

    public synchronized void refreshTask(Object element) {
        this.queue.add(element);
        if (this.scheduleTime == -1L) {
            this.scheduleTime = System.currentTimeMillis();
            this.schedule(200L);
        } else if (System.currentTimeMillis() - this.scheduleTime < 300L) {
            this.cancel();
            this.schedule(200L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus runInUIThread(IProgressMonitor monitor) {
        ISelection newSelection;
        Object[] items;
        if (this.treeViewer.getControl() == null || this.treeViewer.getControl().isDisposed()) {
            return Status.CANCEL_STATUS;
        }
        DelayedRefreshJob delayedRefreshJob = this;
        synchronized (delayedRefreshJob) {
            items = this.queue.contains(null) ? (Object[])null : this.queue.toArray(new Object[0]);
            this.queue.clear();
            this.scheduleTime = -1L;
        }
        TreeItem[] selection = this.treeViewer.getTree().getSelection();
        TreePath treePath = null;
        if (selection.length > 0) {
            TreeWalker treeWalker = new TreeWalker(this.treeViewer);
            treePath = treeWalker.walk(new TreeWalker.TreeVisitor(){

                public boolean visit(Object object) {
                    return true;
                }
            }, selection[selection.length - 1]);
        }
        this.refresh(items);
        if (treePath != null && ((newSelection = this.treeViewer.getSelection()) == null || newSelection.isEmpty())) {
            this.treeViewer.setSelection((ISelection)new TreeSelection(treePath), true);
        }
        return Status.OK_STATUS;
    }

    protected void refresh(Object[] items) {
        if (items == null) {
            this.treeViewer.refresh(true);
        } else if (items.length > 0) {
            try {
                Object[] objectArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    Object item = objectArray[n2];
                    if (item instanceof AbstractTask) {
                        AbstractTask task = (AbstractTask)item;
                        this.treeViewer.refresh((Object)task, true);
                    } else {
                        this.treeViewer.refresh(item, true);
                    }
                    this.updateExpansionState(item);
                    ++n2;
                }
            }
            catch (SWTException e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Failed to refresh viewer: " + this.treeViewer, (Throwable)e));
            }
        }
    }

    protected abstract void updateExpansionState(Object var1);
}

