/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.context.core.ContextCorePlugin;
import org.eclipse.mylyn.monitor.core.InteractionEvent;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskActivationHistory {
    private List<AbstractTask> history = new ArrayList<AbstractTask>();
    private int currentIndex = -1;
    private static final int NUM_SAVED_HISTORY_ITEMS_TO_LOAD = 12;
    private boolean persistentHistoryLoaded = false;

    public void loadPersistentHistory() {
        int tasksAdded = 0;
        this.history.clear();
        int i = ContextCorePlugin.getContextManager().getActivityMetaContext().getInteractionHistory().size() - 1;
        while (i >= 0) {
            AbstractTask prevTask = this.getHistoryTaskAt(i);
            if (prevTask != null && !this.history.contains(prevTask)) {
                this.history.add(0, prevTask);
                ++this.currentIndex;
                if (++tasksAdded == 12) break;
            }
            --i;
        }
        this.persistentHistoryLoaded = true;
    }

    protected AbstractTask getHistoryTaskAt(int pos) {
        InteractionEvent event = (InteractionEvent)ContextCorePlugin.getContextManager().getActivityMetaContext().getInteractionHistory().get(pos);
        return TasksUiPlugin.getTaskListManager().getTaskList().getTask(event.getStructureHandle());
    }

    public void addTask(AbstractTask task) {
        try {
            if (!this.persistentHistoryLoaded) {
                this.loadPersistentHistory();
                this.persistentHistoryLoaded = true;
            }
            this.history.remove(task);
            this.history.add(task);
            this.currentIndex = this.history.size() - 1;
        }
        catch (RuntimeException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not add task to history", (Throwable)e));
        }
    }

    public boolean containsTask(AbstractTask task) {
        return this.history.contains(task);
    }

    public boolean removeTask(AbstractTask task) {
        return this.history.remove(task);
    }

    public AbstractTask getPreviousTask() {
        try {
            boolean active = false;
            for (AbstractTask task : this.history) {
                if (!task.isActive()) continue;
                active = true;
                break;
            }
            if (this.hasPrevious()) {
                if (this.currentIndex < this.history.size() - 1 && (this.currentIndex == 0 && !this.history.get(this.currentIndex).isActive() || !active)) {
                    return this.history.get(this.currentIndex);
                }
                if (this.currentIndex > 0 && this.currentIndex < this.history.size()) {
                    return this.history.get(--this.currentIndex);
                }
            }
            return null;
        }
        catch (RuntimeException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not get previous task from history", (Throwable)e));
            return null;
        }
    }

    public List<AbstractTask> getPreviousTasks() {
        return Collections.unmodifiableList(this.history);
    }

    public boolean hasPrevious() {
        try {
            if (!this.persistentHistoryLoaded) {
                this.loadPersistentHistory();
                this.persistentHistoryLoaded = true;
            }
            return this.currentIndex == 0 && !this.history.get(this.currentIndex).isActive() || this.currentIndex > 0;
        }
        catch (RuntimeException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not get previous task from history", (Throwable)e));
            return false;
        }
    }

    public void clear() {
        try {
            this.history.clear();
            this.currentIndex = -1;
        }
        catch (RuntimeException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not get clear history", (Throwable)e));
        }
    }
}

