/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.views;

import java.text.DateFormat;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.mylyn.internal.tasks.core.ScheduledTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.ScheduledTaskDelegate;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityManager;
import org.eclipse.mylyn.internal.tasks.ui.TaskListColorsAndFonts;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskElementLabelProvider;
import org.eclipse.mylyn.monitor.core.DateUtil;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class TaskActivityLabelProvider
extends TaskElementLabelProvider
implements ITableLabelProvider,
IColorProvider,
IFontProvider {
    private static final String UNITS_HOURS = " hours";
    private static final String NO_MINUTES = "0 minutes";
    private TaskActivityManager activityManager;
    private Color categoryBackgroundColor;
    private ITreeContentProvider contentProvider;

    public TaskActivityLabelProvider(ILabelProvider provider, ILabelDecorator decorator, Color parentBacground, ITreeContentProvider contentProvider) {
        super(true);
        this.categoryBackgroundColor = parentBacground;
        this.activityManager = TasksUiPlugin.getTaskActivityManager();
        this.contentProvider = contentProvider;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex != 0) {
            if (columnIndex != 1) return null;
            if (!(element instanceof ScheduledTaskDelegate)) return null;
            ScheduledTaskDelegate taskElement = (ScheduledTaskDelegate)element;
            return TasksUiImages.getImageForPriority(AbstractTask.PriorityLevel.fromString((String)taskElement.getPriority()));
        }
        if (element instanceof ScheduledTaskContainer) {
            super.getImage(element);
            return null;
        }
        if (!(element instanceof ScheduledTaskDelegate)) return super.getImage(element);
        return super.getImage(((ScheduledTaskDelegate)element).getCorrespondingTask());
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof ScheduledTaskDelegate) {
            ScheduledTaskDelegate activityDelegate = (ScheduledTaskDelegate)element;
            AbstractTask task = activityDelegate.getCorrespondingTask();
            switch (columnIndex) {
                case 2: {
                    if (task != null) {
                        return task.getSummary();
                    }
                }
                case 3: {
                    return DateUtil.getFormattedDurationShort((long)this.activityManager.getElapsedTime(task, activityDelegate.getDateRangeContainer().getStart(), activityDelegate.getDateRangeContainer().getEnd()));
                }
                case 4: {
                    return String.valueOf(task.getEstimateTimeHours()) + UNITS_HOURS;
                }
                case 5: {
                    if (task.getScheduledForDate() != null) {
                        return DateFormat.getDateInstance(2).format(task.getScheduledForDate());
                    }
                    return "";
                }
            }
        } else if (element instanceof ScheduledTaskContainer) {
            ScheduledTaskContainer taskCategory = (ScheduledTaskContainer)element;
            switch (columnIndex) {
                case 2: {
                    if (taskCategory.isPresent()) {
                        return String.valueOf(taskCategory.getSummary()) + " - Today";
                    }
                    return taskCategory.getSummary();
                }
                case 3: {
                    String elapsedTimeString = NO_MINUTES;
                    try {
                        long elapsed = 0L;
                        Object[] objectArray = this.contentProvider.getChildren((Object)taskCategory);
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object o = objectArray[n2];
                            if (o instanceof ScheduledTaskDelegate) {
                                elapsed += this.activityManager.getElapsedTime(((ScheduledTaskDelegate)o).getCorrespondingTask(), taskCategory.getStart(), taskCategory.getEnd());
                            }
                            ++n2;
                        }
                        elapsedTimeString = DateUtil.getFormattedDurationShort((long)elapsed);
                        if (elapsedTimeString.equals("")) {
                            elapsedTimeString = NO_MINUTES;
                        }
                    }
                    catch (RuntimeException e) {
                        StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not format elapsed time", (Throwable)e));
                    }
                    return elapsedTimeString;
                }
                case 4: {
                    long estimated = 0L;
                    Object[] objectArray = this.contentProvider.getChildren((Object)taskCategory);
                    int n = objectArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        Object o = objectArray[n3];
                        if (o instanceof AbstractTask) {
                            estimated += (long)((AbstractTask)o).getEstimateTimeHours();
                        }
                        ++n3;
                    }
                    return String.valueOf(estimated) + UNITS_HOURS;
                }
            }
        }
        return null;
    }

    public Color getBackground(Object element) {
        if (element instanceof AbstractTaskContainer && !(element instanceof AbstractTask)) {
            return this.categoryBackgroundColor;
        }
        return super.getBackground(element);
    }

    public Font getFont(Object element) {
        if (element instanceof ScheduledTaskContainer) {
            ScheduledTaskContainer container = (ScheduledTaskContainer)element;
            if (container.isPresent()) {
                return TaskListColorsAndFonts.BOLD;
            }
        } else if (element instanceof ScheduledTaskDelegate) {
            ScheduledTaskDelegate durationDelegate = (ScheduledTaskDelegate)element;
            return super.getFont(durationDelegate.getCorrespondingTask());
        }
        return super.getFont(element);
    }

    public void setCategoryBackgroundColor(Color categoryBackgroundColor) {
        this.categoryBackgroundColor = categoryBackgroundColor;
    }
}

