/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.views;

import java.util.regex.Pattern;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.mylyn.internal.tasks.core.Person;
import org.eclipse.mylyn.internal.tasks.core.ScheduledTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityManager;
import org.eclipse.mylyn.internal.tasks.core.TaskArchive;
import org.eclipse.mylyn.internal.tasks.core.TaskCategory;
import org.eclipse.mylyn.internal.tasks.core.TaskGroup;
import org.eclipse.mylyn.internal.tasks.core.UncategorizedTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.UnmatchedTaskContainer;
import org.eclipse.mylyn.internal.tasks.ui.ITaskHighlighter;
import org.eclipse.mylyn.internal.tasks.ui.TaskListColorsAndFonts;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.themes.IThemeManager;

public class TaskElementLabelProvider
extends LabelProvider
implements IColorProvider,
IFontProvider {
    private static final String NO_SUMMARY_AVAILABLE = ": <no summary available>";
    private IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
    private static final Pattern pattern = Pattern.compile("\\d*: .*");
    private boolean wideImages = false;

    public TaskElementLabelProvider(boolean wideImages) {
        this.wideImages = wideImages;
    }

    public Image getImage(Object element) {
        CompositeImageDescriptor compositeDescriptor = this.getImageDescriptor(element);
        if (element instanceof AbstractTask) {
            if (compositeDescriptor.overlayKind == null) {
                compositeDescriptor.overlayKind = TasksUiImages.OVERLAY_BLANK;
            }
            return TasksUiImages.getCompositeTaskImage(compositeDescriptor.icon, compositeDescriptor.overlayKind, this.wideImages);
        }
        if (element instanceof AbstractTaskContainer) {
            return TasksUiImages.getCompositeTaskImage(compositeDescriptor.icon, TasksUiImages.OVERLAY_BLANK, this.wideImages);
        }
        return TasksUiImages.getCompositeTaskImage(compositeDescriptor.icon, null, this.wideImages);
    }

    private CompositeImageDescriptor getImageDescriptor(Object object) {
        CompositeImageDescriptor compositeDescriptor = new CompositeImageDescriptor();
        if (object instanceof TaskArchive || object instanceof UncategorizedTaskContainer) {
            compositeDescriptor.icon = TasksUiImages.CATEGORY_ARCHIVE;
            return compositeDescriptor;
        }
        if (object instanceof TaskCategory) {
            compositeDescriptor.icon = TasksUiImages.CATEGORY;
        } else if (object instanceof TaskGroup) {
            compositeDescriptor.icon = TasksUiImages.TASK_GROUPING;
        }
        if (object instanceof AbstractTaskContainer) {
            AbstractTaskContainer element = (AbstractTaskContainer)object;
            AbstractRepositoryConnectorUi connectorUi = null;
            if (element instanceof AbstractTask) {
                AbstractTask repositoryTask = (AbstractTask)element;
                connectorUi = TasksUiPlugin.getConnectorUi(((AbstractTask)element).getConnectorKind());
                if (connectorUi != null) {
                    compositeDescriptor.overlayKind = connectorUi.getTaskKindOverlay(repositoryTask);
                }
            } else if (element instanceof AbstractRepositoryQuery) {
                connectorUi = TasksUiPlugin.getConnectorUi(((AbstractRepositoryQuery)element).getRepositoryKind());
            }
            if (connectorUi != null) {
                compositeDescriptor.icon = connectorUi.getTaskListElementIcon(element);
                return compositeDescriptor;
            }
            if (element instanceof UnmatchedTaskContainer) {
                compositeDescriptor.icon = TasksUiImages.QUERY_UNMATCHED;
            } else if (element instanceof AbstractRepositoryQuery || object instanceof UnmatchedTaskContainer) {
                compositeDescriptor.icon = TasksUiImages.QUERY;
            } else if (element instanceof AbstractTask) {
                compositeDescriptor.icon = TasksUiImages.TASK;
            } else if (element instanceof ScheduledTaskContainer) {
                compositeDescriptor.icon = TasksUiImages.CALENDAR;
            } else if (element instanceof Person) {
                compositeDescriptor.icon = TasksUiImages.PERSON;
                TaskRepository repository = TasksUiPlugin.getRepositoryManager().getRepository(((Person)element).getRepositoryUrl());
                if (repository != null && !repository.isAnonymous() && repository.getUserName() != null && repository.getUserName().equalsIgnoreCase(element.getHandleIdentifier())) {
                    compositeDescriptor.icon = TasksUiImages.PERSON_ME;
                }
            }
            return compositeDescriptor;
        }
        return compositeDescriptor;
    }

    public static ImageDescriptor getSynchronizationImageDescriptor(Object element, boolean synchViewStyle) {
        AbstractRepositoryQuery query;
        if (element instanceof AbstractTask) {
            AbstractTask repositoryTask = (AbstractTask)element;
            if (repositoryTask.getSynchronizationState() == AbstractTask.RepositoryTaskSyncState.INCOMING && repositoryTask.getLastReadTimeStamp() == null) {
                if (synchViewStyle) {
                    return TasksUiImages.OVERLAY_SYNCH_INCOMMING_NEW;
                }
                return TasksUiImages.OVERLAY_INCOMMING_NEW;
            }
            ImageDescriptor imageDescriptor = null;
            if (repositoryTask.getSynchronizationState() == AbstractTask.RepositoryTaskSyncState.OUTGOING) {
                imageDescriptor = synchViewStyle ? TasksUiImages.OVERLAY_SYNCH_OUTGOING : TasksUiImages.OVERLAY_OUTGOING;
            } else if (repositoryTask.getSynchronizationState() == AbstractTask.RepositoryTaskSyncState.INCOMING) {
                imageDescriptor = synchViewStyle ? TasksUiImages.OVERLAY_SYNCH_INCOMMING : TasksUiImages.OVERLAY_INCOMMING;
            } else if (repositoryTask.getSynchronizationState() == AbstractTask.RepositoryTaskSyncState.CONFLICT) {
                imageDescriptor = TasksUiImages.OVERLAY_CONFLICT;
            }
            if (imageDescriptor == null && repositoryTask.getSynchronizationStatus() != null) {
                return TasksUiImages.OVERLAY_WARNING;
            }
            if (imageDescriptor != null) {
                return imageDescriptor;
            }
        } else if (element instanceof AbstractRepositoryQuery && (query = (AbstractRepositoryQuery)element).getSynchronizationStatus() != null) {
            return TasksUiImages.OVERLAY_WARNING;
        }
        return TasksUiImages.OVERLAY_BLANK;
    }

    public static ImageDescriptor getPriorityImageDescriptor(Object element) {
        AbstractTask task;
        if (element instanceof AbstractTask) {
            AbstractTask repositoryTask = (AbstractTask)element;
            AbstractRepositoryConnectorUi connectorUi = TasksUiPlugin.getConnectorUi(((AbstractTask)element).getConnectorKind());
            if (connectorUi != null) {
                return connectorUi.getTaskPriorityOverlay(repositoryTask);
            }
        }
        if (element instanceof AbstractTask && (task = TaskElementLabelProvider.getCorrespondingTask((AbstractTaskContainer)element)) != null) {
            return TasksUiImages.getImageDescriptorForPriority(AbstractTask.PriorityLevel.fromString((String)task.getPriority()));
        }
        return null;
    }

    public String getText(Object object) {
        if (object instanceof AbstractTask) {
            AbstractTask task = (AbstractTask)object;
            if (task.getSummary() == null) {
                if (task.getTaskKey() != null) {
                    return String.valueOf(task.getTaskKey()) + NO_SUMMARY_AVAILABLE;
                }
                return String.valueOf(task.getTaskId()) + NO_SUMMARY_AVAILABLE;
            }
            if (!pattern.matcher(task.getSummary()).matches()) {
                if (task.getTaskKey() != null) {
                    return String.valueOf(task.getTaskKey()) + ": " + task.getSummary();
                }
                return task.getSummary();
            }
            return task.getSummary();
        }
        if (object instanceof TaskGroup) {
            TaskGroup element = (TaskGroup)object;
            return element.getSummary();
        }
        if (object instanceof UnmatchedTaskContainer) {
            UnmatchedTaskContainer container = (UnmatchedTaskContainer)object;
            String result = container.getSummary();
            TaskRepository repository = TasksUiPlugin.getRepositoryManager().getRepository(container.getConnectorKind(), container.getRepositoryUrl());
            if (repository != null) {
                result = "Unmatched [" + repository.getRepositoryLabel() + "]";
            }
            return result;
        }
        if (object instanceof AbstractTaskContainer) {
            AbstractTaskContainer element = (AbstractTaskContainer)object;
            return element.getSummary();
        }
        return super.getText(object);
    }

    public Color getForeground(Object object) {
        if (object instanceof AbstractTaskContainer && object instanceof AbstractTask) {
            AbstractTask task = TaskElementLabelProvider.getCorrespondingTask((AbstractTaskContainer)object);
            if (task != null) {
                if (TaskActivityManager.getInstance().isCompletedToday(task)) {
                    return this.themeManager.getCurrentTheme().getColorRegistry().get("org.eclipse.mylyn.tasks.ui.colors.foreground.today.completed");
                }
                if (task.isCompleted()) {
                    return this.themeManager.getCurrentTheme().getColorRegistry().get("org.eclipse.mylyn.tasks.ui.colors.foreground.completed");
                }
                if (task.isActive()) {
                    return TaskListColorsAndFonts.COLOR_TASK_ACTIVE;
                }
                if (TaskActivityManager.getInstance().isOverdue(task)) {
                    return this.themeManager.getCurrentTheme().getColorRegistry().get("org.eclipse.mylyn.tasks.ui.colors.foreground.past.due");
                }
                if (!task.internalIsFloatingScheduledDate() && task.isPastReminder()) {
                    return this.themeManager.getCurrentTheme().getColorRegistry().get("org.eclipse.mylyn.tasks.ui.colors.foreground.past.scheduled");
                }
                if (TaskActivityManager.getInstance().isScheduledForToday(task)) {
                    return this.themeManager.getCurrentTheme().getColorRegistry().get("org.eclipse.mylyn.tasks.ui.colors.foreground.today.scheduled");
                }
                if (TaskActivityManager.getInstance().isScheduledForThisWeek(task)) {
                    return this.themeManager.getCurrentTheme().getColorRegistry().get("org.eclipse.mylyn.tasks.ui.colors.foreground.thisweek.scheduled");
                }
            }
        } else if (object instanceof AbstractTaskContainer) {
            for (AbstractTask child : ((AbstractTaskContainer)object).getChildren()) {
                if (child.isActive() || this.showHasActiveChild((AbstractTaskContainer)child)) {
                    return TaskListColorsAndFonts.COLOR_TASK_ACTIVE;
                }
                if (!TaskActivityManager.getInstance().isOverdue(child)) continue;
                return this.themeManager.getCurrentTheme().getColorRegistry().get("org.eclipse.mylyn.tasks.ui.colors.foreground.past.due");
            }
        }
        return null;
    }

    public static AbstractTask getCorrespondingTask(AbstractTaskContainer element) {
        if (element instanceof AbstractTask) {
            return (AbstractTask)element;
        }
        return null;
    }

    public Color getBackground(Object element) {
        if (element instanceof AbstractTask) {
            AbstractTask task = (AbstractTask)element;
            ITaskHighlighter highlighter = TasksUiPlugin.getDefault().getHighlighter();
            if (highlighter != null) {
                return highlighter.getHighlightColor(task);
            }
        }
        return null;
    }

    public Font getFont(Object element) {
        AbstractTask repositoryTask;
        if (!(element instanceof AbstractTaskContainer)) {
            return null;
        }
        AbstractTask task = TaskElementLabelProvider.getCorrespondingTask((AbstractTaskContainer)element);
        if (task != null && (repositoryTask = task).isSynchronizing()) {
            return TaskListColorsAndFonts.ITALIC;
        }
        if (element instanceof AbstractTaskContainer) {
            if (element instanceof AbstractRepositoryQuery && ((AbstractRepositoryQuery)element).isSynchronizing()) {
                return TaskListColorsAndFonts.ITALIC;
            }
            for (AbstractTask child : ((AbstractTaskContainer)element).getChildren()) {
                if (!child.isActive() && !this.showHasActiveChild((AbstractTaskContainer)child)) continue;
                return TaskListColorsAndFonts.BOLD;
            }
        }
        if (task != null) {
            if (task.isActive()) {
                return TaskListColorsAndFonts.BOLD;
            }
            if (task.isCompleted()) {
                return TaskListColorsAndFonts.STRIKETHROUGH;
            }
            for (AbstractTask child : ((AbstractTaskContainer)element).getChildren()) {
                if (!child.isActive() && !this.showHasActiveChild((AbstractTaskContainer)child)) continue;
                return TaskListColorsAndFonts.BOLD;
            }
        }
        return null;
    }

    private boolean showHasActiveChild(AbstractTaskContainer container) {
        if (!TasksUiPlugin.getDefault().groupSubtasks(container)) {
            return false;
        }
        return this.showHasActiveChildHelper(container);
    }

    private boolean showHasActiveChildHelper(AbstractTaskContainer container) {
        for (AbstractTaskContainer child : container.getChildren()) {
            if (child instanceof AbstractTask && ((AbstractTask)child).isActive()) {
                return true;
            }
            if (!this.showHasActiveChildHelper(child)) continue;
            return true;
        }
        return false;
    }

    private class CompositeImageDescriptor {
        ImageDescriptor icon;
        ImageDescriptor overlayKind;

        private CompositeImageDescriptor() {
        }
    }
}

