/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.views;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.swt.graphics.Image;

public class TaskRepositoryLabelProvider
implements ILabelProvider {
    public Image getColumnImage(Object obj, int index) {
        if (index == 0) {
            return this.getImage(obj);
        }
        return null;
    }

    public Image getImage(Object object) {
        if (object instanceof AbstractRepositoryConnector) {
            AbstractRepositoryConnector repositoryConnector = (AbstractRepositoryConnector)object;
            Image image = TasksUiPlugin.getDefault().getBrandingIcon(repositoryConnector.getConnectorKind());
            if (image != null) {
                return image;
            }
            return TasksUiImages.getImage(TasksUiImages.REPOSITORY);
        }
        if (object instanceof TaskRepository) {
            if (((TaskRepository)object).isOffline()) {
                return TasksUiImages.getImage(TasksUiImages.REPOSITORY_OFFLINE);
            }
            return TasksUiImages.getImage(TasksUiImages.REPOSITORY);
        }
        return null;
    }

    public String getText(Object object) {
        if (object instanceof TaskRepository) {
            TaskRepository repository = (TaskRepository)object;
            StringBuilder label = new StringBuilder();
            label.append(repository.getRepositoryLabel());
            if (repository.isOffline()) {
                label.append(" [Disconnected]");
            }
            return label.toString();
        }
        if (object instanceof AbstractRepositoryConnector) {
            return ((AbstractRepositoryConnector)object).getLabel();
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

