/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.wizards;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.internal.tasks.core.LocalAttachment;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.internal.tasks.ui.wizards.NewAttachmentWizard;
import org.eclipse.mylyn.internal.tasks.ui.wizards.PreviewAttachmentPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewAttachmentPage
extends WizardPage {
    private LocalAttachment attachment;
    private Text filePath;
    private Text attachmentDesc;
    private Text attachmentComment;
    private Button isPatchButton;
    private Button attachContextButton;
    private Combo contentTypeList;
    private boolean supportsDescription = true;
    private static List<String> contentTypes = new LinkedList<String>();
    private static Map<String, String> extensions2Types;

    static {
        contentTypes.add("text/plain");
        contentTypes.add("text/html");
        contentTypes.add("application/xml");
        contentTypes.add("image/gif");
        contentTypes.add("image/jpeg");
        contentTypes.add("image/png");
        contentTypes.add("application/octet-stream");
        extensions2Types = new HashMap<String, String>();
        extensions2Types.put("txt", "text/plain");
        extensions2Types.put("html", "text/html");
        extensions2Types.put("htm", "text/html");
        extensions2Types.put("jpg", "image/jpeg");
        extensions2Types.put("jpeg", "image/jpeg");
        extensions2Types.put("gif", "image/gif");
        extensions2Types.put("png", "image/png");
        extensions2Types.put("xml", "application/xml");
        extensions2Types.put("zip", "application/octet-stream");
        extensions2Types.put("tar", "application/octet-stream");
        extensions2Types.put("gz", "application/octet-stream");
    }

    protected NewAttachmentPage(LocalAttachment att) {
        super("AttachmentDetails");
        this.setTitle("Attachment Details");
        this.setMessage("Enter a description and verify the content type of the attachment");
        this.attachment = att;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite.setLayout((Layout)gridLayout);
        this.setControl((Control)composite);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new GridLayout(3, false));
        final NewAttachmentPage thisPage = this;
        new Label(composite, 0).setText("File");
        this.filePath = new Text(composite, 2048);
        this.filePath.setEditable(false);
        this.filePath.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        if (this.supportsDescription) {
            new Label(composite, 0).setText("Description");
            this.attachmentDesc = new Text(composite, 2048);
            this.attachmentDesc.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
            this.attachmentDesc.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if ("".equals(NewAttachmentPage.this.attachmentDesc.getText().trim())) {
                        thisPage.setErrorMessage("Description required");
                    } else if (!"".equals(NewAttachmentPage.this.filePath.getText())) {
                        thisPage.setPageComplete(true);
                        thisPage.setErrorMessage(null);
                    }
                }
            });
        }
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(16384, 4, false, false));
        label.setText("Comment");
        this.attachmentComment = new Text(composite, 2624);
        this.attachmentComment.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        new Label(composite, 0).setText("Content Type");
        this.contentTypeList = new Combo(composite, 2060);
        this.contentTypeList.setLayoutData((Object)new GridData(-1, -1, false, false, 2, 1));
        final HashMap<String, Integer> contentTypeIndices = new HashMap<String, Integer>();
        Iterator<String> iter = contentTypes.iterator();
        int i = 0;
        while (iter.hasNext()) {
            String next = iter.next();
            this.contentTypeList.add(next);
            contentTypeIndices.put(next, new Integer(i));
            ++i;
        }
        this.contentTypeList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                NewAttachmentPage.this.attachment.setContentType(NewAttachmentPage.this.contentTypeList.getItem(NewAttachmentPage.this.contentTypeList.getSelectionIndex()));
            }
        });
        this.contentTypeList.select(0);
        this.attachment.setContentType(this.contentTypeList.getItem(0));
        new Label(composite, 0);
        this.isPatchButton = new Button(composite, 32);
        this.isPatchButton.setLayoutData((Object)new GridData(-1, -1, false, false, 2, 1));
        this.isPatchButton.setText("Patch");
        new Label(composite, 0);
        this.attachContextButton = new Button(composite, 32);
        this.attachContextButton.setLayoutData((Object)new GridData(-1, -1, false, false, 2, 1));
        this.attachContextButton.setText("Attach Context");
        this.attachContextButton.setImage(TasksUiImages.getImage(TasksUiImages.CONTEXT_ATTACH));
        this.attachContextButton.setEnabled(((NewAttachmentWizard)this.getWizard()).hasContext());
        this.filePath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                int index = NewAttachmentPage.this.filePath.getText().lastIndexOf(".");
                if (index > 0 && index < NewAttachmentPage.this.filePath.getText().length()) {
                    String ext = NewAttachmentPage.this.filePath.getText().substring(index + 1);
                    String type = (String)extensions2Types.get(ext.toLowerCase(Locale.ENGLISH));
                    if (type != null) {
                        NewAttachmentPage.this.contentTypeList.select(((Integer)contentTypeIndices.get(type)).intValue());
                        NewAttachmentPage.this.attachment.setContentType(type);
                    }
                }
                if (NewAttachmentPage.this.attachmentDesc != null && "".equals(NewAttachmentPage.this.attachmentDesc.getText())) {
                    thisPage.setErrorMessage("Description required");
                } else if (!"".equals(NewAttachmentPage.this.filePath.getText())) {
                    thisPage.setPageComplete(true);
                    thisPage.setErrorMessage(null);
                }
            }
        });
        this.filePath.setText(this.attachment.getFilePath() == null ? "" : this.attachment.getFilePath());
        this.isPatchButton.addSelectionListener(new SelectionListener(){
            private int lastSelected;

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                NewAttachmentPage.this.attachment.setPatch(NewAttachmentPage.this.isPatchButton.getSelection());
                if (NewAttachmentPage.this.isPatchButton.getSelection()) {
                    this.lastSelected = NewAttachmentPage.this.contentTypeList.getSelectionIndex();
                    NewAttachmentPage.this.contentTypeList.select(0);
                    NewAttachmentPage.this.contentTypeList.setEnabled(false);
                    if (NewAttachmentPage.this.attachContextButton.isEnabled()) {
                        NewAttachmentPage.this.attachContextButton.setSelection(true);
                    }
                } else {
                    NewAttachmentPage.this.contentTypeList.setEnabled(true);
                    NewAttachmentPage.this.contentTypeList.select(this.lastSelected);
                }
            }
        });
        thisPage.setErrorMessage(null);
    }

    public boolean isPageComplete() {
        return !"".equals(this.filePath.getText().trim()) && (this.attachmentDesc == null || !"".equals(this.attachmentDesc.getText().trim()));
    }

    public void populateAttachment() {
        if (this.attachmentDesc != null) {
            this.attachment.setDescription(this.attachmentDesc.getText());
        }
        this.attachment.setComment(this.attachmentComment.getText());
    }

    public LocalAttachment getAttachment() {
        return this.attachment;
    }

    public void setFilePath(String path) {
        this.filePath.setText(path);
        if (path.endsWith(".patch")) {
            this.isPatchButton.setSelection(true);
            if (this.attachContextButton.isEnabled()) {
                this.attachContextButton.setSelection(true);
            }
        }
    }

    public IWizardPage getNextPage() {
        this.populateAttachment();
        PreviewAttachmentPage page = new PreviewAttachmentPage(this.getAttachment());
        page.setWizard(this.getWizard());
        return page;
    }

    public boolean getAttachContext() {
        return this.attachContextButton.getSelection();
    }

    public void setContentType() {
        String type = this.attachment.getContentType();
        String[] typeList = this.contentTypeList.getItems();
        int i = 0;
        while (i < typeList.length) {
            if (typeList[i].equals(type)) {
                this.contentTypeList.select(i);
                this.contentTypeList.setEnabled(false);
                this.isPatchButton.setEnabled(false);
                return;
            }
            ++i;
        }
    }

    public boolean supportsDescription() {
        return this.supportsDescription;
    }

    public void setSupportsDescription(boolean supportsDescription) {
        this.supportsDescription = supportsDescription;
    }
}

