/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.wizards;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.internal.tasks.ui.TaskListColorsAndFonts;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.internal.tasks.ui.wizards.ColorSelectionWindow;
import org.eclipse.mylyn.internal.tasks.ui.wizards.IImageCreator;
import org.eclipse.mylyn.internal.tasks.ui.wizards.ImageAttachment;
import org.eclipse.mylyn.internal.tasks.ui.wizards.NewAttachmentPage;
import org.eclipse.mylyn.internal.tasks.ui.wizards.NewAttachmentWizard;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;

public class ScreenshotAttachmentPage
extends WizardPage
implements IImageCreator {
    private IAction captureAction;
    private IAction fitAction;
    private IAction cropAction;
    private IAction markAction;
    private IAction colorAction;
    private Image colorIcon;
    private Color markColor;
    private IAction clearAction;
    private Image originalImage;
    private Image workImage;
    private GC workImageGC;
    private Canvas canvas;
    private ScrolledComposite scrolledComposite;
    private Rectangle currentSelection;
    private Rectangle originalSelection;
    private Point startPoint;
    private Set<SelectionSide> resizableSides = EnumSet.noneOf(SelectionSide.class);
    private double scaleFactor = 1.0;
    private Map<Integer, Cursor> cursors = new HashMap<Integer, Cursor>();
    private EditorAction currentAction = EditorAction.CROPPING;
    private static final int CURSOR_MARK_TOOL = -1;
    private static final int SQUARE_SIZE = 3;
    private List<GrabPoint> grabPoints = new ArrayList<GrabPoint>(8);

    protected ScreenshotAttachmentPage() {
        super("ScreenShotAttachment");
        this.setTitle("Capture Screenshot");
        this.setDescription("After capturing, you can crop the image and make drawings on it. This window will not be captured. Note that you can continue to interact with the workbench in order to set up the screenshot.");
    }

    public void createControl(Composite parent) {
        ViewForm vf = new ViewForm(parent, 0x800800);
        vf.horizontalSpacing = 0;
        vf.verticalSpacing = 0;
        this.setControl((Control)vf);
        vf.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        this.allocateCursors();
        ToolBarManager tbm = new ToolBarManager(8519936);
        this.captureAction = new Action("&Capture Desktop", 1){
            private boolean isFirstCapture;
            {
                this.isFirstCapture = true;
            }

            public void run() {
                ScreenshotAttachmentPage.this.captureScreenshotContent();
                ScreenshotAttachmentPage.this.setErrorMessage(null);
                if (this.isFirstCapture) {
                    this.isFirstCapture = false;
                    ScreenshotAttachmentPage.this.fitAction.setEnabled(true);
                    ScreenshotAttachmentPage.this.cropAction.setEnabled(true);
                    ScreenshotAttachmentPage.this.cropAction.setChecked(true);
                    ScreenshotAttachmentPage.this.markAction.setEnabled(true);
                    ScreenshotAttachmentPage.this.clearAction.setEnabled(false);
                }
            }
        };
        this.captureAction.setToolTipText("Capture Desktop");
        this.captureAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)TasksUiImages.getImage(TasksUiImages.IMAGE_CAPTURE)));
        this.fitAction = new Action("", 2){

            public void run() {
                ScreenshotAttachmentPage.this.refreshCanvasSize();
            }
        };
        this.fitAction.setToolTipText("Fit Image");
        this.fitAction.setText("&Fit Image");
        this.fitAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)TasksUiImages.getImage(TasksUiImages.IMAGE_FIT)));
        this.fitAction.setChecked(true);
        this.fitAction.setEnabled(false);
        this.cropAction = new Action("C&rop", 8){

            public void run() {
                ScreenshotAttachmentPage.this.currentAction = EditorAction.CROPPING;
                ScreenshotAttachmentPage.this.cropAction.setChecked(true);
                ScreenshotAttachmentPage.this.markAction.setChecked(false);
                ScreenshotAttachmentPage.this.colorAction.setEnabled(false);
                ScreenshotAttachmentPage.this.canvas.redraw();
            }
        };
        this.cropAction.setToolTipText("Crop");
        this.cropAction.setImageDescriptor(TasksUiImages.CUT);
        this.cropAction.setEnabled(false);
        this.markAction = new Action("&Annotate", 8){

            public void run() {
                ScreenshotAttachmentPage.this.currentAction = EditorAction.MARKING;
                ScreenshotAttachmentPage.this.cropAction.setChecked(false);
                ScreenshotAttachmentPage.this.markAction.setChecked(true);
                ScreenshotAttachmentPage.this.colorAction.setEnabled(true);
                ScreenshotAttachmentPage.this.canvas.redraw();
            }
        };
        this.markAction.setToolTipText("Draw annotations on screenshot image");
        this.markAction.setImageDescriptor(TasksUiImages.EDIT);
        this.markAction.setEnabled(false);
        this.colorAction = new Action("", 4){

            public void runWithEvent(final Event e) {
                ColorSelectionWindow colorWindow = new ColorSelectionWindow(ScreenshotAttachmentPage.this.getControl().getShell()){

                    protected Point getInitialLocation(Point initialSize) {
                        ToolItem toolItem = (ToolItem)e.widget;
                        Rectangle itemBounds = toolItem.getBounds();
                        Point location = toolItem.getParent().toDisplay(itemBounds.x + itemBounds.width, itemBounds.y + itemBounds.height);
                        location.x -= initialSize.x;
                        return location;
                    }
                };
                colorWindow.setBlockOnOpen(true);
                colorWindow.open();
                RGB color = colorWindow.getSelectedRGB();
                if (color != null) {
                    ScreenshotAttachmentPage.this.setMarkColor(color);
                }
            }
        };
        this.colorAction.setToolTipText("Change pen color");
        this.colorIcon = new Image((Device)this.getShell().getDisplay(), 16, 16);
        this.setMarkColor(new RGB(255, 85, 85));
        this.colorAction.setEnabled(false);
        this.clearAction = new Action("C&lear Annotations", 1){

            public void run() {
                ScreenshotAttachmentPage.this.clearAction.setEnabled(false);
                ScreenshotAttachmentPage.this.workImageGC.drawImage(ScreenshotAttachmentPage.this.originalImage, 0, 0);
                ScreenshotAttachmentPage.this.canvas.redraw();
                ScreenshotAttachmentPage.this.markAttachmentDirty();
            }
        };
        this.clearAction.setToolTipText("Clear all annotations made on screenshot image");
        this.clearAction.setImageDescriptor(TasksUiImages.CLEAR);
        this.clearAction.setEnabled(false);
        tbm.add((IContributionItem)this.createAndConfigureCI(this.captureAction));
        tbm.add((IContributionItem)this.createAndConfigureCI(this.fitAction));
        tbm.add((IContributionItem)new Separator());
        tbm.add((IContributionItem)this.createAndConfigureCI(this.cropAction));
        tbm.add((IContributionItem)this.createAndConfigureCI(this.markAction));
        tbm.add((IContributionItem)this.createAndConfigureCI(this.colorAction));
        tbm.add((IContributionItem)new Separator());
        tbm.add((IContributionItem)this.createAndConfigureCI(this.clearAction));
        this.scrolledComposite = new ScrolledComposite((Composite)vf, 768);
        this.canvas = new Canvas((Composite)this.scrolledComposite, 0x20000000);
        this.scrolledComposite.setContent((Control)this.canvas);
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (ScreenshotAttachmentPage.this.workImage != null) {
                    Rectangle imageBounds = ScreenshotAttachmentPage.this.workImage.getBounds();
                    Rectangle canvasBounds = ScreenshotAttachmentPage.this.canvas.getClientArea();
                    if (ScreenshotAttachmentPage.this.fitAction.isChecked()) {
                        e.gc.drawImage(ScreenshotAttachmentPage.this.workImage, 0, 0, imageBounds.width, imageBounds.height, 0, 0, canvasBounds.width, canvasBounds.height);
                    } else {
                        e.gc.drawImage(ScreenshotAttachmentPage.this.workImage, 0, 0);
                    }
                    ScreenshotAttachmentPage.this.drawSelection(e.gc);
                } else {
                    ScreenshotAttachmentPage.this.fitAction.setEnabled(false);
                }
            }
        });
        this.scrolledComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (ScreenshotAttachmentPage.this.fitAction.isChecked()) {
                    ScreenshotAttachmentPage.this.refreshCanvasSize();
                }
            }
        });
        vf.setTopLeft((Control)tbm.createControl((Composite)vf));
        vf.setContent((Control)this.scrolledComposite);
        this.registerMouseListeners();
    }

    private ActionContributionItem createAndConfigureCI(IAction action) {
        ActionContributionItem ci = new ActionContributionItem(action);
        ci.setMode(ActionContributionItem.MODE_FORCE_TEXT);
        return ci;
    }

    private void setMarkColor(RGB color) {
        if (this.markColor != null) {
            this.markColor.dispose();
        }
        this.markColor = new Color((Device)this.getShell().getDisplay(), color);
        if (this.workImageGC != null) {
            this.workImageGC.setForeground(this.markColor);
        }
        GC colorGC = new GC((Drawable)this.colorIcon);
        colorGC.setBackground(this.markColor);
        colorGC.fillRectangle(0, 0, 16, 16);
        colorGC.drawRectangle(0, 0, 15, 15);
        colorGC.dispose();
        this.colorAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)this.colorIcon));
    }

    public void dispose() {
        this.disposeImageResources();
        if (this.markColor != null) {
            this.markColor.dispose();
        }
        if (this.colorIcon != null) {
            this.colorIcon.dispose();
        }
        this.canvas.setCursor(null);
        for (Cursor cursor : this.cursors.values()) {
            cursor.dispose();
        }
        super.dispose();
    }

    private void disposeImageResources() {
        if (this.originalImage != null) {
            this.originalImage.dispose();
        }
        if (this.workImageGC != null) {
            this.workImageGC.dispose();
        }
        if (this.workImage != null) {
            this.workImage.dispose();
        }
    }

    private void allocateCursors() {
        Display display = this.getShell().getDisplay();
        this.cursors.put(0, new Cursor((Device)display, 0));
        this.cursors.put(5, new Cursor((Device)display, 5));
        this.cursors.put(8, new Cursor((Device)display, 8));
        this.cursors.put(6, new Cursor((Device)display, 6));
        this.cursors.put(7, new Cursor((Device)display, 7));
        this.cursors.put(9, new Cursor((Device)display, 9));
        this.cursors.put(2, new Cursor((Device)display, 2));
        this.cursors.put(-1, new Cursor((Device)display, 21));
    }

    private Rectangle getScaledSelection() {
        if (this.currentSelection == null) {
            return null;
        }
        int x = (int)Math.round((double)this.currentSelection.x * this.scaleFactor);
        int y = (int)Math.round((double)this.currentSelection.y * this.scaleFactor);
        int right = (int)Math.round((double)(this.currentSelection.x + this.currentSelection.width) * this.scaleFactor);
        int bottom = (int)Math.round((double)(this.currentSelection.y + this.currentSelection.height) * this.scaleFactor);
        int width = Math.min(right, (int)Math.round((double)(this.workImage.getBounds().width - 1) * this.scaleFactor)) - x;
        int height = Math.min(bottom, (int)Math.round((double)(this.workImage.getBounds().height - 1) * this.scaleFactor)) - y;
        return new Rectangle(x, y, width, height);
    }

    public boolean isPageComplete() {
        return this.workImage != null;
    }

    public IWizardPage getNextPage() {
        NewAttachmentPage page = (NewAttachmentPage)this.getWizard().getPage("AttachmentDetails");
        page.setFilePath("<Screenshot>");
        page.setContentType();
        return page;
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    private void captureScreenshotContent() {
        Display display = this.getShell().getDisplay();
        Shell wizardShell = this.getWizard().getContainer().getShell();
        wizardShell.setVisible(false);
        try {
            Thread.sleep(400L);
        }
        catch (InterruptedException interruptedException) {}
        this.disposeImageResources();
        Rectangle displayBounds = display.getBounds();
        this.originalImage = new Image((Device)display, displayBounds);
        this.workImage = new Image((Device)display, displayBounds);
        GC gc = new GC((Drawable)display);
        gc.copyArea(this.originalImage, 0, 0);
        gc.copyArea(this.workImage, 0, 0);
        gc.dispose();
        this.workImageGC = new GC((Drawable)this.workImage);
        this.workImageGC.setForeground(this.markColor);
        this.workImageGC.setLineWidth(4);
        this.workImageGC.setLineCap(2);
        this.clearSelection();
        this.refreshCanvasSize();
        wizardShell.setVisible(true);
        this.setPageComplete(true);
    }

    private void refreshCurrentSelection(int x, int y) {
        int startX = Math.min(this.startPoint.x, x);
        int startY = Math.min(this.startPoint.y, y);
        int width = Math.abs(this.startPoint.x - x);
        int height = Math.abs(this.startPoint.y - y);
        this.currentSelection = new Rectangle(startX, startY, width, height);
        Rectangle imageBounds = this.workImage.getBounds();
        --imageBounds.width;
        --imageBounds.height;
        this.currentSelection.intersect(imageBounds);
    }

    private void setUpGrabPoints() {
        this.grabPoints.clear();
        if (this.currentSelection == null) {
            return;
        }
        Rectangle scaledSelection = this.getScaledSelection();
        this.grabPoints.add(GrabPoint.createGrabPoint(scaledSelection.x, scaledSelection.y, 8, (Set<SelectionSide>)EnumSet.of(SelectionSide.LEFT, SelectionSide.TOP)));
        this.grabPoints.add(GrabPoint.createGrabPoint(scaledSelection.x + scaledSelection.width / 2, scaledSelection.y, 7, (Set<SelectionSide>)EnumSet.of(SelectionSide.TOP)));
        this.grabPoints.add(GrabPoint.createGrabPoint(scaledSelection.x + scaledSelection.width, scaledSelection.y, 6, (Set<SelectionSide>)EnumSet.of(SelectionSide.TOP, SelectionSide.RIGHT)));
        this.grabPoints.add(GrabPoint.createGrabPoint(scaledSelection.x, scaledSelection.y + scaledSelection.height / 2, 9, (Set<SelectionSide>)EnumSet.of(SelectionSide.LEFT)));
        this.grabPoints.add(GrabPoint.createGrabPoint(scaledSelection.x + scaledSelection.width, scaledSelection.y + scaledSelection.height / 2, 9, (Set<SelectionSide>)EnumSet.of(SelectionSide.RIGHT)));
        this.grabPoints.add(GrabPoint.createGrabPoint(scaledSelection.x, scaledSelection.y + scaledSelection.height, 6, (Set<SelectionSide>)EnumSet.of(SelectionSide.LEFT, SelectionSide.BOTTOM)));
        this.grabPoints.add(GrabPoint.createGrabPoint(scaledSelection.x + scaledSelection.width / 2, scaledSelection.y + scaledSelection.height, 7, (Set<SelectionSide>)EnumSet.of(SelectionSide.BOTTOM)));
        this.grabPoints.add(GrabPoint.createGrabPoint(scaledSelection.x + scaledSelection.width, scaledSelection.y + scaledSelection.height, 8, (Set<SelectionSide>)EnumSet.of(SelectionSide.BOTTOM, SelectionSide.RIGHT)));
    }

    private void refreshSelectionResize(int x, int y) {
        this.currentSelection = new Rectangle(this.originalSelection.x, this.originalSelection.y, this.originalSelection.width, this.originalSelection.height);
        int deltaX = x - this.startPoint.x;
        int deltaY = y - this.startPoint.y;
        Rectangle imageBounds = this.workImage.getBounds();
        if (this.resizableSides.contains((Object)SelectionSide.LEFT) && this.originalSelection.x + (deltaX = Math.min(deltaX, this.originalSelection.width)) < 0) {
            deltaX = -this.originalSelection.x;
        }
        if (this.resizableSides.contains((Object)SelectionSide.RIGHT) && this.originalSelection.x + this.originalSelection.width + (deltaX = Math.max(deltaX, -this.originalSelection.width)) - 1 > imageBounds.width) {
            deltaX = imageBounds.width - (this.originalSelection.x + this.originalSelection.width);
        }
        if (this.resizableSides.contains((Object)SelectionSide.TOP) && this.originalSelection.y + (deltaY = Math.min(deltaY, this.originalSelection.height)) < 0) {
            deltaY = -this.originalSelection.y;
        }
        if (this.resizableSides.contains((Object)SelectionSide.BOTTOM) && this.originalSelection.y + this.originalSelection.height + (deltaY = Math.max(deltaY, -this.originalSelection.height)) - 1 > imageBounds.height) {
            deltaY = imageBounds.height - (this.originalSelection.y + this.originalSelection.height);
        }
        if (this.resizableSides.contains((Object)SelectionSide.LEFT)) {
            this.currentSelection.x += deltaX;
            this.currentSelection.width -= deltaX;
        }
        if (this.resizableSides.contains((Object)SelectionSide.RIGHT)) {
            this.currentSelection.width += deltaX;
        }
        if (this.resizableSides.contains((Object)SelectionSide.TOP)) {
            this.currentSelection.y += deltaY;
            this.currentSelection.height -= deltaY;
        }
        if (this.resizableSides.contains((Object)SelectionSide.BOTTOM)) {
            this.currentSelection.height += deltaY;
        }
        this.setUpGrabPoints();
    }

    private void refreshSelectionPosition(int x, int y) {
        int newX = this.originalSelection.x + (x - this.startPoint.x);
        int newY = this.originalSelection.y + (y - this.startPoint.y);
        if (newX < 0) {
            newX = 0;
        }
        if (newY < 0) {
            newY = 0;
        }
        Rectangle imageBounds = this.workImage.getBounds();
        if (newX + this.originalSelection.width - 1 > imageBounds.width) {
            newX = imageBounds.width - this.originalSelection.width;
        }
        if (newY + this.originalSelection.height - 1 > imageBounds.height) {
            newY = imageBounds.height - this.originalSelection.height;
        }
        this.currentSelection = new Rectangle(newX, newY, this.originalSelection.width, this.originalSelection.height);
        this.setUpGrabPoints();
    }

    private void registerMouseListeners() {
        this.canvas.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                int scaledX = (int)Math.round((double)e.x / ScreenshotAttachmentPage.this.scaleFactor);
                int scaledY = (int)Math.round((double)e.y / ScreenshotAttachmentPage.this.scaleFactor);
                if (ScreenshotAttachmentPage.this.currentAction == EditorAction.SELECTING) {
                    ScreenshotAttachmentPage.this.refreshCurrentSelection(scaledX, scaledY);
                    ScreenshotAttachmentPage.this.canvas.redraw();
                } else if (ScreenshotAttachmentPage.this.currentAction == EditorAction.RESIZING_SELECTION) {
                    ScreenshotAttachmentPage.this.refreshSelectionResize(scaledX, scaledY);
                    ScreenshotAttachmentPage.this.canvas.redraw();
                } else if (ScreenshotAttachmentPage.this.currentAction == EditorAction.MOVING_SELECTION) {
                    ScreenshotAttachmentPage.this.refreshSelectionPosition(scaledX, scaledY);
                    ScreenshotAttachmentPage.this.canvas.redraw();
                } else if (ScreenshotAttachmentPage.this.currentAction == EditorAction.CROPPING && ScreenshotAttachmentPage.this.currentSelection != null) {
                    boolean cursorSet = false;
                    for (GrabPoint point : ScreenshotAttachmentPage.this.grabPoints) {
                        if (!point.grabArea.contains(e.x, e.y)) continue;
                        ScreenshotAttachmentPage.this.canvas.setCursor((Cursor)ScreenshotAttachmentPage.this.cursors.get(point.cursorType));
                        cursorSet = true;
                        break;
                    }
                    if (!cursorSet && ScreenshotAttachmentPage.this.getScaledSelection().contains(e.x, e.y)) {
                        ScreenshotAttachmentPage.this.canvas.setCursor((Cursor)ScreenshotAttachmentPage.this.cursors.get(5));
                        cursorSet = true;
                    }
                    Cursor crossCursor = (Cursor)ScreenshotAttachmentPage.this.cursors.get(2);
                    if (!cursorSet && ScreenshotAttachmentPage.this.canvas.getCursor() != crossCursor) {
                        ScreenshotAttachmentPage.this.canvas.setCursor(crossCursor);
                    }
                } else if (ScreenshotAttachmentPage.this.currentAction == EditorAction.MARKING) {
                    ScreenshotAttachmentPage.this.drawMarkLine(scaledX, scaledY);
                    Cursor markCursor = (Cursor)ScreenshotAttachmentPage.this.cursors.get(-1);
                    if (ScreenshotAttachmentPage.this.canvas.getCursor() != markCursor) {
                        ScreenshotAttachmentPage.this.canvas.setCursor(markCursor);
                    }
                }
            }
        });
        this.canvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (ScreenshotAttachmentPage.this.currentAction == EditorAction.SELECTING || ScreenshotAttachmentPage.this.currentAction == EditorAction.RESIZING_SELECTION || ScreenshotAttachmentPage.this.currentAction == EditorAction.MOVING_SELECTION) {
                    int scaledX = (int)Math.round((double)e.x / ScreenshotAttachmentPage.this.scaleFactor);
                    int scaledY = (int)Math.round((double)e.y / ScreenshotAttachmentPage.this.scaleFactor);
                    if (ScreenshotAttachmentPage.this.currentAction == EditorAction.SELECTING) {
                        ScreenshotAttachmentPage.this.refreshCurrentSelection(scaledX, scaledY);
                    } else if (ScreenshotAttachmentPage.this.currentAction == EditorAction.RESIZING_SELECTION) {
                        ScreenshotAttachmentPage.this.refreshSelectionResize(scaledX, scaledY);
                    } else if (ScreenshotAttachmentPage.this.currentAction == EditorAction.MOVING_SELECTION) {
                        ScreenshotAttachmentPage.this.refreshSelectionPosition(scaledX, scaledY);
                    }
                    if (((ScreenshotAttachmentPage)ScreenshotAttachmentPage.this).currentSelection.width == 0 && ((ScreenshotAttachmentPage)ScreenshotAttachmentPage.this).currentSelection.height == 0) {
                        ScreenshotAttachmentPage.this.currentSelection = null;
                    }
                    ScreenshotAttachmentPage.this.setUpGrabPoints();
                    ScreenshotAttachmentPage.this.startPoint = null;
                    ScreenshotAttachmentPage.this.currentAction = EditorAction.CROPPING;
                    ScreenshotAttachmentPage.this.canvas.redraw();
                    ScreenshotAttachmentPage.this.markAttachmentDirty();
                } else if (ScreenshotAttachmentPage.this.currentAction == EditorAction.MARKING) {
                    ScreenshotAttachmentPage.this.startPoint = null;
                    ScreenshotAttachmentPage.this.markAttachmentDirty();
                }
            }

            public void mouseDown(MouseEvent e) {
                int scaledX = (int)((double)e.x / ScreenshotAttachmentPage.this.scaleFactor);
                int scaledY = (int)((double)e.y / ScreenshotAttachmentPage.this.scaleFactor);
                if (ScreenshotAttachmentPage.this.currentAction == EditorAction.MARKING) {
                    ScreenshotAttachmentPage.this.startPoint = new Point(scaledX, scaledY);
                    ScreenshotAttachmentPage.this.drawMarkLine(scaledX, scaledY);
                    ScreenshotAttachmentPage.this.canvas.setCursor((Cursor)ScreenshotAttachmentPage.this.cursors.get(-1));
                    return;
                }
                if (ScreenshotAttachmentPage.this.currentAction != EditorAction.CROPPING) {
                    return;
                }
                if (ScreenshotAttachmentPage.this.currentSelection != null) {
                    for (GrabPoint point : ScreenshotAttachmentPage.this.grabPoints) {
                        if (!point.grabArea.contains(e.x, e.y)) continue;
                        ScreenshotAttachmentPage.this.originalSelection = ScreenshotAttachmentPage.this.currentSelection;
                        ScreenshotAttachmentPage.this.currentAction = EditorAction.RESIZING_SELECTION;
                        ScreenshotAttachmentPage.this.resizableSides = point.resizableSides;
                        ScreenshotAttachmentPage.this.startPoint = new Point(scaledX, scaledY);
                        ScreenshotAttachmentPage.this.canvas.redraw();
                        return;
                    }
                }
                if (ScreenshotAttachmentPage.this.currentSelection != null && ScreenshotAttachmentPage.this.currentSelection.contains(scaledX, scaledY)) {
                    ScreenshotAttachmentPage.this.originalSelection = ScreenshotAttachmentPage.this.currentSelection;
                    ScreenshotAttachmentPage.this.currentAction = EditorAction.MOVING_SELECTION;
                    ScreenshotAttachmentPage.this.startPoint = new Point(scaledX, scaledY);
                    ScreenshotAttachmentPage.this.canvas.redraw();
                    return;
                }
                ScreenshotAttachmentPage.this.canvas.setCursor((Cursor)ScreenshotAttachmentPage.this.cursors.get(2));
                ScreenshotAttachmentPage.this.currentAction = EditorAction.SELECTING;
                ScreenshotAttachmentPage.this.currentSelection = null;
                ScreenshotAttachmentPage.this.startPoint = new Point(scaledX, scaledY);
                ScreenshotAttachmentPage.this.setUpGrabPoints();
                ScreenshotAttachmentPage.this.canvas.redraw();
            }
        });
    }

    private void clearSelection() {
        this.currentSelection = null;
        this.startPoint = null;
        this.markAttachmentDirty();
    }

    private void refreshCanvasSize() {
        if (this.fitAction.isChecked()) {
            this.scrolledComposite.getHorizontalBar().setVisible(false);
            this.scrolledComposite.getVerticalBar().setVisible(false);
            Rectangle bounds = this.scrolledComposite.getClientArea();
            if (this.workImage != null) {
                Rectangle imageBounds = this.workImage.getBounds();
                if (imageBounds.width > bounds.width || imageBounds.height > bounds.height) {
                    double xRatio = (double)bounds.width / (double)imageBounds.width;
                    double yRatio = (double)bounds.height / (double)imageBounds.height;
                    this.scaleFactor = Math.min(xRatio, yRatio);
                    bounds.width = (int)Math.round((double)imageBounds.width * this.scaleFactor);
                    bounds.height = (int)Math.round((double)imageBounds.height * this.scaleFactor);
                }
            }
            this.canvas.setBounds(bounds);
        } else {
            this.scaleFactor = 1.0;
            Rectangle bounds = this.scrolledComposite.getClientArea();
            if (this.workImage != null) {
                Rectangle imageBounds = this.workImage.getBounds();
                bounds.width = imageBounds.width;
                bounds.height = imageBounds.height;
            }
            this.canvas.setBounds(bounds);
        }
        this.setUpGrabPoints();
        this.canvas.redraw();
    }

    private void drawSelection(GC gc) {
        if (this.currentSelection == null) {
            return;
        }
        Rectangle scaledSelection = this.getScaledSelection();
        gc.setBackground(TaskListColorsAndFonts.GRAY);
        gc.setAdvanced(true);
        gc.setAlpha(120);
        Region invertedSelection = new Region();
        invertedSelection.add(this.canvas.getClientArea());
        invertedSelection.subtract(scaledSelection);
        gc.setClipping(invertedSelection);
        gc.fillRectangle(this.canvas.getClientArea());
        gc.setClipping(null);
        invertedSelection.dispose();
        gc.setAdvanced(false);
        gc.setLineStyle(1);
        gc.setForeground(this.getShell().getDisplay().getSystemColor(16));
        gc.drawRectangle(scaledSelection);
        gc.setBackground(this.getShell().getDisplay().getSystemColor(1));
        gc.setForeground(this.getShell().getDisplay().getSystemColor(2));
        for (GrabPoint point : this.grabPoints) {
            gc.fillRectangle(point.grabArea);
            gc.drawRectangle(point.grabArea);
        }
    }

    private void drawMarkLine(int x, int y) {
        if (this.startPoint != null) {
            this.clearAction.setEnabled(true);
            this.workImageGC.drawLine(this.startPoint.x, this.startPoint.y, x, y);
            this.startPoint.x = x;
            this.startPoint.y = y;
            this.canvas.redraw();
        }
    }

    public Image createImage() {
        Image screenshot = new Image((Device)this.getShell().getDisplay(), this.currentSelection != null ? this.currentSelection : this.workImage.getBounds());
        GC gc = new GC((Drawable)screenshot);
        if (this.currentSelection != null) {
            gc.drawImage(this.workImage, this.currentSelection.x, this.currentSelection.y, this.currentSelection.width, this.currentSelection.height, 0, 0, this.currentSelection.width, this.currentSelection.height);
        } else {
            gc.drawImage(this.workImage, 0, 0);
        }
        gc.dispose();
        return screenshot;
    }

    private void markAttachmentDirty() {
        NewAttachmentWizard wizard = (NewAttachmentWizard)this.getWizard();
        ((ImageAttachment)wizard.getAttachment()).markDirty();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum EditorAction {
        CROPPING,
        SELECTING,
        RESIZING_SELECTION,
        MOVING_SELECTION,
        MARKING;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GrabPoint {
        public Rectangle grabArea;
        public int cursorType;
        public Set<SelectionSide> resizableSides;

        private GrabPoint() {
        }

        public static GrabPoint createGrabPoint(int x, int y, int cursorType, Set<SelectionSide> resizableSides) {
            GrabPoint point = new GrabPoint();
            point.grabArea = new Rectangle(x - 3, y - 3, 7, 7);
            point.cursorType = cursorType;
            point.resizableSides = resizableSides;
            return point;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SelectionSide {
        LEFT,
        RIGHT,
        TOP,
        BOTTOM;

    }
}

