/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.workingsets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.internal.tasks.core.TaskArchive;
import org.eclipse.mylyn.internal.tasks.core.UnmatchedTaskContainer;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskElementLabelProvider;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskRepositoryLabelProvider;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetPage;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskWorkingSetPage
extends WizardPage
implements IWorkingSetPage {
    private static final String LABEL_TASKS = "Tasks";
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 50;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 200;
    private Text text;
    private CheckboxTreeViewer treeViewer;
    private IWorkingSet workingSet;
    private WorkingSetPageContentProvider workingSetPageContentProvider = new WorkingSetPageContentProvider();
    private boolean firstCheck = false;

    public TaskWorkingSetPage() {
        super("taskWorkingSetPage", "Select Working Set Elements", null);
        this.setDescription("When this Working Set is selected views will be filtered just to show only\nthese elements if the Window Working Set is enabled in the view (default).");
        this.setImageDescriptor(TasksUiImages.BANNER_WORKING_SET);
    }

    public void finish() {
        Object[] elements = this.treeViewer.getCheckedElements();
        HashSet<IAdaptable> validElements = new HashSet<IAdaptable>();
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof AbstractTaskContainer || elements[i] instanceof IProject) {
                validElements.add((IAdaptable)elements[i]);
            }
            ++i;
        }
        this.addUnmatchedCategories(validElements);
        if (this.workingSet == null) {
            IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
            this.workingSet = workingSetManager.createWorkingSet(this.getWorkingSetName(), validElements.toArray(new IAdaptable[validElements.size()]));
        } else {
            this.workingSet.setName(this.getWorkingSetName());
            this.workingSet.setElements(validElements.toArray(new IAdaptable[validElements.size()]));
        }
    }

    private void addUnmatchedCategories(Set<IAdaptable> validElements) {
        HashSet<UnmatchedTaskContainer> orphanContainers = new HashSet<UnmatchedTaskContainer>();
        for (IAdaptable element : validElements) {
            UnmatchedTaskContainer orphansContainer;
            AbstractRepositoryQuery query;
            if (!(element instanceof AbstractRepositoryQuery) || (query = (AbstractRepositoryQuery)element).getRepositoryUrl() == null || (orphansContainer = TasksUiPlugin.getTaskListManager().getTaskList().getOrphanContainer(query.getRepositoryUrl())) == null) continue;
            orphanContainers.add(orphansContainer);
        }
        validElements.addAll(orphanContainers);
    }

    public IWorkingSet getSelection() {
        return this.workingSet;
    }

    public void setSelection(IWorkingSet workingSet) {
        this.workingSet = workingSet;
        if (this.getShell() != null && this.text != null) {
            this.firstCheck = true;
            this.initializeCheckedState();
            this.text.setText(workingSet.getName());
        }
    }

    private String getWorkingSetName() {
        return this.text.getText();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(256));
        this.setControl((Control)composite);
        Label label = new Label(composite, 64);
        label.setText(IDEWorkbenchMessages.ResourceWorkingSetPage_message);
        label.setLayoutData((Object)new GridData(772));
        this.text = new Text(composite, 2052);
        this.text.setLayoutData((Object)new GridData(768));
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TaskWorkingSetPage.this.validateInput();
            }
        });
        this.text.setFocus();
        label = new Label(composite, 64);
        label.setText(IDEWorkbenchMessages.ResourceWorkingSetPage_label_tree);
        label.setLayoutData((Object)new GridData(772));
        this.treeViewer = new CheckboxTreeViewer(composite);
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.setContentProvider((IContentProvider)this.workingSetPageContentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new AggregateLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()));
        this.treeViewer.setSorter((ViewerSorter)new CustomSorter());
        ArrayList<TaskRepository> containers = new ArrayList<TaskRepository>();
        for (TaskRepository repository : TasksUiPlugin.getRepositoryManager().getAllRepositories()) {
            containers.add(repository);
        }
        containers.addAll((Collection)Arrays.asList(ResourcesPlugin.getWorkspace().getRoot().getProjects()));
        this.treeViewer.setInput(containers);
        this.treeViewer.expandAll();
        GridData data = new GridData(1808);
        data.heightHint = 200;
        data.widthHint = 50;
        this.treeViewer.getControl().setLayoutData((Object)data);
        this.treeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                TaskWorkingSetPage.this.handleCheckStateChange(event);
            }
        });
        Composite buttonComposite = new Composite(composite, 0);
        layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)new GridData(256));
        Button selectAllButton = new Button(buttonComposite, 8);
        selectAllButton.setText(IDEWorkbenchMessages.ResourceWorkingSetPage_selectAll_label);
        selectAllButton.setToolTipText(IDEWorkbenchMessages.ResourceWorkingSetPage_selectAll_toolTip);
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TaskWorkingSetPage.this.treeViewer.setCheckedElements(TaskWorkingSetPage.this.workingSetPageContentProvider.getElements(TaskWorkingSetPage.this.treeViewer.getInput()));
                TaskWorkingSetPage.this.validateInput();
            }
        });
        this.setButtonLayoutData(selectAllButton);
        Button deselectAllButton = new Button(buttonComposite, 8);
        deselectAllButton.setText(IDEWorkbenchMessages.ResourceWorkingSetPage_deselectAll_label);
        deselectAllButton.setToolTipText(IDEWorkbenchMessages.ResourceWorkingSetPage_deselectAll_toolTip);
        deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TaskWorkingSetPage.this.treeViewer.setCheckedElements(new Object[0]);
                TaskWorkingSetPage.this.validateInput();
            }
        });
        this.setButtonLayoutData(deselectAllButton);
        this.initializeCheckedState();
        if (this.workingSet != null) {
            this.text.setText(this.workingSet.getName());
        }
        this.setPageComplete(false);
        Dialog.applyDialogFont((Control)composite);
    }

    private void initializeCheckedState() {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                Object[] items = null;
                if (TaskWorkingSetPage.this.workingSet != null && (items = TaskWorkingSetPage.this.workingSet.getElements()) != null) {
                    TaskWorkingSetPage.this.treeViewer.setCheckedElements(new Object[0]);
                    Object[] objectArray = items;
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object item = objectArray[n2];
                        if (item != null) {
                            TaskWorkingSetPage.this.treeViewer.setChecked(item, true);
                        }
                        ++n2;
                    }
                }
            }
        });
    }

    protected void handleCheckStateChange(final CheckStateChangedEvent event) {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                IAdaptable element = (IAdaptable)event.getElement();
                if (element instanceof AbstractTaskContainer || element instanceof IProject) {
                    TaskWorkingSetPage.this.treeViewer.setGrayed((Object)element, false);
                } else if (element instanceof ElementCategory) {
                    Object[] objectArray = ((ElementCategory)element).getChildren(null);
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object child = objectArray[n2];
                        TaskWorkingSetPage.this.treeViewer.setChecked(child, event.getChecked());
                        ++n2;
                    }
                } else if (element instanceof TaskRepository || element instanceof TaskRepositoryProjectMapping) {
                    Object[] objectArray = TaskWorkingSetPage.this.workingSetPageContentProvider.getChildren(element);
                    int n = objectArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        Object child = objectArray[n3];
                        TaskWorkingSetPage.this.treeViewer.setChecked(child, event.getChecked());
                        ++n3;
                    }
                }
                TaskWorkingSetPage.this.validateInput();
            }
        });
    }

    protected void validateInput() {
        String errorMessage = null;
        String infoMessage = null;
        String newText = this.text.getText();
        if (!newText.equals(newText.trim())) {
            errorMessage = "The name must not have a leading or trailing whitespace.";
        } else if (this.firstCheck) {
            this.firstCheck = false;
            return;
        }
        if ("".equals(newText)) {
            errorMessage = "The name must not be empty.";
        }
        if (!(errorMessage != null || this.workingSet != null && newText.equals(this.workingSet.getName()))) {
            IWorkingSet[] workingSets = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets();
            int i = 0;
            while (i < workingSets.length) {
                if (newText.equals(workingSets[i].getName())) {
                    errorMessage = "A working set with the same name already exists.";
                }
                ++i;
            }
        }
        if (this.treeViewer.getCheckedElements().length == 0) {
            infoMessage = "No categories/queries selected.";
        }
        this.setMessage(infoMessage, 1);
        this.setErrorMessage(errorMessage);
        this.setPageComplete(errorMessage == null);
    }

    class AggregateLabelProvider
    implements ILabelProvider {
        private TaskElementLabelProvider taskLabelProvider = new TaskElementLabelProvider(false);
        private TaskRepositoryLabelProvider taskRepositoryLabelProvider = new TaskRepositoryLabelProvider();
        private WorkbenchLabelProvider workbenchLabelProvider = new WorkbenchLabelProvider();

        AggregateLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof AbstractTaskContainer) {
                return this.taskLabelProvider.getImage(element);
            }
            if (element instanceof TaskRepository) {
                return this.taskRepositoryLabelProvider.getImage(element);
            }
            if (element instanceof TaskRepositoryProjectMapping) {
                return this.getImage(((TaskRepositoryProjectMapping)((Object)element)).getTaskRepository());
            }
            return this.workbenchLabelProvider.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof AbstractTaskContainer) {
                return this.taskLabelProvider.getText(element);
            }
            if (element instanceof TaskRepository) {
                return this.taskRepositoryLabelProvider.getText(element);
            }
            if (element instanceof TaskRepositoryProjectMapping) {
                return this.getText(((TaskRepositoryProjectMapping)((Object)element)).getTaskRepository());
            }
            return this.workbenchLabelProvider.getText(element);
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    class CustomSorter
    extends ViewerSorter {
        CustomSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof TaskRepository || e1 instanceof TaskRepositoryProjectMapping) {
                return -1;
            }
            if (e2 instanceof TaskRepository || e2 instanceof TaskRepositoryProjectMapping) {
                return 1;
            }
            if (e1 instanceof ElementCategory && ((ElementCategory)((Object)e1)).getLabel(e1).equals(TaskWorkingSetPage.LABEL_TASKS)) {
                return -1;
            }
            if (e2 instanceof ElementCategory && ((ElementCategory)((Object)e1)).getLabel(e1).equals(TaskWorkingSetPage.LABEL_TASKS)) {
                return 1;
            }
            return super.compare(viewer, e1, e2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ElementCategory
    extends PlatformObject
    implements IWorkbenchAdapter {
        private String label;
        private List<IAdaptable> children;

        public ElementCategory(String label, List<IAdaptable> children) {
            this.label = label;
            this.children = children;
        }

        public Object[] getChildren(Object o) {
            return this.children.toArray();
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return WorkbenchImages.getImageDescriptor((String)"IMG_OBJ_WORKING_SETS");
        }

        public String getLabel(Object o) {
            return this.label;
        }

        public Object getParent(Object o) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TaskRepositoryProjectMapping
    extends PlatformObject {
        private TaskRepository taskRepository;
        private Set<IProject> projects;

        public TaskRepositoryProjectMapping(TaskRepository taskRepository, Set<IProject> mappedProjects) {
            this.taskRepository = taskRepository;
            this.projects = mappedProjects;
        }

        public Set<IProject> getProjects() {
            return this.projects;
        }

        public TaskRepository getTaskRepository() {
            return this.taskRepository;
        }
    }

    private final class WorkingSetPageContentProvider
    implements ITreeContentProvider {
        private WorkingSetPageContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof List) {
                ArrayList<IAdaptable> taskRepositoriesContainers = new ArrayList<IAdaptable>();
                ArrayList<IAdaptable> resourcesRepositoriesContainers = new ArrayList<IAdaptable>();
                for (AbstractTaskContainer category : TasksUiPlugin.getTaskListManager().getTaskList().getCategories()) {
                    if (category instanceof TaskArchive) continue;
                    taskRepositoriesContainers.add((IAdaptable)category);
                }
                IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                HashSet<IProject> unmappedProjects = new HashSet<IProject>();
                for (Object container : (List)parentElement) {
                    if (!(container instanceof TaskRepository)) continue;
                    if (this.hasChildren(container)) {
                        taskRepositoriesContainers.add((IAdaptable)((TaskRepository)container));
                    }
                    HashSet<IProject> mappedProjects = new HashSet<IProject>();
                    IProject[] iProjectArray = projects;
                    int n = projects.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProject project = iProjectArray[n2];
                        TaskRepository taskRepository = TasksUiPlugin.getDefault().getRepositoryForResource((IResource)project, true);
                        if (container.equals(taskRepository)) {
                            mappedProjects.add(project);
                        } else if (taskRepository == null) {
                            unmappedProjects.add(project);
                        }
                        ++n2;
                    }
                    if (mappedProjects.isEmpty()) continue;
                    resourcesRepositoriesContainers.add((IAdaptable)new TaskRepositoryProjectMapping((TaskRepository)container, mappedProjects));
                }
                resourcesRepositoriesContainers.addAll(unmappedProjects);
                return new Object[]{new ElementCategory(TaskWorkingSetPage.LABEL_TASKS, taskRepositoriesContainers), new ElementCategory("Resources", resourcesRepositoriesContainers)};
            }
            if (parentElement instanceof TaskRepository) {
                ArrayList<AbstractTaskContainer> taskContainers = new ArrayList<AbstractTaskContainer>();
                for (AbstractTaskContainer element : TasksUiPlugin.getTaskListManager().getTaskList().getRepositoryQueries(((TaskRepository)parentElement).getUrl())) {
                    if (!(element instanceof AbstractRepositoryQuery)) continue;
                    taskContainers.add(element);
                }
                return taskContainers.toArray();
            }
            if (parentElement instanceof TaskRepositoryProjectMapping) {
                return ((TaskRepositoryProjectMapping)((Object)parentElement)).getProjects().toArray();
            }
            if (parentElement instanceof ElementCategory) {
                return ((ElementCategory)((Object)parentElement)).getChildren(parentElement);
            }
            return new Object[0];
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object element) {
            return this.getChildren(element);
        }

        public Object getParent(Object element) {
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

