/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.internal.net.ProxyManager;
import org.eclipse.core.net.proxy.IProxyChangeListener;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.mylyn.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.monitor.core.util.IStatusHandler;
import org.eclipse.mylyn.internal.tasks.core.ITaskDataStorage;
import org.eclipse.mylyn.internal.tasks.core.ScheduledTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityManager;
import org.eclipse.mylyn.internal.tasks.core.TaskDataManager;
import org.eclipse.mylyn.internal.tasks.ui.IDynamicSubMenuContributor;
import org.eclipse.mylyn.internal.tasks.ui.ITaskHighlighter;
import org.eclipse.mylyn.internal.tasks.ui.ITaskListNotificationProvider;
import org.eclipse.mylyn.internal.tasks.ui.OfflineCachingStorage;
import org.eclipse.mylyn.internal.tasks.ui.OfflineFileStorage;
import org.eclipse.mylyn.internal.tasks.ui.RepositoryAwareStatusHandler;
import org.eclipse.mylyn.internal.tasks.ui.TaskEditorBloatMonitor;
import org.eclipse.mylyn.internal.tasks.ui.TaskListBackupManager;
import org.eclipse.mylyn.internal.tasks.ui.TaskListColorsAndFonts;
import org.eclipse.mylyn.internal.tasks.ui.TaskListNotificationManager;
import org.eclipse.mylyn.internal.tasks.ui.TaskListSynchronizationScheduler;
import org.eclipse.mylyn.internal.tasks.ui.TaskRepositoryUtil;
import org.eclipse.mylyn.internal.tasks.ui.notifications.AbstractNotification;
import org.eclipse.mylyn.internal.tasks.ui.notifications.TaskListNotification;
import org.eclipse.mylyn.internal.tasks.ui.notifications.TaskListNotificationQueryIncoming;
import org.eclipse.mylyn.internal.tasks.ui.notifications.TaskListNotificationReminder;
import org.eclipse.mylyn.internal.tasks.ui.util.TaskListSaveManager;
import org.eclipse.mylyn.internal.tasks.ui.util.TaskListWriter;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiExtensionReader;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskRepositoriesView;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractAttributeFactory;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.tasks.core.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.ITaskActivityListener;
import org.eclipse.mylyn.tasks.core.ITaskListChangeListener;
import org.eclipse.mylyn.tasks.core.RepositoryTaskAttribute;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;
import org.eclipse.mylyn.tasks.core.RepositoryTemplate;
import org.eclipse.mylyn.tasks.core.TaskComment;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.TaskRepositoryManager;
import org.eclipse.mylyn.tasks.ui.AbstractDuplicateDetector;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.AbstractTaskRepositoryLinkProvider;
import org.eclipse.mylyn.tasks.ui.RepositorySynchronizationManager;
import org.eclipse.mylyn.tasks.ui.TaskListManager;
import org.eclipse.mylyn.tasks.ui.TasksUiProxyChangeListener;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorFactory;
import org.eclipse.mylyn.web.core.WebClientUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.UIJob;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TasksUiPlugin
extends AbstractUIPlugin {
    private static final int MAX_CHANGED_ATTRIBUTES = 2;
    private static final int LINK_PROVIDER_TIMEOUT_SECONDS = 5;
    public static final String LABEL_VIEW_REPOSITORIES = "Task Repositories";
    public static final String ID_PLUGIN = "org.eclipse.mylyn.tasks.ui";
    private static final String FOLDER_OFFLINE = "offline";
    private static final String DIRECTORY_METADATA = ".metadata";
    private static final String NAME_DATA_DIR = ".mylyn";
    private static final char DEFAULT_PATH_SEPARATOR = '/';
    private static final int NOTIFICATION_DELAY = 5000;
    private static TasksUiPlugin INSTANCE;
    private static TaskListManager taskListManager;
    private static TaskActivityManager taskActivityManager;
    private static TaskRepositoryManager taskRepositoryManager;
    private static TaskListSynchronizationScheduler synchronizationScheduler;
    private static RepositorySynchronizationManager synchronizationManager;
    private static Map<String, AbstractRepositoryConnectorUi> repositoryConnectorUiMap;
    private TaskListSaveManager taskListSaveManager;
    private TaskListNotificationManager taskListNotificationManager;
    private TaskListBackupManager taskListBackupManager;
    private TaskDataManager taskDataManager;
    private Set<AbstractTaskEditorFactory> taskEditorFactories = new HashSet<AbstractTaskEditorFactory>();
    private Set<IHyperlinkDetector> hyperlinkDetectors = new HashSet<IHyperlinkDetector>();
    private TreeSet<AbstractTaskRepositoryLinkProvider> repositoryLinkProviders = new TreeSet<AbstractTaskRepositoryLinkProvider>(new OrderComparator());
    private TaskListWriter taskListWriter;
    private ITaskHighlighter highlighter;
    private boolean initialized = false;
    private Map<String, Image> brandingIcons = new HashMap<String, Image>();
    private Map<String, ImageDescriptor> overlayIcons = new HashMap<String, ImageDescriptor>();
    private Set<AbstractDuplicateDetector> duplicateDetectors = new HashSet<AbstractDuplicateDetector>();
    private ISaveParticipant saveParticipant;
    private TaskEditorBloatMonitor taskEditorBloatManager;
    private static final boolean DEBUG_HTTPCLIENT;
    private static ITaskActivityListener CONTEXT_TASK_ACTIVITY_LISTENER;
    private static ITaskListNotificationProvider REMINDER_NOTIFICATION_PROVIDER;
    private static ITaskListNotificationProvider INCOMING_NOTIFICATION_PROVIDER;
    private final Preferences.IPropertyChangeListener PREFERENCE_LISTENER = new Preferences.IPropertyChangeListener(){

        public void propertyChange(Preferences.PropertyChangeEvent event) {
            if (event.getProperty().equals("org.eclipse.mylyn.data.dir") && event.getOldValue() instanceof String) {
                TasksUiPlugin.this.reloadDataDirectory(true);
            }
        }
    };
    private final IPropertyChangeListener PROPERTY_LISTENER = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("org.eclipse.mylyn.data.dir") && event.getOldValue() instanceof String) {
                TasksUiPlugin.this.reloadDataDirectory(true);
            }
        }
    };
    private boolean attemptMigration = true;
    private Map<String, List<IDynamicSubMenuContributor>> menuContributors = new HashMap<String, List<IDynamicSubMenuContributor>>();

    static {
        repositoryConnectorUiMap = new HashMap<String, AbstractRepositoryConnectorUi>();
        DEBUG_HTTPCLIENT = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.mylyn.tasks.ui/debug/httpclient"));
        CONTEXT_TASK_ACTIVITY_LISTENER = new ITaskActivityListener(){

            public void taskActivated(AbstractTask task) {
                ContextCorePlugin.getContextManager().activateContext(task.getHandleIdentifier());
            }

            public void taskDeactivated(AbstractTask task) {
                ContextCorePlugin.getContextManager().deactivateContext(task.getHandleIdentifier());
            }

            public void activityChanged(ScheduledTaskContainer week) {
            }

            public void taskListRead() {
            }
        };
        REMINDER_NOTIFICATION_PROVIDER = new ITaskListNotificationProvider(){

            @Override
            public Set<AbstractNotification> getNotifications() {
                Collection allTasks = TasksUiPlugin.getTaskListManager().getTaskList().getAllTasks();
                HashSet<AbstractNotification> reminders = new HashSet<AbstractNotification>();
                for (AbstractTask task : allTasks) {
                    if (!task.isPastReminder() || task.isReminded()) continue;
                    reminders.add(new TaskListNotificationReminder(task));
                    task.setReminded(true);
                }
                return reminders;
            }
        };
        INCOMING_NOTIFICATION_PROVIDER = new ITaskListNotificationProvider(){

            @Override
            public Set<AbstractNotification> getNotifications() {
                HashSet<AbstractNotification> notifications = new HashSet<AbstractNotification>();
                for (TaskRepository repository : TasksUiPlugin.getRepositoryManager().getAllRepositories()) {
                    AbstractRepositoryConnector connector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector(repository.getConnectorKind());
                    AbstractRepositoryConnectorUi connectorUi = TasksUiPlugin.getConnectorUi(repository.getConnectorKind());
                    if (connectorUi == null || connectorUi.isCustomNotificationHandling()) continue;
                    for (AbstractTask repositoryTask : TasksUiPlugin.getTaskListManager().getTaskList().getRepositoryTasks(repository.getUrl())) {
                        if (repositoryTask.getLastReadTimeStamp() != null && repositoryTask.getSynchronizationState() != AbstractTask.RepositoryTaskSyncState.INCOMING || repositoryTask.isNotified()) continue;
                        TaskListNotification notification = INSTANCE.getIncommingNotification(connector, repositoryTask);
                        notifications.add(notification);
                        repositoryTask.setNotified(true);
                    }
                }
                for (AbstractRepositoryQuery query : TasksUiPlugin.getTaskListManager().getTaskList().getQueries()) {
                    AbstractRepositoryConnectorUi connectorUi = TasksUiPlugin.getConnectorUi(query.getRepositoryKind());
                    if (connectorUi.isCustomNotificationHandling()) continue;
                    for (AbstractTask hit : query.getChildren()) {
                        if (hit.isNotified()) continue;
                        notifications.add(new TaskListNotificationQueryIncoming(hit));
                        hit.setNotified(true);
                    }
                }
                return notifications;
            }
        };
    }

    public TasksUiPlugin() {
        INSTANCE = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        try {
            StatusHandler.setDefaultStatusHandler((IStatusHandler)new RepositoryAwareStatusHandler());
            WebClientUtil.setLoggingEnabled((boolean)DEBUG_HTTPCLIENT);
            this.initializeDefaultPreferences(this.getPreferenceStore());
            this.taskListWriter = new TaskListWriter();
            File dataDir = new File(this.getDataDirectory());
            dataDir.mkdirs();
            String path = String.valueOf(this.getDataDirectory()) + File.separator + "tasklist.xml.zip";
            File taskListFile = new File(path);
            taskListManager = new TaskListManager(this.taskListWriter, taskListFile);
            taskActivityManager = TaskActivityManager.getInstance();
            taskRepositoryManager = new TaskRepositoryManager(taskListManager.getTaskList());
            IProxyService proxyService = ProxyManager.getProxyManager();
            TasksUiProxyChangeListener proxyChangeListener = new TasksUiProxyChangeListener(taskRepositoryManager);
            proxyService.addProxyChangeListener((IProxyChangeListener)proxyChangeListener);
            synchronizationManager = new RepositorySynchronizationManager();
            TasksUiExtensionReader.initStartupExtensions(this.taskListWriter);
            taskRepositoryManager.readRepositories(this.getRepositoriesFilePath());
            this.startOfflineStorageManager();
            this.loadTemplateRepositories();
            taskListManager.init();
            taskListManager.addActivityListener(CONTEXT_TASK_ACTIVITY_LISTENER);
            taskListManager.readExistingOrCreateNewList();
            this.initialized = true;
            if (!taskActivityManager.isInitialized()) {
                taskActivityManager.init(taskRepositoryManager, taskListManager.getTaskList());
                taskActivityManager.setEndHour(this.getPreferenceStore().getInt("org.eclipse.mylyn.tasks.ui.planning.end.hour"));
            }
            this.saveParticipant = new ISaveParticipant(){

                public void doneSaving(ISaveContext context) {
                }

                public void prepareToSave(ISaveContext context) throws CoreException {
                }

                public void rollback(ISaveContext context) {
                }

                public void saving(ISaveContext context) throws CoreException {
                    if (context.getKind() == 1) {
                        taskListManager.saveTaskList();
                        TasksUiPlugin.this.taskDataManager.stop();
                    }
                }
            };
            ResourcesPlugin.getWorkspace().addSaveParticipant((Plugin)this, this.saveParticipant);
            new TasksUiInitializationJob().schedule();
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, ID_PLUGIN, "Task list initialization failed", (Throwable)e));
        }
    }

    private void loadTemplateRepositories() {
        if (taskRepositoryManager.getRepository("local") == null) {
            TaskRepository localRepository = new TaskRepository("local", "local", "1");
            localRepository.setRepositoryLabel("Local Tasks");
            localRepository.setAnonymous(true);
            taskRepositoryManager.addRepository(localRepository, this.getRepositoriesFilePath());
        }
        for (AbstractRepositoryConnector connector : taskRepositoryManager.getRepositoryConnectors()) {
            connector.setTaskDataManager(this.taskDataManager);
            for (RepositoryTemplate template : connector.getTemplates()) {
                if (!template.addAutomatically || TaskRepositoryUtil.isAddAutomaticallyDisabled(template.repositoryUrl)) continue;
                try {
                    TaskRepository taskRepository = taskRepositoryManager.getRepository(connector.getConnectorKind(), template.repositoryUrl);
                    if (taskRepository != null) continue;
                    taskRepository = new TaskRepository(connector.getConnectorKind(), template.repositoryUrl, template.version);
                    taskRepository.setRepositoryLabel(template.label);
                    taskRepository.setAnonymous(true);
                    taskRepository.setCharacterEncoding(template.characterEncoding);
                    taskRepository.setAnonymous(template.anonymous);
                    taskRepositoryManager.addRepository(taskRepository, this.getRepositoriesFilePath());
                }
                catch (Throwable t) {
                    StatusHandler.log((IStatus)new Status(4, ID_PLUGIN, "Could not load repository template", t));
                }
            }
        }
    }

    public void stop(BundleContext context) throws Exception {
        try {
            try {
                if (ResourcesPlugin.getWorkspace() != null) {
                    ResourcesPlugin.getWorkspace().removeSaveParticipant((Plugin)this);
                }
                if (PlatformUI.isWorkbenchRunning()) {
                    this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this.taskListNotificationManager);
                    this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this.taskListBackupManager);
                    this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)taskListManager);
                    this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)synchronizationScheduler);
                    this.getPreferenceStore().removePropertyChangeListener(this.PROPERTY_LISTENER);
                    taskListManager.getTaskList().removeChangeListener((ITaskListChangeListener)this.taskListSaveManager);
                    taskListManager.dispose();
                    TaskListColorsAndFonts.dispose();
                    if (ContextCorePlugin.getDefault() != null) {
                        ContextCorePlugin.getDefault().getPluginPreferences().removePropertyChangeListener(this.PREFERENCE_LISTENER);
                    }
                    this.taskEditorBloatManager.dispose(PlatformUI.getWorkbench());
                    INSTANCE = null;
                }
            }
            catch (Exception e) {
                StatusHandler.log((IStatus)new Status(4, ID_PLUGIN, "Task list stop terminated abnormally", (Throwable)e));
                super.stop(context);
            }
        }
        finally {
            super.stop(context);
        }
    }

    public String getDefaultDataDirectory() {
        return String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString()) + '/' + DIRECTORY_METADATA + '/' + NAME_DATA_DIR;
    }

    public synchronized String getDataDirectory() {
        if (this.attemptMigration) {
            this.migrateFromLegacyDirectory();
            this.attemptMigration = false;
        }
        return this.getPreferenceStore().getString("org.eclipse.mylyn.data.dir");
    }

    @Deprecated
    private void migrateFromLegacyDirectory() {
        String oldDefaultDataPath = String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString()) + '/' + ".mylar";
        File oldDefaultDataDir = new File(oldDefaultDataPath);
        if (oldDefaultDataDir.exists()) {
            File metadata = new File(String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString()) + '/' + DIRECTORY_METADATA);
            if (!metadata.exists() && !metadata.mkdirs()) {
                StatusHandler.log((String)("Unable to create metadata folder: " + metadata.getAbsolutePath()), (Object)((Object)this));
            }
            File newDefaultDataDir = new File(this.getPreferenceStore().getString("org.eclipse.mylyn.data.dir"));
            if (metadata.exists()) {
                if (!oldDefaultDataDir.renameTo(newDefaultDataDir)) {
                    StatusHandler.log((String)("Could not migrate legacy data from " + oldDefaultDataDir.getAbsolutePath() + " to " + TasksUiPlugin.getDefault().getDefaultDataDirectory()), (Object)((Object)this));
                } else {
                    StatusHandler.log((String)("Migrated legacy task data from " + oldDefaultDataDir.getAbsolutePath() + " to " + TasksUiPlugin.getDefault().getDefaultDataDirectory()), (Object)((Object)this));
                }
            }
        }
    }

    public void setDataDirectory(String newPath) {
        TasksUiPlugin.getTaskListManager().saveTaskList();
        ContextCorePlugin.getContextManager().saveActivityContext();
        this.getPreferenceStore().setValue("org.eclipse.mylyn.data.dir", newPath);
        ContextCorePlugin.getDefault().getContextStore().contextStoreMoved();
    }

    public void reloadDataDirectory(boolean withProgress) {
        TasksUiPlugin.getTaskListManager().getTaskActivationHistory().clear();
        TasksUiPlugin.getRepositoryManager().readRepositories(this.getRepositoriesFilePath());
        this.loadTemplateRepositories();
        TasksUiPlugin.getTaskListManager().resetTaskList();
        TasksUiPlugin.getTaskListManager().setTaskListFile(new File(String.valueOf(this.getDataDirectory()) + File.separator + "tasklist.xml.zip"));
        ContextCorePlugin.getContextManager().loadActivityMetaContext();
        TasksUiPlugin.getTaskListManager().readExistingOrCreateNewList();
        TasksUiPlugin.getTaskListManager().initActivityHistory();
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        store.setDefault("org.eclipse.mylyn.data.dir", this.getDefaultDataDirectory());
        store.setDefault("org.eclipse.mylyn.tasks.ui.group.subtasks", true);
        store.setDefault("org.eclipse.mylyn.tasks.ui.notifications.enabled", true);
        store.setDefault("org.eclipse.mylyn.tasks.ui.filters.priority", AbstractTask.PriorityLevel.P5.toString());
        store.setDefault("org.eclipse.mylyn.tasks.ui.reporting.open.editor", true);
        store.setDefault("org.eclipse.mylyn.tasks.ui.activate.when.opened", false);
        store.setDefault("org.eclipse.mylyn.tasks.ui.show.trim", false);
        store.setDefault("org.eclipse.mylyn.tasks.ui.subtasks.local", false);
        store.setDefault("org.eclipse.mylyn.tasks.ui.repositories.synch.schedule", true);
        store.setDefault("org.eclipse.mylyn.tasks.ui.repositories.synch.schedule.miliseconds", "1200000");
        store.setDefault("org.eclipse.mylyn.tasks.ui.backup.schedule", 1);
        store.setDefault("org.eclipse.mylyn.tasks.ui.backup.maxfiles", 20);
        store.setDefault("org.eclipse.mylyn.tasks.ui.backup.last", 0.0f);
        store.setDefault("org.eclipse.mylyn.tasks.ui.filters.archive", true);
        store.setDefault("org.eclipse.mylyn.tasks.ui.activation.multipe", false);
        store.setValue("org.eclipse.mylyn.tasks.ui.activation.multipe", false);
        store.setDefault("org.eclipse.mylyn.tasks.ui.planning.start.hour", 9);
        store.setDefault("org.eclipse.mylyn.tasks.ui.planning.end.hour", 18);
    }

    public static TaskListManager getTaskListManager() {
        return taskListManager;
    }

    public static TaskActivityManager getTaskActivityManager() {
        return taskActivityManager;
    }

    public static TaskListNotificationManager getTaskListNotificationManager() {
        return TasksUiPlugin.INSTANCE.taskListNotificationManager;
    }

    public static TasksUiPlugin getDefault() {
        return INSTANCE;
    }

    public boolean groupSubtasks(AbstractTaskContainer container) {
        AbstractRepositoryConnectorUi connectorUi;
        boolean groupSubtasks = TasksUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.group.subtasks");
        if (container instanceof AbstractTask && (connectorUi = TasksUiPlugin.getConnectorUi(((AbstractTask)container).getConnectorKind())) != null && connectorUi.forceSubtaskHierarchy()) {
            groupSubtasks = true;
        }
        if (container instanceof AbstractRepositoryQuery && (connectorUi = TasksUiPlugin.getConnectorUi(((AbstractRepositoryQuery)container).getRepositoryKind())) != null && connectorUi.forceSubtaskHierarchy()) {
            groupSubtasks = true;
        }
        return groupSubtasks;
    }

    public Map<String, List<IDynamicSubMenuContributor>> getDynamicMenuMap() {
        return this.menuContributors;
    }

    public void addDynamicPopupContributor(String menuPath, IDynamicSubMenuContributor contributor) {
        List<IDynamicSubMenuContributor> contributors = this.menuContributors.get(menuPath);
        if (contributors == null) {
            contributors = new ArrayList<IDynamicSubMenuContributor>();
            this.menuContributors.put(menuPath, contributors);
        }
        contributors.add(contributor);
    }

    public String[] getSaveOptions() {
        String[] options = new String[]{TaskListSaveMode.ONE_HOUR.toString(), TaskListSaveMode.THREE_HOURS.toString(), TaskListSaveMode.DAY.toString()};
        return options;
    }

    public String getBackupFolderPath() {
        return String.valueOf(this.getDataDirectory()) + '/' + "backup";
    }

    public ITaskHighlighter getHighlighter() {
        return this.highlighter;
    }

    public void setHighlighter(ITaskHighlighter highlighter) {
        this.highlighter = highlighter;
    }

    public Set<AbstractTaskEditorFactory> getTaskEditorFactories() {
        return this.taskEditorFactories;
    }

    public void addContextEditor(AbstractTaskEditorFactory contextEditor) {
        if (contextEditor != null) {
            this.taskEditorFactories.add(contextEditor);
        }
    }

    public static TaskRepositoryManager getRepositoryManager() {
        return taskRepositoryManager;
    }

    public void addBrandingIcon(String repositoryType, Image icon) {
        this.brandingIcons.put(repositoryType, icon);
    }

    public Image getBrandingIcon(String repositoryType) {
        return this.brandingIcons.get(repositoryType);
    }

    public void addOverlayIcon(String repositoryType, ImageDescriptor icon) {
        this.overlayIcons.put(repositoryType, icon);
    }

    public ImageDescriptor getOverlayIcon(String repositoryType) {
        return this.overlayIcons.get(repositoryType);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public IHyperlinkDetector[] getTaskHyperlinkDetectors() {
        return this.hyperlinkDetectors.toArray(new IHyperlinkDetector[1]);
    }

    public void addTaskHyperlinkDetector(IHyperlinkDetector listener) {
        if (listener != null) {
            this.hyperlinkDetectors.add(listener);
        }
    }

    public void addRepositoryLinkProvider(AbstractTaskRepositoryLinkProvider repositoryLinkProvider) {
        if (repositoryLinkProvider != null) {
            this.repositoryLinkProviders.add(repositoryLinkProvider);
        }
    }

    public TaskListBackupManager getBackupManager() {
        return this.taskListBackupManager;
    }

    private void startOfflineStorageManager() {
        File root = new File(String.valueOf(this.getDataDirectory()) + '/' + FOLDER_OFFLINE);
        OfflineFileStorage storage = new OfflineFileStorage(root);
        OfflineCachingStorage cachedStorage = new OfflineCachingStorage(storage);
        this.taskDataManager = new TaskDataManager(taskRepositoryManager, (ITaskDataStorage)cachedStorage);
        this.taskDataManager.start();
    }

    public static TaskDataManager getTaskDataManager() {
        if (INSTANCE == null || TasksUiPlugin.INSTANCE.taskDataManager == null) {
            StatusHandler.fail((IStatus)new Status(4, ID_PLUGIN, "Offline reports file not created, try restarting."));
            return null;
        }
        return TasksUiPlugin.INSTANCE.taskDataManager;
    }

    public void addRepositoryConnectorUi(AbstractRepositoryConnectorUi repositoryConnectorUi) {
        if (!repositoryConnectorUiMap.values().contains(repositoryConnectorUi)) {
            repositoryConnectorUiMap.put(repositoryConnectorUi.getConnectorKind(), repositoryConnectorUi);
        }
    }

    public static AbstractRepositoryConnectorUi getConnectorUi(String kind) {
        return repositoryConnectorUiMap.get(kind);
    }

    public static TaskListSynchronizationScheduler getSynchronizationScheduler() {
        return synchronizationScheduler;
    }

    public static RepositorySynchronizationManager getSynchronizationManager() {
        return synchronizationManager;
    }

    public void addDuplicateDetector(AbstractDuplicateDetector duplicateDetector) {
        if (duplicateDetector != null) {
            this.duplicateDetectors.add(duplicateDetector);
        }
    }

    public Set<AbstractDuplicateDetector> getDuplicateSearchCollectorsList() {
        return this.duplicateDetectors;
    }

    public String getRepositoriesFilePath() {
        return String.valueOf(this.getDataDirectory()) + File.separator + "repositories.xml.zip";
    }

    public boolean canSetRepositoryForResource(IResource resource) {
        if (resource == null) {
            return false;
        }
        for (AbstractTaskRepositoryLinkProvider linkProvider : this.repositoryLinkProviders) {
            TaskRepository repository = linkProvider.getTaskRepository(resource, TasksUiPlugin.getRepositoryManager());
            if (repository == null) continue;
            return linkProvider.canSetTaskRepository(resource);
        }
        for (AbstractTaskRepositoryLinkProvider linkProvider : this.repositoryLinkProviders) {
            if (!linkProvider.canSetTaskRepository(resource)) continue;
            return true;
        }
        return false;
    }

    public void setRepositoryForResource(IResource resource, TaskRepository repository) throws CoreException {
        if (resource == null || repository == null) {
            return;
        }
        for (AbstractTaskRepositoryLinkProvider linkProvider : this.repositoryLinkProviders) {
            TaskRepository r = linkProvider.getTaskRepository(resource, TasksUiPlugin.getRepositoryManager());
            boolean canSetRepository = linkProvider.canSetTaskRepository(resource);
            if (r != null && !canSetRepository) {
                return;
            }
            if (!canSetRepository) continue;
            linkProvider.setTaskRepository(resource, repository);
            return;
        }
    }

    public TaskRepository getRepositoryForResource(IResource resource, boolean silent) {
        if (resource == null) {
            return null;
        }
        HashSet<AbstractTaskRepositoryLinkProvider> defectiveLinkProviders = new HashSet<AbstractTaskRepositoryLinkProvider>();
        for (AbstractTaskRepositoryLinkProvider linkProvider : this.repositoryLinkProviders) {
            long startTime = System.nanoTime();
            TaskRepository repository = linkProvider.getTaskRepository(resource, TasksUiPlugin.getRepositoryManager());
            long elapsed = System.nanoTime() - startTime;
            if (elapsed > 705032704L) {
                defectiveLinkProviders.add(linkProvider);
            }
            if (repository == null) continue;
            return repository;
        }
        if (!defectiveLinkProviders.isEmpty()) {
            this.repositoryLinkProviders.removeAll(defectiveLinkProviders);
            StatusHandler.log((IStatus)new Status(2, ID_PLUGIN, "Repository link provider took over 5s to execute and was timed out: " + defectiveLinkProviders));
        }
        if (!silent) {
            MessageDialog.openInformation(null, (String)"No Repository Found", (String)"No repository was found. Associate a Task Repository with this project via the project's property page.");
        }
        return null;
    }

    public static TaskListSaveManager getTaskListSaveManager() {
        return TasksUiPlugin.INSTANCE.taskListSaveManager;
    }

    public String getNextNewRepositoryTaskId() {
        return TasksUiPlugin.getTaskDataManager().getNewRepositoryTaskId();
    }

    public TaskListNotification getIncommingNotification(AbstractRepositoryConnector connector, AbstractTask task) {
        TaskListNotification notification = new TaskListNotification(task);
        RepositoryTaskData newTaskData = TasksUiPlugin.getTaskDataManager().getNewTaskData(task.getRepositoryUrl(), task.getTaskId());
        RepositoryTaskData oldTaskData = TasksUiPlugin.getTaskDataManager().getOldTaskData(task.getRepositoryUrl(), task.getTaskId());
        try {
            if (task.getSynchronizationState().equals((Object)AbstractTask.RepositoryTaskSyncState.INCOMING) && task.getLastReadTimeStamp() == null) {
                notification.setDescription("New unread task ");
            } else if (newTaskData != null && oldTaskData != null) {
                AbstractTaskDataHandler offlineHandler;
                StringBuilder description = new StringBuilder();
                String changedDescription = TasksUiPlugin.getChangedDescription(newTaskData, oldTaskData);
                String changedAttributes = TasksUiPlugin.getChangedAttributes(newTaskData, oldTaskData);
                if (!"".equals(changedDescription.trim())) {
                    description.append(changedDescription);
                    if (!"".equals(changedAttributes)) {
                        description.append('\n');
                    }
                }
                if (!"".equals(changedAttributes)) {
                    description.append(changedAttributes);
                }
                notification.setDescription(description.toString());
                if (connector != null && (offlineHandler = connector.getTaskDataHandler()) != null && newTaskData.getLastModified() != null) {
                    Date modified = newTaskData.getAttributeFactory().getDateForAttributeType("task.common.date.modified", newTaskData.getLastModified());
                    notification.setDate(modified);
                }
            } else {
                notification.setDescription("Unread task");
            }
        }
        catch (Throwable t) {
            StatusHandler.log((IStatus)new Status(4, ID_PLUGIN, "Could not format notification for: " + task, t));
        }
        return notification;
    }

    private static String getChangedDescription(RepositoryTaskData newTaskData, RepositoryTaskData oldTaskData) {
        TaskComment lastComment;
        List taskComments;
        String descriptionText = "";
        if (newTaskData.getComments().size() > oldTaskData.getComments().size() && (taskComments = newTaskData.getComments()) != null && taskComments.size() > 0 && (lastComment = (TaskComment)taskComments.get(taskComments.size() - 1)) != null) {
            descriptionText = String.valueOf(descriptionText) + lastComment.getAuthor() + ":  ";
            descriptionText = String.valueOf(descriptionText) + TasksUiPlugin.cleanValue(lastComment.getText());
        }
        return descriptionText;
    }

    private static String getChangedAttributes(RepositoryTaskData newTaskData, RepositoryTaskData oldTaskData) {
        ArrayList<Change> changes = new ArrayList<Change>();
        for (RepositoryTaskAttribute newAttribute : newTaskData.getAttributes()) {
            List oldValues;
            List newValues;
            if (TasksUiPlugin.ignoreAttribute(newTaskData, newAttribute) || (newValues = newAttribute.getValues()) == null) continue;
            RepositoryTaskAttribute oldAttribute = oldTaskData.getAttribute(newAttribute.getId());
            if (oldAttribute == null) {
                changes.add(TasksUiPlugin.getDiff(newTaskData, newAttribute, null, newValues));
            }
            if (oldAttribute == null || (oldValues = oldAttribute.getValues()).equals(newValues)) continue;
            changes.add(TasksUiPlugin.getDiff(newTaskData, newAttribute, oldValues, newValues));
        }
        for (RepositoryTaskAttribute oldAttribute : oldTaskData.getAttributes()) {
            if (TasksUiPlugin.ignoreAttribute(oldTaskData, oldAttribute)) continue;
            RepositoryTaskAttribute attribute = newTaskData.getAttribute(oldAttribute.getId());
            List values = oldAttribute.getValues();
            if (attribute != null || values == null || values.isEmpty()) continue;
            changes.add(TasksUiPlugin.getDiff(oldTaskData, oldAttribute, values, null));
        }
        if (changes.isEmpty()) {
            return "";
        }
        String details = "";
        String sep = "";
        int n = 0;
        for (Change change : changes) {
            String removed = TasksUiPlugin.cleanValues(change.removed);
            String added = TasksUiPlugin.cleanValues(change.added);
            details = String.valueOf(details) + sep + "  " + change.field + " " + removed;
            if (removed.length() > 30) {
                details = String.valueOf(details) + "\n  ";
            }
            details = String.valueOf(details) + " -> " + added;
            sep = "\n";
            if (++n == 2) break;
        }
        return details;
    }

    private static String cleanValues(List<String> values) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String value : values) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(TasksUiPlugin.cleanValue(value));
            first = false;
        }
        return sb.toString();
    }

    private static String cleanValue(String value) {
        String commentText = value.replaceAll("\\s", " ").trim();
        if (commentText.length() > 60) {
            commentText = String.valueOf(commentText.substring(0, 55)) + "...";
        }
        return commentText;
    }

    private static boolean ignoreAttribute(RepositoryTaskData taskData, RepositoryTaskAttribute attribute) {
        AbstractAttributeFactory factory = taskData.getAttributeFactory();
        return attribute.getId().equals(factory.mapCommonAttributeKey("task.common.date.modified")) || attribute.getId().equals(factory.mapCommonAttributeKey("task.common.date.created")) || "delta_ts".equals(attribute.getId()) || "longdesclength".equals(attribute.getId());
    }

    private static Change getDiff(RepositoryTaskData taskData, RepositoryTaskAttribute attribute, List<String> oldValues, List<String> newValues) {
        Change change = new Change(attribute.getName(), newValues);
        if (oldValues != null) {
            for (String value : oldValues) {
                if (change.added.contains(value)) {
                    change.added.remove(value);
                    continue;
                }
                change.removed.add(value);
            }
        }
        return change;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Change {
        final String field;
        final List<String> added;
        final List<String> removed = new ArrayList<String>();

        public Change(String field, List<String> newValues) {
            this.field = field;
            this.added = newValues != null ? new ArrayList<String>(newValues) : new ArrayList<String>();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class OrderComparator
    implements Comparator<AbstractTaskRepositoryLinkProvider> {
        private OrderComparator() {
        }

        @Override
        public int compare(AbstractTaskRepositoryLinkProvider p1, AbstractTaskRepositoryLinkProvider p2) {
            return p1.getOrder() - p2.getOrder();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ReportOpenMode {
        EDITOR,
        INTERNAL_BROWSER,
        EXTERNAL_BROWSER;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TaskListSaveMode {
        ONE_HOUR,
        THREE_HOURS,
        DAY;


        public String toString() {
            switch (this) {
                case ONE_HOUR: {
                    return "1 hour";
                }
                case THREE_HOURS: {
                    return "3 hours";
                }
                case DAY: {
                    return "1 day";
                }
            }
            return "3 hours";
        }

        public static TaskListSaveMode fromString(String string) {
            if (string == null) {
                return null;
            }
            if (string.equals("1 hour")) {
                return ONE_HOUR;
            }
            if (string.equals("3 hours")) {
                return THREE_HOURS;
            }
            if (string.equals("1 day")) {
                return DAY;
            }
            return null;
        }

        public static long fromStringToLong(String string) {
            long hour = 3600000L;
            switch (TaskListSaveMode.fromString(string)) {
                case ONE_HOUR: {
                    return hour;
                }
                case THREE_HOURS: {
                    return hour * 3L;
                }
                case DAY: {
                    return hour * 24L;
                }
            }
            return hour * 3L;
        }
    }

    private class TasksUiInitializationJob
    extends UIJob {
        public TasksUiInitializationJob() {
            super("Initializing Task List");
            this.setSystem(true);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            block13: {
                monitor.beginTask("Initializing Task List", 5);
                try {
                    TasksUiExtensionReader.initWorkbenchUiExtensions();
                    if (taskListManager.getTaskList().getActiveTask() != null) {
                        taskListManager.activateTask(taskListManager.getTaskList().getActiveTask());
                    }
                    taskListManager.initActivityHistory();
                }
                catch (Throwable t) {
                    StatusHandler.log((IStatus)new Status(4, TasksUiPlugin.ID_PLUGIN, "Could not initialize task activity", t));
                }
                monitor.worked(1);
                try {
                    TasksUiPlugin.this.taskListNotificationManager = new TaskListNotificationManager();
                    TasksUiPlugin.this.taskListNotificationManager.addNotificationProvider(REMINDER_NOTIFICATION_PROVIDER);
                    TasksUiPlugin.this.taskListNotificationManager.addNotificationProvider(INCOMING_NOTIFICATION_PROVIDER);
                    TasksUiPlugin.this.taskListNotificationManager.startNotification(5000L);
                    TasksUiPlugin.this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)TasksUiPlugin.this.taskListNotificationManager);
                }
                catch (Throwable t) {
                    StatusHandler.log((IStatus)new Status(4, TasksUiPlugin.ID_PLUGIN, "Could not initialize notifications", t));
                }
                monitor.worked(1);
                try {
                    TasksUiPlugin.this.taskListBackupManager = new TaskListBackupManager();
                    TasksUiPlugin.this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)TasksUiPlugin.this.taskListBackupManager);
                    synchronizationScheduler = new TaskListSynchronizationScheduler(true);
                    synchronizationScheduler.startSynchJob();
                }
                catch (Throwable t) {
                    StatusHandler.log((IStatus)new Status(4, TasksUiPlugin.ID_PLUGIN, "Could not initialize task list backup and synchronization", t));
                }
                monitor.worked(1);
                try {
                    try {
                        TasksUiPlugin.this.taskListSaveManager = new TaskListSaveManager();
                        taskListManager.setTaskListSaveManager(TasksUiPlugin.this.taskListSaveManager);
                        ContextCorePlugin.getDefault().getPluginPreferences().addPropertyChangeListener(TasksUiPlugin.this.PREFERENCE_LISTENER);
                        TasksUiPlugin.this.getPreferenceStore().addPropertyChangeListener(TasksUiPlugin.this.PROPERTY_LISTENER);
                        TasksUiPlugin.this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)synchronizationScheduler);
                        TasksUiPlugin.this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)taskListManager);
                        TaskRepositoriesView repositoriesView = TaskRepositoriesView.getFromActivePerspective();
                        if (repositoriesView != null) {
                            repositoriesView.getViewer().refresh();
                        }
                        TasksUiPlugin.this.taskEditorBloatManager = new TaskEditorBloatMonitor();
                        TasksUiPlugin.this.taskEditorBloatManager.install(PlatformUI.getWorkbench());
                    }
                    catch (Throwable t) {
                        StatusHandler.log((IStatus)new Status(4, TasksUiPlugin.ID_PLUGIN, "Could not finish Tasks UI initialization", t));
                        monitor.done();
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    monitor.done();
                    throw throwable;
                }
                monitor.done();
            }
            return new Status(0, TasksUiPlugin.ID_PLUGIN, 0, "", null);
        }
    }

    public static class TasksUiStartup
    implements IStartup {
        public void earlyStartup() {
        }
    }
}

