/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.core.ScheduledTaskDelegate;
import org.eclipse.mylyn.internal.tasks.core.TaskCategory;
import org.eclipse.mylyn.internal.tasks.ui.editors.CategoryEditorInput;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskRepositoriesView;
import org.eclipse.mylyn.internal.tasks.ui.wizards.EditRepositoryWizard;
import org.eclipse.mylyn.internal.tasks.ui.wizards.NewLocalTaskWizard;
import org.eclipse.mylyn.internal.tasks.ui.wizards.NewTaskWizard;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.TaskSelection;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.ui.editors.AbstractRepositoryTaskEditor;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorInput;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.internal.browser.WebBrowserPreference;
import org.eclipse.ui.internal.browser.WorkbenchBrowserSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TasksUiUtil {
    public static final String PREFS_PAGE_ID_COLORS_AND_FONTS = "org.eclipse.ui.preferencePages.ColorsAndFonts";
    public static final int FLAG_NO_RICH_EDITOR = 131072;

    public static void openUrl(String url, boolean useRichEditorIfAvailable) {
        try {
            if (useRichEditorIfAvailable) {
                AbstractTask task = TasksUiPlugin.getTaskListManager().getTaskList().getRepositoryTask(url);
                if (task != null && !(task instanceof LocalTask)) {
                    TasksUiUtil.refreshAndOpenTaskListElement((AbstractTaskContainer)task);
                } else {
                    boolean opened = false;
                    AbstractRepositoryConnector connector = TasksUiPlugin.getRepositoryManager().getConnectorForRepositoryTaskUrl(url);
                    if (connector != null) {
                        String repositoryUrl = connector.getRepositoryUrlFromTaskUrl(url);
                        String id = connector.getTaskIdFromTaskUrl(url);
                        TaskRepository repository = TasksUiPlugin.getRepositoryManager().getRepository(repositoryUrl);
                        opened = TasksUiUtil.openRepositoryTask(repository, id);
                    }
                    if (!opened) {
                        TasksUiUtil.openUrl(new URL(url), 0);
                    }
                }
            } else {
                TasksUiUtil.openUrl(new URL(url), 131072);
            }
        }
        catch (PartInitException partInitException) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Browser init error", (String)"Browser could not be initiated");
        }
        catch (MalformedURLException malformedURLException) {
            if (url != null && url.trim().equals("")) {
                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Task Editor", (String)("No URL to open." + url));
            }
            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Task Editor", (String)("Could not open URL: " + url));
        }
    }

    private static void openUrl(URL url, int customFlags) throws PartInitException {
        if (WebBrowserPreference.getBrowserChoice() == 1) {
            try {
                IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
                support.getExternalBrowser().openURL(url);
            }
            catch (Exception e) {
                StatusHandler.fail((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not open task url", (Throwable)e));
            }
        } else {
            IWebBrowser browser = null;
            int flags = 0;
            flags = WorkbenchBrowserSupport.getInstance().isInternalWebBrowserAvailable() ? 0x26 | customFlags : 0x86 | customFlags;
            String generatedId = "org.eclipse.mylyn.web.browser-" + Calendar.getInstance().getTimeInMillis();
            browser = WorkbenchBrowserSupport.getInstance().createBrowser(flags, generatedId, null, null);
            browser.openURL(url);
        }
    }

    public static boolean openRepositoryTask(TaskRepository repository, String taskId) {
        if (repository == null || taskId == null) {
            return false;
        }
        boolean opened = false;
        AbstractTask task = TasksUiPlugin.getTaskListManager().getTaskList().getTask(repository.getUrl(), taskId);
        if (task == null) {
            task = TasksUiPlugin.getTaskListManager().getTaskList().getTaskByKey(repository.getUrl(), taskId);
        }
        if (task != null) {
            TasksUiUtil.refreshAndOpenTaskListElement((AbstractTaskContainer)task);
            opened = true;
        } else {
            AbstractRepositoryConnectorUi connectorUi = TasksUiPlugin.getConnectorUi(repository.getConnectorKind());
            if (connectorUi != null) {
                try {
                    opened = connectorUi.openRepositoryTask(repository.getUrl(), taskId);
                }
                catch (Exception e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Internal error while opening repository task", (Throwable)e));
                }
            }
        }
        return opened;
    }

    public static boolean openRepositoryTask(String repositoryUrl, String taskId, String fullUrl) {
        boolean opened = false;
        AbstractTask task = null;
        if (repositoryUrl != null && taskId != null) {
            task = TasksUiPlugin.getTaskListManager().getTaskList().getTask(repositoryUrl, taskId);
        }
        if (task == null && fullUrl != null) {
            task = TasksUiPlugin.getTaskListManager().getTaskList().getRepositoryTask(fullUrl);
        }
        if (task == null && repositoryUrl != null && taskId != null) {
            task = TasksUiPlugin.getTaskListManager().getTaskList().getTaskByKey(repositoryUrl, taskId);
        }
        if (task != null) {
            TasksUiUtil.refreshAndOpenTaskListElement((AbstractTaskContainer)task);
            opened = true;
        } else {
            AbstractRepositoryConnector connector = TasksUiPlugin.getRepositoryManager().getConnectorForRepositoryTaskUrl(fullUrl);
            if (connector != null) {
                AbstractRepositoryConnectorUi connectorUi = TasksUiPlugin.getConnectorUi(connector.getConnectorKind());
                if (repositoryUrl != null && taskId != null) {
                    opened = connectorUi.openRepositoryTask(repositoryUrl, taskId);
                } else {
                    repositoryUrl = connector.getRepositoryUrlFromTaskUrl(fullUrl);
                    taskId = connector.getTaskIdFromTaskUrl(fullUrl);
                    if (repositoryUrl != null && taskId != null) {
                        opened = connectorUi.openRepositoryTask(repositoryUrl, taskId);
                    }
                }
            }
        }
        if (!opened) {
            TasksUiUtil.openUrl(fullUrl, false);
            opened = true;
        }
        return opened;
    }

    public static void refreshAndOpenTaskListElement(AbstractTaskContainer element) {
        if (element instanceof AbstractTask || element instanceof ScheduledTaskDelegate) {
            final AbstractTask task = element instanceof ScheduledTaskDelegate ? ((ScheduledTaskDelegate)element).getCorrespondingTask() : (AbstractTask)element;
            if (task instanceof LocalTask) {
                TasksUiUtil.openEditor(task, false);
            } else if (task != null) {
                AbstractTask repositoryTask = task;
                String repositoryKind = repositoryTask.getConnectorKind();
                AbstractRepositoryConnector connector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector(repositoryKind);
                TaskRepository repository = TasksUiPlugin.getRepositoryManager().getRepository(repositoryKind, repositoryTask.getRepositoryUrl());
                if (repository == null) {
                    StatusHandler.fail((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "No repository found for task. Please create repository in Task Repositories."));
                    return;
                }
                if (connector != null) {
                    RepositoryTaskData taskData = TasksUiPlugin.getTaskDataManager().getNewTaskData(task.getRepositoryUrl(), task.getTaskId());
                    if (taskData != null) {
                        TasksUiUtil.openEditor(task, true, false);
                    } else {
                        Job refreshJob = TasksUiPlugin.getSynchronizationManager().synchronize(connector, repositoryTask, true, (IJobChangeListener)new JobChangeAdapter(){

                            public void done(IJobChangeEvent event) {
                                TasksUiUtil.openEditor(task, false);
                            }
                        });
                        if (refreshJob == null) {
                            TasksUiUtil.openEditor(task, false);
                        }
                    }
                }
            } else {
                TasksUiUtil.openEditor(task, false);
            }
        } else if (element instanceof TaskCategory) {
            TasksUiUtil.openEditor((TaskCategory)element);
        } else if (element instanceof AbstractRepositoryQuery) {
            AbstractRepositoryQuery query = (AbstractRepositoryQuery)element;
            AbstractRepositoryConnectorUi connectorUi = TasksUiPlugin.getConnectorUi(query.getRepositoryKind());
            connectorUi.openEditQueryDialog(query);
        }
    }

    public static void openEditor(AbstractTask task, boolean newTask) {
        TasksUiUtil.openEditor(task, true, newTask);
    }

    private static String getTaskEditorId(AbstractTask task) {
        AbstractTask repositoryTask;
        AbstractRepositoryConnectorUi repositoryUi;
        String customTaskEditorId;
        String taskEditorId = "org.eclipse.mylyn.tasks.ui.editors.task";
        if (task != null && (customTaskEditorId = (repositoryUi = TasksUiPlugin.getConnectorUi((repositoryTask = task).getConnectorKind())).getTaskEditorId(repositoryTask)) != null) {
            taskEditorId = customTaskEditorId;
        }
        return taskEditorId;
    }

    public static void openEditor(AbstractTask task, String pageId) {
        TaskEditorInput editorInput = new TaskEditorInput(task, false);
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IEditorPart part = TasksUiUtil.openEditor(editorInput, TasksUiUtil.getTaskEditorId(task), window.getActivePage());
        if (part instanceof TaskEditor) {
            ((TaskEditor)part).setActivePage(pageId);
        }
    }

    public static void openEditor(final AbstractTask task, boolean asyncExec, final boolean newTask) {
        final boolean openWithBrowser = !TasksUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.reporting.open.editor");
        final String taskEditorId = TasksUiUtil.getTaskEditorId(task);
        final TaskEditorInput editorInput = new TaskEditorInput(task, newTask);
        if (asyncExec) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){
                private boolean wasOpen = false;

                public void run() {
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (window != null) {
                        if (openWithBrowser) {
                            TasksUiUtil.openUrl(task.getUrl(), false);
                        } else {
                            IWorkbenchPage page = window.getActivePage();
                            this.wasOpen = TasksUiUtil.refreshIfOpen(task, editorInput);
                            if (!this.wasOpen) {
                                IEditorPart part = TasksUiUtil.openEditor(editorInput, taskEditorId, page);
                                if (newTask && part instanceof TaskEditor) {
                                    TaskEditor taskEditor = (TaskEditor)part;
                                    taskEditor.setFocusOfActivePage();
                                }
                            }
                        }
                        Job updateTaskData = new Job("Update Task State"){

                            protected IStatus run(IProgressMonitor monitor) {
                                if (task != null) {
                                    AbstractRepositoryConnector connector;
                                    AbstractTask repositoryTask = task;
                                    if (!wasOpen) {
                                        TasksUiPlugin.getSynchronizationManager().setTaskRead(repositoryTask, true);
                                    }
                                    if ((connector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector(repositoryTask.getConnectorKind())) != null) {
                                        TasksUiPlugin.getSynchronizationManager().synchronize(connector, repositoryTask, false, null);
                                    }
                                }
                                return Status.OK_STATUS;
                            }
                        };
                        updateTaskData.setSystem(true);
                        updateTaskData.schedule();
                    }
                }
            });
        } else {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window != null) {
                if (openWithBrowser) {
                    TasksUiUtil.openUrl(task.getUrl(), false);
                } else {
                    IWorkbenchPage page = window.getActivePage();
                    TasksUiUtil.openEditor(editorInput, taskEditorId, page);
                }
                if (task != null) {
                    TasksUiPlugin.getSynchronizationManager().setTaskRead(task, true);
                }
            } else {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Unable to open editor for " + task.getSummary()));
            }
        }
    }

    private static boolean refreshIfOpen(AbstractTask task, IEditorInput editorInput) {
        if (task != null && (task.getSynchronizationState() == AbstractTask.RepositoryTaskSyncState.INCOMING || task.getSynchronizationState() == AbstractTask.RepositoryTaskSyncState.CONFLICT)) {
            for (TaskEditor editor : TasksUiUtil.getActiveRepositoryTaskEditors()) {
                if (!editor.getEditorInput().equals(editorInput)) continue;
                editor.refreshEditorContents();
                editor.getEditorSite().getPage().activate((IWorkbenchPart)editor);
                return true;
            }
        }
        return false;
    }

    public static IEditorPart openEditor(IEditorInput input, String editorId, IWorkbenchPage page) {
        try {
            return page.openEditor(input, editorId);
        }
        catch (PartInitException e) {
            StatusHandler.fail((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Open for editor failed: " + input + ", taskId: " + editorId, (Throwable)e));
            return null;
        }
    }

    public static void openEditor(TaskCategory category) {
        final CategoryEditorInput input = new CategoryEditorInput(category);
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window != null) {
                    IWorkbenchPage page = window.getActivePage();
                    TasksUiUtil.openEditor(input, "org.eclipse.mylyn.tasks.ui.editors.category", page);
                }
            }
        });
    }

    public static int openEditRepositoryWizard(TaskRepository repository) {
        block4: {
            EditRepositoryWizard wizard = new EditRepositoryWizard(repository);
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            if (shell == null || shell.isDisposed()) break block4;
            WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
            dialog.create();
            dialog.setBlockOnOpen(true);
            if (dialog.open() != 1) break block4;
            dialog.close();
            return 1;
        }
        try {
            if (TaskRepositoriesView.getFromActivePerspective() != null) {
                TaskRepositoriesView.getFromActivePerspective().getViewer().refresh();
            }
        }
        catch (Exception e) {
            StatusHandler.fail((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", e.getMessage(), (Throwable)e));
        }
        return 0;
    }

    public static List<TaskEditor> getActiveRepositoryTaskEditors() {
        IWorkbenchWindow[] windows;
        ArrayList<TaskEditor> repositoryTaskEditors = new ArrayList<TaskEditor>();
        IWorkbenchWindow[] iWorkbenchWindowArray = windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IEditorReference[] editorReferences = window.getActivePage().getEditorReferences();
            int i = 0;
            while (i < editorReferences.length) {
                try {
                    IEditorPart editorPart;
                    TaskEditorInput input;
                    if (editorReferences[i].getEditorInput() instanceof TaskEditorInput && (input = (TaskEditorInput)editorReferences[i].getEditorInput()).getTask() != null && (editorPart = editorReferences[i].getEditor(false)) instanceof TaskEditor) {
                        repositoryTaskEditors.add((TaskEditor)editorPart);
                    }
                }
                catch (PartInitException partInitException) {}
                ++i;
            }
            ++n2;
        }
        return repositoryTaskEditors;
    }

    public static TaskRepository getSelectedRepository() {
        return TasksUiUtil.getSelectedRepository(null);
    }

    public static TaskRepository getSelectedRepository(StructuredViewer viewer) {
        IWorkbenchWindow window;
        ISelection windowSelection;
        IStructuredSelection selection = null;
        if (viewer != null) {
            selection = (IStructuredSelection)viewer.getSelection();
        }
        if ((selection == null || selection.isEmpty()) && (windowSelection = (window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()).getSelectionService().getSelection()) instanceof IStructuredSelection) {
            selection = (IStructuredSelection)windowSelection;
        }
        if (selection == null) {
            return null;
        }
        Object element = selection.getFirstElement();
        if (element instanceof TaskRepository) {
            return (TaskRepository)selection.getFirstElement();
        }
        if (element instanceof AbstractRepositoryQuery) {
            AbstractRepositoryQuery query = (AbstractRepositoryQuery)element;
            return TasksUiPlugin.getRepositoryManager().getRepository(query.getRepositoryKind(), query.getRepositoryUrl());
        }
        if (element instanceof AbstractTask) {
            AbstractTask task = (AbstractTask)element;
            return TasksUiPlugin.getRepositoryManager().getRepository(task.getConnectorKind(), task.getRepositoryUrl());
        }
        if (element instanceof IResource) {
            IResource resource = (IResource)element;
            return TasksUiPlugin.getDefault().getRepositoryForResource(resource, true);
        }
        if (element instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)element;
            IResource resource = (IResource)adaptable.getAdapter(IResource.class);
            if (resource != null) {
                return TasksUiPlugin.getDefault().getRepositoryForResource(resource, true);
            }
            AbstractTask task = (AbstractTask)adaptable.getAdapter(AbstractTask.class);
            if (task != null) {
                AbstractTask rtask = task;
                return TasksUiPlugin.getRepositoryManager().getRepository(rtask.getConnectorKind(), rtask.getRepositoryUrl());
            }
        }
        return null;
    }

    @Deprecated
    public static void showPreferencePage(String id, IPreferencePage page) {
        PreferenceNode targetNode = new PreferenceNode(id, page);
        PreferenceManager manager = new PreferenceManager();
        manager.addToRoot((IPreferenceNode)targetNode);
        final PreferenceDialog dialog = new PreferenceDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), manager);
        boolean[] result = new boolean[1];
        BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable((IPreferenceNode)targetNode, result){
            private final /* synthetic */ IPreferenceNode val$targetNode;
            private final /* synthetic */ boolean[] val$result;
            {
                this.val$targetNode = iPreferenceNode;
                this.val$result = blArray;
            }

            public void run() {
                dialog.create();
                dialog.setMessage(this.val$targetNode.getLabelText());
                this.val$result[0] = dialog.open() == 0;
            }
        });
    }

    public static void closeEditorInActivePage(AbstractTask task, boolean save) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return;
        }
        TaskEditorInput input = new TaskEditorInput(task, false);
        IEditorPart editor = page.findEditor((IEditorInput)input);
        if (editor != null) {
            page.closeEditor(editor, save);
        }
    }

    public static boolean isAnimationsEnabled() {
        IPreferenceStore store = PlatformUI.getPreferenceStore();
        return store.getBoolean("ENABLE_ANIMATIONS");
    }

    public static boolean openNewLocalTaskEditor(Shell shell, TaskSelection taskSelection) {
        return TasksUiUtil.openNewTaskEditor(shell, (IWizard)new NewLocalTaskWizard(taskSelection), taskSelection, true);
    }

    public static boolean openNewTaskEditor(Shell shell, TaskSelection taskSelection, TaskRepository taskRepository) {
        NewTaskWizard wizard;
        List repositories = TasksUiPlugin.getRepositoryManager().getAllRepositories();
        if (taskRepository == null && repositories.size() == 1) {
            taskRepository = (TaskRepository)repositories.get(0);
        }
        boolean supportsTaskSelection = true;
        if (taskRepository != null) {
            AbstractRepositoryConnectorUi connectorUi = TasksUiPlugin.getConnectorUi(taskRepository.getConnectorKind());
            IWizard newWizard = connectorUi.getNewTaskWizard(taskRepository, taskSelection);
            if (newWizard == null) {
                wizard = connectorUi.getNewTaskWizard(taskRepository);
                supportsTaskSelection = false;
            } else {
                wizard = newWizard;
            }
        } else {
            wizard = new NewTaskWizard(taskSelection);
        }
        return TasksUiUtil.openNewTaskEditor(shell, (IWizard)wizard, taskSelection, supportsTaskSelection);
    }

    private static boolean openNewTaskEditor(Shell shell, IWizard wizard, TaskSelection taskSelection, boolean supportsTaskSelection) {
        WizardDialog dialog = new WizardDialog(shell, wizard);
        dialog.setBlockOnOpen(true);
        dialog.create();
        if (!(wizard instanceof NewTaskWizard) && wizard.canFinish()) {
            wizard.performFinish();
            if (!supportsTaskSelection) {
                TasksUiUtil.handleSelection(taskSelection);
            }
            return true;
        }
        int result = dialog.open();
        if (result == 0) {
            if (wizard instanceof NewTaskWizard) {
                supportsTaskSelection = ((NewTaskWizard)wizard).supportsTaskSelection();
            }
            if (!supportsTaskSelection) {
                TasksUiUtil.handleSelection(taskSelection);
            }
            return true;
        }
        return false;
    }

    private static void handleSelection(final TaskSelection taskSelection) {
        if (taskSelection == null) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                TaskEditor taskEditor;
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                if (page == null) {
                    return;
                }
                RepositoryTaskData taskData = taskSelection.getTaskData();
                String summary = taskData.getSummary();
                String description = taskData.getDescription();
                if (page.getActiveEditor() instanceof TaskEditor && (taskEditor = (TaskEditor)page.getActiveEditor()).getActivePageInstance() instanceof AbstractRepositoryTaskEditor) {
                    AbstractRepositoryTaskEditor repositoryTaskEditor = (AbstractRepositoryTaskEditor)taskEditor.getActivePageInstance();
                    repositoryTaskEditor.setSummaryText(summary);
                    repositoryTaskEditor.setDescriptionText(description);
                    return;
                }
                Clipboard clipboard = new Clipboard(page.getWorkbenchWindow().getShell().getDisplay());
                clipboard.setContents(new Object[]{String.valueOf(summary) + "\n" + description}, new Transfer[]{TextTransfer.getInstance()});
                MessageDialog.openInformation((Shell)page.getWorkbenchWindow().getShell(), (String)"Mylyn Information", (String)"This connector does not provide a rich task editor for creating tasks.\n\nThe error contents have been placed in the clipboard so that you can paste them into the entry form.");
            }
        });
    }
}

