/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui.search;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.ITaskCollector;
import org.eclipse.mylyn.tasks.core.ITaskFactory;
import org.eclipse.mylyn.tasks.core.RepositoryStatus;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;
import org.eclipse.mylyn.tasks.core.TaskList;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.ui.search.RepositorySearchResult;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchHitCollector
implements ISearchQuery,
ITaskCollector {
    private static final String LABEL_MAX_HITS_REACHED = "Max allowed number of hits returned exceeded. Some hits may not be displayed. Please narrow query scope.";
    private static final String QUERYING_REPOSITORY = "Querying Repository...";
    private Set<AbstractTask> taskResults = new HashSet<AbstractTask>();
    private final TaskList taskList;
    private final ITaskFactory taskFactory;
    private TaskRepository repository;
    private AbstractRepositoryQuery repositoryQuery;
    private RepositorySearchResult searchResult;

    public SearchHitCollector(TaskList tasklist, TaskRepository repository, AbstractRepositoryQuery repositoryQuery, ITaskFactory taskFactory) {
        this.taskList = tasklist;
        this.repository = repository;
        this.repositoryQuery = repositoryQuery;
        this.searchResult = new RepositorySearchResult(this);
        this.taskFactory = taskFactory;
    }

    public void aboutToStart() {
        this.taskResults.clear();
        this.searchResult.removeAll();
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                NewSearchUI.activateSearchResultView();
            }
        });
    }

    public void accept(AbstractTask task) {
        if (task == null) {
            throw new IllegalArgumentException();
        }
        AbstractTask hitTask = this.taskList.getTask(task.getHandleIdentifier());
        if (hitTask == null) {
            hitTask = task;
        }
        this.taskResults.add(hitTask);
        this.searchResult.addMatch(new Match((Object)hitTask, 0, 0));
    }

    public void accept(RepositoryTaskData taskData) throws CoreException {
        if (taskData == null) {
            throw new IllegalArgumentException();
        }
        AbstractTask task = this.taskFactory.createTask(taskData, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)new NullProgressMonitor(), 1));
        if (task != null) {
            this.taskResults.add(task);
            this.searchResult.addMatch(new Match((Object)task, 0, 0));
        }
    }

    public String getLabel() {
        return QUERYING_REPOSITORY;
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        if (this.searchResult.getMatchCount() >= 5000) {
            StatusHandler.displayStatus((String)"Maximum hits reached", (IStatus)RepositoryStatus.createStatus((String)this.repository.getUrl(), (int)2, (String)"org.eclipse.mylyn.tasks.ui", (String)LABEL_MAX_HITS_REACHED));
        }
        return this.searchResult;
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        this.aboutToStart();
        if (monitor.isCanceled()) {
            throw new OperationCanceledException("Search cancelled");
        }
        AbstractRepositoryConnector connector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector(this.repositoryQuery.getRepositoryKind());
        if (connector != null) {
            IStatus status = connector.performQuery(this.repositoryQuery, this.repository, monitor, (ITaskCollector)this);
            if (!status.isOK()) {
                StatusHandler.displayStatus((String)"Search failed", (IStatus)status);
            }
        } else {
            return new Status(4, "org.eclipse.mylyn.tasks.ui", 0, "repository connector could not be found", null);
        }
        return Status.OK_STATUS;
    }

    public Set<AbstractTask> getTasks() {
        return this.taskResults;
    }

    public AbstractRepositoryQuery getRepositoryQuery() {
        return this.repositoryQuery;
    }
}

