/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.team.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mylyn.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.team.ui.FocusedTeamUiPlugin;
import org.eclipse.mylyn.internal.team.ui.LinkedTaskInfo;
import org.eclipse.mylyn.internal.team.ui.properties.TeamPropertiesLinkProvider;
import org.eclipse.mylyn.monitor.core.InteractionEvent;
import org.eclipse.mylyn.resources.ResourcesUiBridgePlugin;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.ILinkedTaskInfo;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.provider.ThreeWayDiff;
import org.eclipse.team.core.mapping.provider.ResourceDiff;
import org.eclipse.team.internal.ccvs.core.mapping.CVSActiveChangeSet;
import org.eclipse.team.internal.ccvs.core.mapping.ChangeSetResourceMapping;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSetManager;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.eclipse.team.internal.core.subscribers.DiffChangeSet;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextChangeSet
extends CVSActiveChangeSet
implements IAdaptable {
    private static final String CTX_TITLE = "title";
    public static final String SOURCE_ID = "org.eclipse.mylyn.java.context.changeset.add";
    private boolean suppressInterestContribution = false;
    private AbstractTask task;

    public ContextChangeSet(AbstractTask task, ActiveChangeSetManager manager) {
        super(manager, task.getSummary());
        this.task = task;
        this.initTitle();
    }

    public boolean isUserCreated() {
        return true;
    }

    public void initTitle() {
        super.setName(this.task.getSummary());
        super.setTitle(this.task.getSummary());
    }

    public void save(Preferences prefs) {
        super.save(prefs);
        prefs.put(CTX_TITLE, this.getTitleForPersistance());
    }

    private String getTitleForPersistance() {
        return String.valueOf(this.getTitle()) + " (" + this.task.getHandleIdentifier() + ")";
    }

    public static String getHandleFromPersistedTitle(String title) {
        int delimStart = title.lastIndexOf(40);
        int delimEnd = title.lastIndexOf(41);
        if (delimStart != -1 && delimEnd != -1) {
            return title.substring(delimStart + 1, delimEnd);
        }
        return null;
    }

    public String getComment() {
        return this.internalGetComment(true);
    }

    private String internalGetComment(boolean checkTaskRepository) {
        String template = null;
        HashSet<IProject> projects = new HashSet<IProject>();
        IResource[] resources = this.getChangedResources();
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            IProject project = resource.getProject();
            if (project != null && project.isAccessible() && !projects.contains(project)) {
                TeamPropertiesLinkProvider provider = new TeamPropertiesLinkProvider();
                template = provider.getCommitCommentTemplate((IResource)project);
                if (template != null) break;
                projects.add(project);
            }
            ++n2;
        }
        boolean proceed = true;
        if (checkTaskRepository) {
            boolean unmatchedRepositoryFound = false;
            for (IProject project : projects) {
                TaskRepository repository = TasksUiPlugin.getDefault().getRepositoryForResource((IResource)project, true);
                if (repository == null || repository.getUrl().equals(this.task.getRepositoryUrl())) continue;
                unmatchedRepositoryFound = true;
            }
            if (unmatchedRepositoryFound) {
                proceed = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Mylyn Change Set Management", (String)"You are attempting to commit a resource which is not associated with the selected task repository.  Proceed with creating the commit message?");
            }
        }
        if (proceed) {
            if (template == null) {
                template = FocusedTeamUiPlugin.getDefault().getPreferenceStore().getString("org.eclipse.mylyn.team.commit.template");
            }
            return FocusedTeamUiPlugin.getDefault().getCommitTemplateManager().generateComment(this.task, template);
        }
        return "";
    }

    public void remove(IResource resource) {
        super.remove(resource);
    }

    public void remove(IResource[] newResources) {
        super.remove(newResources);
    }

    public void add(IDiff diff) {
        super.add(diff);
        IResource resource = this.getResourceFromDiff(diff);
        if (!this.suppressInterestContribution && resource != null) {
            HashSet<IResource> resources = new HashSet<IResource>();
            resources.add(resource);
            if (ResourcesUiBridgePlugin.getDefault() != null) {
                ResourcesUiBridgePlugin.getInterestUpdater().addResourceToContext(resources, InteractionEvent.Kind.SELECTION);
            }
        }
    }

    private IResource getResourceFromDiff(IDiff diff) {
        if (diff instanceof ResourceDiff) {
            return ((ResourceDiff)diff).getResource();
        }
        if (diff instanceof ThreeWayDiff) {
            ThreeWayDiff threeWayDiff = (ThreeWayDiff)diff;
            return ResourcesPlugin.getWorkspace().getRoot().findMember(threeWayDiff.getPath());
        }
        return null;
    }

    public void add(IDiff[] diffs) {
        super.add(diffs);
    }

    public void add(IResource[] newResources) throws CoreException {
        super.add(newResources);
    }

    public void restoreResources(IResource[] newResources) throws CoreException {
        this.suppressInterestContribution = true;
        try {
            super.add(newResources);
            this.setComment(this.internalGetComment(false));
        }
        finally {
            this.suppressInterestContribution = false;
        }
    }

    public IResource[] getResources() {
        List<IResource> allResources = this.getAllResourcesInChangeContext();
        return allResources.toArray(new IResource[allResources.size()]);
    }

    public IResource[] getChangedResources() {
        return super.getResources();
    }

    public List<IResource> getAllResourcesInChangeContext() {
        HashSet allResources = new HashSet();
        allResources.addAll(Arrays.asList(super.getResources()));
        if (Platform.isRunning() && ResourcesUiBridgePlugin.getDefault() != null && this.task.isActive()) {
            allResources.addAll(ResourcesUiBridgePlugin.getDefault().getInterestingResources(ContextCorePlugin.getContextManager().getActiveContext()));
        }
        return new ArrayList<IResource>(allResources);
    }

    public boolean contains(IResource local) {
        return this.getAllResourcesInChangeContext().contains(local);
    }

    public boolean equals(Object object) {
        if (object instanceof ContextChangeSet && this.task != null) {
            ContextChangeSet changeSet = (ContextChangeSet)((Object)object);
            return this.task.equals((Object)changeSet.getTask());
        }
        return super.equals(object);
    }

    public int hashCode() {
        if (this.task != null) {
            return this.task.hashCode();
        }
        return super.hashCode();
    }

    public AbstractTask getTask() {
        return this.task;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ResourceMapping.class) {
            return new ChangeSetResourceMapping((DiffChangeSet)this);
        }
        if (adapter == AbstractTask.class) {
            return this.task;
        }
        if (adapter == ILinkedTaskInfo.class) {
            return new LinkedTaskInfo(this.getTask(), (ChangeSet)this);
        }
        return null;
    }
}

