/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.team.ui.actions;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.context.ui.ContextUiImages;
import org.eclipse.mylyn.internal.team.ui.LinkedTaskInfo;
import org.eclipse.mylyn.monitor.core.InteractionEvent;
import org.eclipse.mylyn.resources.ResourcesUiBridgePlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSet;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.eclipse.team.internal.core.subscribers.DiffChangeSet;
import org.eclipse.team.internal.ui.synchronize.SynchronizeModelElement;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ObjectPluginAction;

public class AddToTaskContextAction
extends Action
implements IViewActionDelegate {
    private static final String LABEL = "Add to Task Context";
    private ISelection selection;

    public AddToTaskContextAction() {
        this.setText(LABEL);
        this.setToolTipText(LABEL);
        this.setImageDescriptor(ContextUiImages.CONTEXT_ADD);
    }

    public void init(IViewPart view) {
    }

    public void run() {
        if (this.selection instanceof StructuredSelection) {
            this.run((StructuredSelection)this.selection);
        }
    }

    public void run(IAction action) {
        ObjectPluginAction objectAction;
        if (action instanceof ObjectPluginAction && (objectAction = (ObjectPluginAction)action).getSelection() instanceof StructuredSelection) {
            StructuredSelection selection = (StructuredSelection)objectAction.getSelection();
            this.run(selection);
        }
    }

    private void run(StructuredSelection selection) {
        if (!ContextCorePlugin.getContextManager().isContextActive()) {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)LABEL, (String)"Activate a task to add resources.");
        }
        Object element = selection.getFirstElement();
        IResource[] resources = null;
        if (element instanceof ActiveChangeSet) {
            resources = ((ActiveChangeSet)element).getResources();
        } else if (element instanceof DiffChangeSet) {
            resources = ((DiffChangeSet)element).getResources();
        } else if (element instanceof LinkedTaskInfo) {
            LinkedTaskInfo linkedTaskInfo = (LinkedTaskInfo)element;
            ChangeSet changeSet = linkedTaskInfo.getChangeSet();
            resources = changeSet.getResources();
        }
        HashSet<IResource> resourcesToAdd = new HashSet<IResource>();
        if (resources != null) {
            resourcesToAdd.addAll((Collection)Arrays.asList(resources));
        } else {
            for (Object object : selection) {
                Object adapted;
                if (object instanceof IResource) {
                    resourcesToAdd.add((IResource)object);
                    continue;
                }
                if (object instanceof SynchronizeModelElement) {
                    resourcesToAdd.add(((SynchronizeModelElement)object).getResource());
                    continue;
                }
                if (!(object instanceof IAdaptable) || (adapted = ((IAdaptable)object).getAdapter(IResource.class)) == null) continue;
                resourcesToAdd.add((IResource)adapted);
            }
        }
        if (!resourcesToAdd.isEmpty()) {
            ResourcesUiBridgePlugin.getInterestUpdater().addResourceToContext(resourcesToAdd, InteractionEvent.Kind.SELECTION);
        } else {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)LABEL, (String)"No resources to add.");
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }
}

