/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.trac.core;

import java.io.InputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.mylyn.internal.trac.core.ITracClient;
import org.eclipse.mylyn.internal.trac.core.TracCorePlugin;
import org.eclipse.mylyn.internal.trac.core.TracRepositoryConnector;
import org.eclipse.mylyn.internal.trac.core.model.TracTicket;
import org.eclipse.mylyn.tasks.core.AbstractAttachmentHandler;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.ITaskAttachment;
import org.eclipse.mylyn.tasks.core.RepositoryAttachment;
import org.eclipse.mylyn.tasks.core.RepositoryStatus;
import org.eclipse.mylyn.tasks.core.TaskRepository;

public class TracAttachmentHandler
extends AbstractAttachmentHandler {
    private TracRepositoryConnector connector;

    public TracAttachmentHandler(TracRepositoryConnector connector) {
        this.connector = connector;
    }

    public InputStream getAttachmentAsStream(TaskRepository repository, RepositoryAttachment attachment, IProgressMonitor monitor) throws CoreException {
        String filename = attachment.getAttributeValue("filename");
        if (filename == null) {
            throw new CoreException((IStatus)new RepositoryStatus(repository.getUrl(), 4, "org.eclipse.mylyn.trac.core", 1, "Attachment download from " + repository.getUrl() + " failed, missing attachment filename."));
        }
        try {
            ITracClient client = this.connector.getClientManager().getRepository(repository);
            int id = Integer.parseInt(attachment.getTaskId());
            return client.getAttachmentData(id, filename);
        }
        catch (Exception e) {
            throw new CoreException(TracCorePlugin.toStatus(e, repository));
        }
    }

    public void uploadAttachment(TaskRepository repository, AbstractTask task, ITaskAttachment attachment, String comment, IProgressMonitor monitor) throws CoreException {
        if (!TracRepositoryConnector.hasAttachmentSupport(repository, task)) {
            throw new CoreException((IStatus)new RepositoryStatus(repository.getUrl(), 1, "org.eclipse.mylyn.trac.core", 1, "Attachments are not supported by this repository access type"));
        }
        monitor.beginTask("Uploading attachment", -1);
        try {
            try {
                ITracClient client = this.connector.getClientManager().getRepository(repository);
                int id = Integer.parseInt(task.getTaskId());
                client.putAttachmentData(id, attachment.getFilename(), attachment.getDescription(), attachment.createInputStream());
                if (comment != null && comment.length() > 0) {
                    TracTicket ticket = new TracTicket(id);
                    client.updateTicket(ticket, comment);
                }
            }
            catch (Exception e) {
                throw new CoreException(TracCorePlugin.toStatus(e, repository));
            }
        }
        finally {
            monitor.done();
        }
    }

    public boolean canDownloadAttachment(TaskRepository repository, AbstractTask task) {
        if (repository == null) {
            return false;
        }
        return TracRepositoryConnector.hasAttachmentSupport(repository, task);
    }

    public boolean canUploadAttachment(TaskRepository repository, AbstractTask task) {
        if (repository == null) {
            return false;
        }
        return TracRepositoryConnector.hasAttachmentSupport(repository, task);
    }

    public boolean canDeprecate(TaskRepository repository, RepositoryAttachment attachment) {
        return false;
    }

    public void updateAttachment(TaskRepository repository, RepositoryAttachment attachment) throws CoreException {
        throw new UnsupportedOperationException();
    }
}

