/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.trac.core;

import java.net.MalformedURLException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.internal.trac.core.ITracClient;
import org.eclipse.mylyn.internal.trac.core.TracException;
import org.eclipse.mylyn.internal.trac.core.TracLoginException;
import org.eclipse.mylyn.internal.trac.core.TracWebClient;
import org.eclipse.mylyn.internal.trac.core.TracXmlRpcClient;
import org.eclipse.mylyn.web.core.AbstractWebLocation;

public class TracClientFactory {
    public static ITracClient createClient(AbstractWebLocation location, ITracClient.Version version) {
        if (version == ITracClient.Version.TRAC_0_9) {
            return new TracWebClient(location, version);
        }
        if (version == ITracClient.Version.XML_RPC) {
            return new TracXmlRpcClient(location, version);
        }
        throw new RuntimeException("Invalid repository version: " + (Object)((Object)version));
    }

    public static ITracClient.Version probeClient(AbstractWebLocation location) throws MalformedURLException, TracException {
        try {
            TracXmlRpcClient repository = new TracXmlRpcClient(location, ITracClient.Version.XML_RPC);
            repository.validate((IProgressMonitor)new NullProgressMonitor());
            return ITracClient.Version.XML_RPC;
        }
        catch (TracException e) {
            try {
                TracWebClient repository = new TracWebClient(location, ITracClient.Version.TRAC_0_9);
                repository.validate((IProgressMonitor)new NullProgressMonitor());
                return ITracClient.Version.TRAC_0_9;
            }
            catch (TracLoginException tracLoginException) {
                throw e;
            }
            catch (TracException tracException) {
                throw new TracException();
            }
        }
    }
}

