/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.trac.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.trac.core.AbstractWikiHandler;
import org.eclipse.mylyn.internal.trac.core.ITracClient;
import org.eclipse.mylyn.internal.trac.core.ITracWikiClient;
import org.eclipse.mylyn.internal.trac.core.InvalidTicketException;
import org.eclipse.mylyn.internal.trac.core.TracAttachmentHandler;
import org.eclipse.mylyn.internal.trac.core.TracAttributeFactory;
import org.eclipse.mylyn.internal.trac.core.TracClientManager;
import org.eclipse.mylyn.internal.trac.core.TracCorePlugin;
import org.eclipse.mylyn.internal.trac.core.TracRepositoryQuery;
import org.eclipse.mylyn.internal.trac.core.TracTask;
import org.eclipse.mylyn.internal.trac.core.TracTaskDataHandler;
import org.eclipse.mylyn.internal.trac.core.TracWikiHandler;
import org.eclipse.mylyn.internal.trac.core.model.TracPriority;
import org.eclipse.mylyn.internal.trac.core.model.TracTicket;
import org.eclipse.mylyn.internal.trac.core.util.TracUtils;
import org.eclipse.mylyn.tasks.core.AbstractAttachmentHandler;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.ITaskCollector;
import org.eclipse.mylyn.tasks.core.RepositoryOperation;
import org.eclipse.mylyn.tasks.core.RepositoryStatus;
import org.eclipse.mylyn.tasks.core.RepositoryTaskAttribute;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.TaskRepositoryLocationFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TracRepositoryConnector
extends AbstractRepositoryConnector {
    private static final String CLIENT_LABEL = "Trac (supports 0.9 or 0.10 through Web and XML-RPC)";
    private TracClientManager clientManager;
    private final TracTaskDataHandler taskDataHandler = new TracTaskDataHandler(this);
    private final TracAttachmentHandler attachmentHandler = new TracAttachmentHandler(this);
    private TaskRepositoryLocationFactory taskRepositoryLocationFactory = new TaskRepositoryLocationFactory();
    private File repositoryConfigurationCacheFile;
    private final TracWikiHandler wikiHandler = new TracWikiHandler(this);

    public TracRepositoryConnector(File repositoryConfigurationCacheFile) {
        this.repositoryConfigurationCacheFile = repositoryConfigurationCacheFile;
    }

    public TracRepositoryConnector() {
        if (TracCorePlugin.getDefault() != null) {
            TracCorePlugin.getDefault().setConnector(this);
            IPath path = TracCorePlugin.getDefault().getRepostioryAttributeCachePath();
            this.repositoryConfigurationCacheFile = path.toFile();
        }
    }

    public boolean canCreateNewTask(TaskRepository repository) {
        return true;
    }

    public boolean canCreateTaskFromKey(TaskRepository repository) {
        return true;
    }

    public boolean hasWiki(TaskRepository repository) {
        ITracClient client = this.getClientManager().getRepository(repository);
        return client instanceof ITracWikiClient;
    }

    public AbstractWikiHandler getWikiHandler() {
        return this.wikiHandler;
    }

    public String getLabel() {
        return CLIENT_LABEL;
    }

    public String getConnectorKind() {
        return "trac";
    }

    public String getRepositoryUrlFromTaskUrl(String url) {
        if (url == null) {
            return null;
        }
        int index = url.lastIndexOf("/ticket/");
        return index == -1 ? null : url.substring(0, index);
    }

    public String getTaskIdFromTaskUrl(String url) {
        if (url == null) {
            return null;
        }
        int index = url.lastIndexOf("/ticket/");
        return index == -1 ? null : url.substring(index + "/ticket/".length());
    }

    public String getTaskUrl(String repositoryUrl, String taskId) {
        return String.valueOf(repositoryUrl) + "/ticket/" + taskId;
    }

    public AbstractAttachmentHandler getAttachmentHandler() {
        return this.attachmentHandler;
    }

    public AbstractTaskDataHandler getTaskDataHandler() {
        return this.taskDataHandler;
    }

    public void updateTaskFromRepository(TaskRepository repository, AbstractTask repositoryTask, IProgressMonitor monitor) throws CoreException {
        if (repositoryTask instanceof TracTask) {
            try {
                ITracClient client = this.getClientManager().getRepository(repository);
                TracTicket ticket = client.getTicket(TracRepositoryConnector.getTicketId(repositoryTask.getTaskId()));
                this.updateTaskFromTicket((TracTask)repositoryTask, ticket, false, client);
            }
            catch (Exception e) {
                throw new CoreException(TracCorePlugin.toStatus(e, repository));
            }
        }
    }

    public boolean updateTaskFromQueryHit(TaskRepository repository, AbstractTask existingTask, AbstractTask queryHit) {
        if (TracRepositoryConnector.hasRichEditor(repository)) {
            return false;
        }
        boolean changed = super.updateTaskFromQueryHit(repository, existingTask, queryHit);
        if (existingTask instanceof TracTask) {
            ((TracTask)existingTask).setSupportsSubtasks(false);
        }
        return changed;
    }

    public IStatus performQuery(AbstractRepositoryQuery query, TaskRepository repository, IProgressMonitor monitor, ITaskCollector resultCollector) {
        ArrayList<TracTicket> tickets = new ArrayList<TracTicket>();
        try {
            ITracClient client = this.getClientManager().getRepository(repository);
            if (query instanceof TracRepositoryQuery) {
                client.search(((TracRepositoryQuery)query).getTracSearch(), tickets);
            }
            for (TracTicket ticket : tickets) {
                AbstractTask task = this.createTask(repository.getUrl(), String.valueOf(ticket.getId()), "");
                this.updateTaskFromTicket((TracTask)task, ticket, false, client);
                resultCollector.accept(task);
            }
        }
        catch (Throwable e) {
            return TracCorePlugin.toStatus(e, repository);
        }
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean markStaleTasks(TaskRepository repository, Set<AbstractTask> tasks, IProgressMonitor monitor) throws CoreException {
        try {
            Set<Integer> ids;
            ITracClient client;
            monitor.beginTask("Getting changed tasks", -1);
            if (tasks.isEmpty()) {
                return true;
            }
            if (!TracRepositoryConnector.hasChangedSince(repository)) {
                return true;
            }
            if (repository.getSynchronizationTimeStamp() == null || repository.getSynchronizationTimeStamp().length() == 0) {
                Iterator<AbstractTask> iterator = tasks.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        return true;
                    }
                    AbstractTask task = iterator.next();
                    task.setStale(true);
                }
            }
            Date since = new Date(0L);
            try {
                since = TracUtils.parseDate(Integer.parseInt(repository.getSynchronizationTimeStamp()));
            }
            catch (NumberFormatException numberFormatException) {}
            try {
                client = this.getClientManager().getRepository(repository);
                ids = client.getChangedTickets(since);
                if (ids.isEmpty()) {
                    return false;
                }
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CoreException(TracCorePlugin.toStatus(e, repository));
            }
            {
                Integer id;
                Date lastChanged;
                if (ids.size() == 1 && since.equals(lastChanged = client.getTicketLastChanged(id = ids.iterator().next()))) {
                    return false;
                }
                for (AbstractTask task : tasks) {
                    Integer id2 = TracRepositoryConnector.getTicketId(task.getTaskId());
                    if (!ids.contains(id2)) continue;
                    task.setStale(true);
                }
                return true;
            }
        }
        finally {
            monitor.done();
        }
    }

    public AbstractTask createTaskFromExistingId(TaskRepository repository, String taskId, IProgressMonitor monitor) throws CoreException {
        AbstractTask task = super.createTaskFromExistingId(repository, taskId, monitor);
        if (task == null) {
            try {
                int taskIdInt = TracRepositoryConnector.getTicketId(taskId);
                ITracClient client = this.getClientManager().getRepository(repository);
                TracTicket ticket = client.getTicket(taskIdInt);
                task = this.createTask(repository.getUrl(), taskId, "");
                this.updateTaskFromTicket((TracTask)task, ticket, false, client);
                this.taskList.addTask(task);
            }
            catch (Exception e) {
                throw new CoreException(TracCorePlugin.toStatus(e, repository));
            }
        }
        return task;
    }

    public AbstractTask createTask(String repositoryUrl, String id, String summary) {
        TracTask tracTask = new TracTask(repositoryUrl, id, summary);
        tracTask.setCreationDate(new Date());
        return tracTask;
    }

    public void updateTaskFromTaskData(TaskRepository taskRepository, AbstractTask task, RepositoryTaskData taskData) {
        if (taskData != null && task instanceof TracTask) {
            ITracClient client = this.getClientManager().getRepository(taskRepository);
            task.setSummary(taskData.getSummary());
            task.setOwner(taskData.getAttributeValue("task.common.user.assigned"));
            task.setCompleted(TracTask.isCompleted(taskData.getStatus()));
            task.setUrl(String.valueOf(taskRepository.getUrl()) + "/ticket/" + taskData.getId());
            String priority = taskData.getAttributeValue(TracAttributeFactory.Attribute.PRIORITY.getTracKey());
            TracPriority[] tracPriorities = client.getPriorities();
            task.setPriority(TracTask.getTaskPriority(priority, tracPriorities));
            TracTask.Kind kind = TracTask.Kind.fromType(taskData.getAttributeValue(TracAttributeFactory.Attribute.TYPE.getTracKey()));
            task.setTaskKind(kind != null ? kind.toString() : null);
            ((TracTask)task).setSupportsSubtasks(this.taskDataHandler.canInitializeSubTaskData(null, taskData));
        }
    }

    public static int getTicketId(String taskId) throws CoreException {
        try {
            return Integer.parseInt(taskId);
        }
        catch (NumberFormatException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.trac.core", 0, "Invalid ticket id: " + taskId, (Throwable)e));
        }
    }

    public synchronized TracClientManager getClientManager() {
        if (this.clientManager == null) {
            this.clientManager = new TracClientManager(this.repositoryConfigurationCacheFile, this.taskRepositoryLocationFactory);
        }
        return this.clientManager;
    }

    public void updateTaskFromTicket(TracTask task, TracTicket ticket, boolean notify, ITracClient client) {
        if (ticket.getValue(TracTicket.Key.SUMMARY) != null) {
            task.setSummary(ticket.getValue(TracTicket.Key.SUMMARY));
        }
        task.setCompleted(TracTask.isCompleted(ticket.getValue(TracTicket.Key.STATUS)));
        String priority = ticket.getValue(TracTicket.Key.PRIORITY);
        TracPriority[] tracPriorities = client.getPriorities();
        task.setPriority(TracTask.getTaskPriority(priority, tracPriorities));
        if (ticket.getValue(TracTicket.Key.TYPE) != null) {
            TracTask.Kind kind = TracTask.Kind.fromType(ticket.getValue(TracTicket.Key.TYPE));
            task.setTaskKind(kind != null ? kind.toString() : ticket.getValue(TracTicket.Key.TYPE));
        }
        if (ticket.getCreated() != null) {
            task.setCreationDate(ticket.getCreated());
        }
        task.setSupportsSubtasks(ticket.getCustomValue("blocking") != null);
        if (notify) {
            this.taskList.notifyTaskChanged((AbstractTask)task, false);
        }
    }

    public static boolean hasChangedSince(TaskRepository repository) {
        return ITracClient.Version.XML_RPC.name().equals(repository.getVersion());
    }

    public static boolean hasRichEditor(TaskRepository repository) {
        return ITracClient.Version.XML_RPC.name().equals(repository.getVersion());
    }

    public static boolean hasRichEditor(TaskRepository repository, AbstractTask task) {
        return TracRepositoryConnector.hasRichEditor(repository);
    }

    public static boolean hasAttachmentSupport(TaskRepository repository, AbstractTask task) {
        return ITracClient.Version.XML_RPC.name().equals(repository.getVersion());
    }

    public void stop() {
        if (this.clientManager != null) {
            this.clientManager.writeCache();
        }
    }

    public void updateAttributes(TaskRepository repository, IProgressMonitor monitor) throws CoreException {
        try {
            ITracClient client = this.getClientManager().getRepository(repository);
            client.updateAttributes(monitor, true);
        }
        catch (Exception exception) {
            throw new CoreException((IStatus)RepositoryStatus.createStatus((String)repository.getUrl(), (int)2, (String)"org.eclipse.mylyn.trac.core", (String)"Could not update attributes"));
        }
    }

    public static String getDisplayUsername(TaskRepository repository) {
        if (!repository.hasCredentials()) {
            return "anonymous";
        }
        return repository.getUserName();
    }

    public String getTaskIdPrefix() {
        return "#";
    }

    public static TracTicket getTracTicket(TaskRepository repository, RepositoryTaskData data) throws InvalidTicketException, CoreException {
        String action;
        TracTicket ticket = new TracTicket(TracRepositoryConnector.getTicketId(data.getId()));
        List attributes = data.getAttributes();
        for (RepositoryTaskAttribute attribute : attributes) {
            if (TracAttributeFactory.isInternalAttribute(attribute.getId()) || attribute.isReadOnly()) continue;
            ticket.putValue(attribute.getId(), attribute.getValue());
        }
        StringBuilder sb = new StringBuilder();
        List removeValues = data.getAttributeValues("task.common.removecc");
        List values = data.getAttributeValues("task.common.user.cc");
        for (String user : values) {
            if (removeValues.contains(user)) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(user);
        }
        if (data.getAttributeValue("task.common.newcc").length() > 0) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(data.getAttributeValue("task.common.newcc"));
        }
        if ("1".equals(data.getAttributeValue("task.common.addselfcc"))) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(repository.getUserName());
        }
        ticket.putBuiltinValue(TracTicket.Key.CC, sb.toString());
        RepositoryOperation operation = data.getSelectedOperation();
        if (operation != null && !"leave".equals(action = operation.getKnobName())) {
            if ("accept".equals(action)) {
                ticket.putValue("status", TracTask.Status.ASSIGNED.toStatusString());
                ticket.putValue("owner", TracRepositoryConnector.getDisplayUsername(repository));
            } else if ("resolve".equals(action)) {
                ticket.putValue("status", TracTask.Status.CLOSED.toStatusString());
                ticket.putValue("resolution", operation.getOptionSelection());
            } else if ("reopen".equals(action)) {
                ticket.putValue("status", TracTask.Status.REOPENED.toStatusString());
                ticket.putValue("resolution", "");
            } else if ("reassign".equals(operation.getKnobName())) {
                ticket.putValue("status", TracTask.Status.NEW.toStatusString());
                ticket.putValue("owner", operation.getInputValue());
            }
        }
        return ticket;
    }

    public TaskRepositoryLocationFactory getTaskRepositoryLocationFactory() {
        return this.taskRepositoryLocationFactory;
    }

    public synchronized void setTaskRepositoryLocationFactory(TaskRepositoryLocationFactory taskRepositoryLocationFactory) {
        this.taskRepositoryLocationFactory = taskRepositoryLocationFactory;
        if (this.clientManager != null) {
            this.clientManager.setTaskRepositoryLocationFactory(taskRepositoryLocationFactory);
        }
    }

    public boolean hasCredentialsManagement() {
        return true;
    }
}

