/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.trac.core;

import org.eclipse.mylyn.internal.trac.core.model.TracPriority;
import org.eclipse.mylyn.tasks.core.AbstractTask;

public class TracTask
extends AbstractTask {
    private static int TASK_PRIORITY_LEVELS = 5;
    private boolean supportsSubtasks = false;

    public static String getTaskPriority(String tracPriority) {
        TracPriorityLevel priority;
        if (tracPriority != null && (priority = TracPriorityLevel.fromPriority(tracPriority)) != null) {
            return priority.toPriorityLevel().toString();
        }
        return AbstractTask.PriorityLevel.getDefault().toString();
    }

    public static String getTaskPriority(String priority, TracPriority[] tracPriorities) {
        if (priority != null && tracPriorities != null && tracPriorities.length > 0) {
            int minValue = tracPriorities[0].getValue();
            int range = tracPriorities[tracPriorities.length - 1].getValue() - minValue;
            TracPriority[] tracPriorityArray = tracPriorities;
            int n = tracPriorities.length;
            int n2 = 0;
            while (n2 < n) {
                TracPriority tracPriority = tracPriorityArray[n2];
                if (priority.equals(tracPriority.getName())) {
                    float relativeValue = (float)(tracPriority.getValue() - minValue) / (float)range;
                    int value = (int)(relativeValue * (float)TASK_PRIORITY_LEVELS) + 1;
                    return AbstractTask.PriorityLevel.fromLevel((int)value).toString();
                }
                ++n2;
            }
        }
        return TracTask.getTaskPriority(priority);
    }

    public static boolean isCompleted(String tracStatus) {
        Status status = Status.fromStatus(tracStatus);
        return status == Status.CLOSED;
    }

    public TracTask(String repositoryUrl, String id, String label) {
        super(repositoryUrl, id, label);
        this.setUrl(String.valueOf(repositoryUrl) + "/ticket/" + id);
    }

    public String getConnectorKind() {
        return "trac";
    }

    public boolean isLocal() {
        return false;
    }

    public boolean getSupportsSubtasks() {
        return this.supportsSubtasks;
    }

    public void setSupportsSubtasks(boolean supportsSubtasks) {
        this.supportsSubtasks = supportsSubtasks;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Kind {
        DEFECT,
        ENHANCEMENT,
        TASK;


        public static Kind fromString(String type) {
            if (type == null) {
                return null;
            }
            if (type.equals("Defect")) {
                return DEFECT;
            }
            if (type.equals("Enhancement")) {
                return ENHANCEMENT;
            }
            if (type.equals("Task")) {
                return TASK;
            }
            return null;
        }

        public static Kind fromType(String type) {
            if (type == null) {
                return null;
            }
            if (type.equals("defect")) {
                return DEFECT;
            }
            if (type.equals("enhancement")) {
                return ENHANCEMENT;
            }
            if (type.equals("task")) {
                return TASK;
            }
            return null;
        }

        public String toString() {
            switch (this) {
                case DEFECT: {
                    return "Defect";
                }
                case ENHANCEMENT: {
                    return "Enhancement";
                }
                case TASK: {
                    return "Task";
                }
            }
            return "";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        ASSIGNED,
        CLOSED,
        NEW,
        REOPENED;


        public static Status fromStatus(String status) {
            if (status == null) {
                return null;
            }
            if (status.equals("new")) {
                return NEW;
            }
            if (status.equals("assigned")) {
                return ASSIGNED;
            }
            if (status.equals("reopened")) {
                return REOPENED;
            }
            if (status.equals("closed")) {
                return CLOSED;
            }
            return null;
        }

        public String toStatusString() {
            switch (this) {
                case NEW: {
                    return "new";
                }
                case ASSIGNED: {
                    return "assigned";
                }
                case REOPENED: {
                    return "reopened";
                }
                case CLOSED: {
                    return "closed";
                }
            }
            return "";
        }

        public String toString() {
            switch (this) {
                case NEW: {
                    return "New";
                }
                case ASSIGNED: {
                    return "Assigned";
                }
                case REOPENED: {
                    return "Reopened";
                }
                case CLOSED: {
                    return "Closed";
                }
            }
            return "";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TracPriorityLevel {
        BLOCKER,
        CRITICAL,
        MAJOR,
        MINOR,
        TRIVIAL;


        public static TracPriorityLevel fromPriority(String priority) {
            if (priority == null) {
                return null;
            }
            if (priority.equals("blocker")) {
                return BLOCKER;
            }
            if (priority.equals("critical")) {
                return CRITICAL;
            }
            if (priority.equals("major")) {
                return MAJOR;
            }
            if (priority.equals("minor")) {
                return MINOR;
            }
            if (priority.equals("trivial")) {
                return TRIVIAL;
            }
            return null;
        }

        public AbstractTask.PriorityLevel toPriorityLevel() {
            switch (this) {
                case BLOCKER: {
                    return AbstractTask.PriorityLevel.P1;
                }
                case CRITICAL: {
                    return AbstractTask.PriorityLevel.P2;
                }
                case MAJOR: {
                    return AbstractTask.PriorityLevel.P3;
                }
                case MINOR: {
                    return AbstractTask.PriorityLevel.P4;
                }
                case TRIVIAL: {
                    return AbstractTask.PriorityLevel.P5;
                }
            }
            return null;
        }

        public String toString() {
            switch (this) {
                case BLOCKER: {
                    return "blocker";
                }
                case CRITICAL: {
                    return "critical";
                }
                case MAJOR: {
                    return "major";
                }
                case MINOR: {
                    return "minor";
                }
                case TRIVIAL: {
                    return "trivial";
                }
            }
            return null;
        }
    }
}

