/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.trac.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.mylyn.internal.trac.core.ITracClient;
import org.eclipse.mylyn.internal.trac.core.TracAttributeFactory;
import org.eclipse.mylyn.internal.trac.core.TracCorePlugin;
import org.eclipse.mylyn.internal.trac.core.TracRepositoryConnector;
import org.eclipse.mylyn.internal.trac.core.TracTask;
import org.eclipse.mylyn.internal.trac.core.model.TracAttachment;
import org.eclipse.mylyn.internal.trac.core.model.TracComment;
import org.eclipse.mylyn.internal.trac.core.model.TracTicket;
import org.eclipse.mylyn.internal.trac.core.model.TracTicketField;
import org.eclipse.mylyn.internal.trac.core.util.TracUtils;
import org.eclipse.mylyn.tasks.core.AbstractAttributeFactory;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.RepositoryAttachment;
import org.eclipse.mylyn.tasks.core.RepositoryOperation;
import org.eclipse.mylyn.tasks.core.RepositoryStatus;
import org.eclipse.mylyn.tasks.core.RepositoryTaskAttribute;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;
import org.eclipse.mylyn.tasks.core.TaskComment;
import org.eclipse.mylyn.tasks.core.TaskRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TracTaskDataHandler
extends AbstractTaskDataHandler {
    public static final String ATTRIBUTE_BLOCKED_BY = "blockedby";
    public static final String ATTRIBUTE_BLOCKING = "blocking";
    private static final String CC_DELIMETER = ", ";
    private AbstractAttributeFactory attributeFactory = new TracAttributeFactory();
    private TracRepositoryConnector connector;

    public TracTaskDataHandler(TracRepositoryConnector connector) {
        this.connector = connector;
    }

    public RepositoryTaskData getTaskData(TaskRepository repository, String taskId, IProgressMonitor monitor) throws CoreException {
        return this.downloadTaskData(repository, TracRepositoryConnector.getTicketId(taskId));
    }

    public RepositoryTaskData downloadTaskData(TaskRepository repository, int id) throws CoreException {
        if (!TracRepositoryConnector.hasRichEditor(repository)) {
            return null;
        }
        try {
            RepositoryTaskData data = new RepositoryTaskData(this.attributeFactory, "trac", repository.getUrl(), String.valueOf(id));
            ITracClient client = this.connector.getClientManager().getRepository(repository);
            client.updateAttributes((IProgressMonitor)new NullProgressMonitor(), false);
            TracTicket ticket = client.getTicket(id);
            TracTaskDataHandler.createDefaultAttributes(this.attributeFactory, data, client, true);
            TracTaskDataHandler.updateTaskData(repository, this.attributeFactory, data, ticket);
            return data;
        }
        catch (OperationCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CoreException(TracCorePlugin.toStatus(e, repository));
        }
    }

    public AbstractAttributeFactory getAttributeFactory(String repositoryUrl, String repositoryKind, String taskKind) {
        return this.attributeFactory;
    }

    public AbstractAttributeFactory getAttributeFactory(RepositoryTaskData taskData) {
        return this.getAttributeFactory(taskData.getRepositoryUrl(), taskData.getRepositoryKind(), taskData.getTaskKind());
    }

    public static void updateTaskData(TaskRepository repository, AbstractAttributeFactory factory, RepositoryTaskData data, TracTicket ticket) {
        String[] actions;
        TracAttachment[] attachments;
        if (ticket.getCreated() != null) {
            data.setAttributeValue(TracAttributeFactory.Attribute.TIME.getTracKey(), String.valueOf(TracUtils.toTracTime(ticket.getCreated())));
        }
        Date lastChanged = ticket.getLastChanged();
        Map<String, String> valueByKey = ticket.getValues();
        for (String key : valueByKey.keySet()) {
            if (TracTicket.Key.CC.getKey().equals(key)) {
                StringTokenizer t = new StringTokenizer(valueByKey.get(key), CC_DELIMETER);
                while (t.hasMoreTokens()) {
                    data.addAttributeValue(key, t.nextToken());
                }
                continue;
            }
            data.setAttributeValue(key, valueByKey.get(key));
        }
        TracComment[] comments = ticket.getComments();
        if (comments != null) {
            int i = 0;
            while (i < comments.length) {
                if ("comment".equals(comments[i].getField()) && !"".equals(comments[i].getNewValue())) {
                    TaskComment taskComment = new TaskComment(factory, data.getComments().size() + 1);
                    taskComment.setAttributeValue("task.common.comment.author", comments[i].getAuthor());
                    taskComment.setAttributeValue("task.common.comment.date", comments[i].getCreated().toString());
                    taskComment.setAttributeValue("task.common.comment.text", comments[i].getNewValue());
                    data.addComment(taskComment);
                }
                ++i;
            }
        }
        if ((attachments = ticket.getAttachments()) != null) {
            int i = 0;
            while (i < attachments.length) {
                RepositoryAttachment taskAttachment = new RepositoryAttachment(factory);
                taskAttachment.setCreator(attachments[i].getAuthor());
                taskAttachment.setRepositoryKind("trac");
                taskAttachment.setRepositoryUrl(repository.getUrl());
                taskAttachment.setTaskId("" + ticket.getId());
                taskAttachment.setAttributeValue(TracAttributeFactory.Attribute.DESCRIPTION.getTracKey(), attachments[i].getDescription());
                taskAttachment.setAttributeValue("filename", attachments[i].getFilename());
                taskAttachment.setAttributeValue("task.common.attachment.size", String.valueOf(attachments[i].getSize()));
                taskAttachment.setAttributeValue("task.common.user.owner", attachments[i].getAuthor());
                if (attachments[i].getCreated() != null) {
                    if (lastChanged == null || attachments[i].getCreated().after(lastChanged)) {
                        lastChanged = attachments[i].getCreated();
                    }
                    taskAttachment.setAttributeValue("task.common.attachment.date", attachments[i].getCreated().toString());
                }
                taskAttachment.setAttributeValue("task.common.attachment.url", String.valueOf(repository.getUrl()) + "/attachment/ticket/" + ticket.getId() + "/" + attachments[i].getFilename());
                taskAttachment.setAttributeValue("task.common.attachment.id", String.valueOf(i));
                data.addAttachment(taskAttachment);
                ++i;
            }
        }
        if ((actions = ticket.getActions()) != null) {
            ArrayList<String> actionList = new ArrayList<String>((Collection)Arrays.asList(actions));
            TracTaskDataHandler.addOperation(repository, data, ticket, actionList, "leave");
            TracTaskDataHandler.addOperation(repository, data, ticket, actionList, "accept");
            TracTaskDataHandler.addOperation(repository, data, ticket, actionList, "resolve");
            TracTaskDataHandler.addOperation(repository, data, ticket, actionList, "reassign");
            TracTaskDataHandler.addOperation(repository, data, ticket, actionList, "reopen");
        }
        if (lastChanged != null) {
            data.setAttributeValue(TracAttributeFactory.Attribute.CHANGE_TIME.getTracKey(), String.valueOf(TracUtils.toTracTime(lastChanged)));
        }
    }

    private static void addOperation(TaskRepository repository, RepositoryTaskData data, TracTicket ticket, List<String> actions, String action) {
        if (!actions.remove(action)) {
            return;
        }
        RepositoryOperation operation = null;
        if ("leave".equals(action)) {
            operation = new RepositoryOperation(action, "Leave as " + data.getStatus() + " " + data.getResolution());
            operation.setChecked(true);
        } else if ("accept".equals(action)) {
            operation = new RepositoryOperation(action, "Accept");
        } else if ("resolve".equals(action)) {
            operation = new RepositoryOperation(action, "Resolve as");
            operation.setUpOptions("resolution");
            String[] stringArray = ticket.getResolutions();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String resolution = stringArray[n2];
                operation.addOption(resolution, resolution);
                ++n2;
            }
        } else if ("reassign".equals(action)) {
            operation = new RepositoryOperation(action, "Reassign to");
            operation.setInputName("owner");
            operation.setInputValue(TracRepositoryConnector.getDisplayUsername(repository));
        } else if ("reopen".equals(action)) {
            operation = new RepositoryOperation(action, "Reopen");
        }
        if (operation != null) {
            data.addOperation(operation);
        }
    }

    public static void createDefaultAttributes(AbstractAttributeFactory factory, RepositoryTaskData data, ITracClient client, boolean existingTask) {
        TracTicketField[] fields = client.getTicketFields();
        if (existingTask) {
            TracTaskDataHandler.createAttribute(factory, data, TracAttributeFactory.Attribute.STATUS, client.getTicketStatus());
            TracTaskDataHandler.createAttribute(factory, data, TracAttributeFactory.Attribute.RESOLUTION, client.getTicketResolutions());
        }
        TracTaskDataHandler.createAttribute(factory, data, TracAttributeFactory.Attribute.COMPONENT, client.getComponents());
        TracTaskDataHandler.createAttribute(factory, data, TracAttributeFactory.Attribute.VERSION, client.getVersions(), true);
        TracTaskDataHandler.createAttribute(factory, data, TracAttributeFactory.Attribute.PRIORITY, client.getPriorities());
        TracTaskDataHandler.createAttribute(factory, data, TracAttributeFactory.Attribute.SEVERITY, client.getSeverities());
        TracTaskDataHandler.createAttribute(factory, data, TracAttributeFactory.Attribute.TYPE, client.getTicketTypes());
        RepositoryTaskAttribute attribute = TracTaskDataHandler.createAttribute(factory, data, TracAttributeFactory.Attribute.OWNER);
        if (!existingTask) {
            attribute.setReadOnly(false);
        }
        TracTaskDataHandler.createAttribute(factory, data, TracAttributeFactory.Attribute.MILESTONE, client.getMilestones(), true);
        if (existingTask) {
            TracTaskDataHandler.createAttribute(factory, data, TracAttributeFactory.Attribute.REPORTER);
        }
        if (existingTask) {
            TracTaskDataHandler.createAttribute(factory, data, TracAttributeFactory.Attribute.NEW_CC);
        }
        TracTaskDataHandler.createAttribute(factory, data, TracAttributeFactory.Attribute.CC);
        TracTaskDataHandler.createAttribute(factory, data, TracAttributeFactory.Attribute.KEYWORDS);
        if (!existingTask) {
            TracTaskDataHandler.createAttribute(factory, data, TracAttributeFactory.Attribute.SUMMARY);
            TracTaskDataHandler.createAttribute(factory, data, TracAttributeFactory.Attribute.DESCRIPTION);
        }
        if (fields != null) {
            TracTicketField[] tracTicketFieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                TracTicketField field = tracTicketFieldArray[n2];
                if (field.isCustom()) {
                    TracTaskDataHandler.createAttribute(data, field);
                }
                ++n2;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void createAttribute(RepositoryTaskData data, TracTicketField field) {
        block16: {
            attr = new RepositoryTaskAttribute(field.getName(), field.getLabel(), false);
            if (field.getType() == TracTicketField.Type.CHECKBOX) {
                attr.addOption("1", "1");
                attr.addOption("0", "0");
                if (field.getDefaultValue() != null) {
                    attr.setValue(field.getDefaultValue());
                }
            } else if (field.getType() == TracTicketField.Type.SELECT || field.getType() == TracTicketField.Type.RADIO) {
                values = field.getOptions();
                if (values != null && values.length > 0) {
                    if (field.isOptional()) {
                        attr.addOption("", "");
                    }
                    i = 0;
                    while (i < values.length) {
                        attr.addOption(values[i], values[i]);
                        ++i;
                    }
                    if (field.getDefaultValue() != null) {
                        try {
                            index = Integer.parseInt(field.getDefaultValue());
                            if (index > 0 && index < values.length) {
                                attr.setValue(values[index]);
                            }
                            break block16;
                        }
                        catch (NumberFormatException v0) {
                            i = 0;
                            ** while (i < values.length)
                        }
lbl-1000:
                        // 1 sources

                        {
                            if (field.getDefaultValue().equals(values[i].toString())) {
                                attr.setValue(values[i]);
                            } else {
                                ++i;
                                continue;
                            }
lbl32:
                            // 1 sources

                        }
                    }
                }
            } else if (field.getDefaultValue() != null) {
                attr.setValue(field.getDefaultValue());
            }
        }
        data.addAttribute(attr.getId(), attr);
    }

    private static RepositoryTaskAttribute createAttribute(AbstractAttributeFactory factory, RepositoryTaskData data, TracAttributeFactory.Attribute attribute, Object[] values, boolean allowEmtpy) {
        RepositoryTaskAttribute attr = factory.createAttribute(attribute.getTracKey());
        if (values != null && values.length > 0) {
            if (allowEmtpy) {
                attr.addOption("", "");
            }
            int i = 0;
            while (i < values.length) {
                attr.addOption(values[i].toString(), values[i].toString());
                ++i;
            }
        } else {
            attr.setHidden(true);
            attr.setReadOnly(true);
        }
        data.addAttribute(attribute.getTracKey(), attr);
        return attr;
    }

    private static RepositoryTaskAttribute createAttribute(AbstractAttributeFactory factory, RepositoryTaskData data, TracAttributeFactory.Attribute attribute) {
        RepositoryTaskAttribute attr = factory.createAttribute(attribute.getTracKey());
        data.addAttribute(attribute.getTracKey(), attr);
        return attr;
    }

    private static RepositoryTaskAttribute createAttribute(AbstractAttributeFactory factory, RepositoryTaskData data, TracAttributeFactory.Attribute attribute, Object[] values) {
        return TracTaskDataHandler.createAttribute(factory, data, attribute, values, false);
    }

    public String postTaskData(TaskRepository repository, RepositoryTaskData taskData, IProgressMonitor monitor) throws CoreException {
        try {
            TracTicket ticket = TracRepositoryConnector.getTracTicket(repository, taskData);
            ITracClient server = this.connector.getClientManager().getRepository(repository);
            if (taskData.isNew()) {
                int id = server.createTicket(ticket);
                return String.valueOf(id);
            }
            server.updateTicket(ticket, taskData.getNewComment());
            return null;
        }
        catch (OperationCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CoreException(TracCorePlugin.toStatus(e, repository));
        }
    }

    public boolean initializeTaskData(TaskRepository repository, RepositoryTaskData data, IProgressMonitor monitor) throws CoreException {
        try {
            ITracClient client = this.connector.getClientManager().getRepository(repository);
            client.updateAttributes((IProgressMonitor)new NullProgressMonitor(), false);
            TracTaskDataHandler.createDefaultAttributes(this.attributeFactory, data, client, false);
            return true;
        }
        catch (OperationCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CoreException(TracCorePlugin.toStatus(e, repository));
        }
    }

    public boolean initializeSubTaskData(TaskRepository repository, RepositoryTaskData taskData, RepositoryTaskData parentTaskData, IProgressMonitor monitor) throws CoreException {
        this.initializeTaskData(repository, taskData, monitor);
        RepositoryTaskAttribute attribute = taskData.getAttribute(ATTRIBUTE_BLOCKING);
        if (attribute == null) {
            throw new CoreException((IStatus)new RepositoryStatus(repository, 4, "org.eclipse.mylyn.trac.core", 1, "The repository does not support subtasks"));
        }
        this.cloneTaskData(parentTaskData, taskData);
        taskData.setDescription("");
        taskData.setSummary("");
        attribute.setValue(parentTaskData.getId());
        return true;
    }

    public Set<String> getSubTaskIds(RepositoryTaskData taskData) {
        RepositoryTaskAttribute attribute = taskData.getAttribute(ATTRIBUTE_BLOCKED_BY);
        if (attribute != null) {
            HashSet<String> result = new HashSet<String>();
            StringTokenizer t = new StringTokenizer(attribute.getValue(), CC_DELIMETER);
            while (t.hasMoreTokens()) {
                result.add(t.nextToken());
            }
            return result;
        }
        return Collections.emptySet();
    }

    public boolean canInitializeSubTaskData(AbstractTask task, RepositoryTaskData parentTaskData) {
        if (parentTaskData != null) {
            return parentTaskData.getAttribute(ATTRIBUTE_BLOCKED_BY) != null;
        }
        if (task instanceof TracTask) {
            return ((TracTask)task).getSupportsSubtasks();
        }
        return false;
    }
}

