/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.trac.core.model;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.trac.core.model.TracSearchFilter;
import org.eclipse.mylyn.monitor.core.StatusHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TracSearch {
    private Map<String, TracSearchFilter> filterByFieldName = new LinkedHashMap<String, TracSearchFilter>();
    private String orderBy;
    private boolean ascending = true;

    public TracSearch(String queryParameter) {
        this.fromUrl(queryParameter);
    }

    public TracSearch() {
    }

    public void addFilter(String key, String value) {
        TracSearchFilter filter = this.filterByFieldName.get(key);
        if (filter == null) {
            filter = new TracSearchFilter(key);
            TracSearchFilter.CompareOperator operator = TracSearchFilter.CompareOperator.fromUrl(value);
            filter.setOperator(operator);
            this.filterByFieldName.put(key, filter);
        }
        filter.addValue(value.substring(filter.getOperator().getQueryValue().length()));
    }

    public void addFilter(TracSearchFilter filter) {
        this.filterByFieldName.put(filter.getFieldName(), filter);
    }

    public List<TracSearchFilter> getFilters() {
        return new ArrayList<TracSearchFilter>(this.filterByFieldName.values());
    }

    public void setAscending(boolean ascending) {
        this.ascending = ascending;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public String toQuery() {
        StringBuilder sb = new StringBuilder();
        if (this.orderBy != null) {
            sb.append("&order=");
            sb.append(this.orderBy);
            if (!this.ascending) {
                sb.append("&desc=1");
            }
        }
        for (TracSearchFilter filter : this.filterByFieldName.values()) {
            sb.append("&");
            sb.append(filter.getFieldName());
            sb.append(filter.getOperator().getQueryValue());
            sb.append("=");
            List<String> values = filter.getValues();
            Iterator<String> it = values.iterator();
            while (it.hasNext()) {
                sb.append(it.next());
                if (!it.hasNext()) continue;
                sb.append("|");
            }
        }
        return sb.toString();
    }

    public String toUrl() {
        StringBuilder sb = new StringBuilder();
        if (this.orderBy != null) {
            sb.append("&order=");
            sb.append(this.orderBy);
            if (!this.ascending) {
                sb.append("&desc=1");
            }
        } else if (this.filterByFieldName.isEmpty()) {
            sb.append("&order=id");
        }
        for (TracSearchFilter filter : this.filterByFieldName.values()) {
            for (String value : filter.getValues()) {
                sb.append("&");
                sb.append(filter.getFieldName());
                sb.append("=");
                try {
                    sb.append(URLEncoder.encode(filter.getOperator().getQueryValue(), "UTF-8"));
                    sb.append(URLEncoder.encode(value, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.trac.core", "Unexpected exception while decoding URL", (Throwable)e));
                }
            }
        }
        return sb.toString();
    }

    public void fromUrl(String url) {
        StringTokenizer t = new StringTokenizer(url, "&");
        while (t.hasMoreTokens()) {
            String token = t.nextToken();
            int i = token.indexOf("=");
            if (i == -1) continue;
            try {
                String key = URLDecoder.decode(token.substring(0, i), "UTF-8");
                String value = URLDecoder.decode(token.substring(i + 1), "UTF-8");
                if ("order".equals(key)) {
                    this.setOrderBy(value);
                    continue;
                }
                if ("desc".equals(key)) {
                    this.setAscending(!"1".equals(value));
                    continue;
                }
                if ("group".equals(key) || "groupdesc".equals(key) || "verbose".equals(key)) continue;
                this.addFilter(key, value);
            }
            catch (UnsupportedEncodingException e) {
                StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.trac.core", "Unexpected exception while decoding URL", (Throwable)e));
            }
        }
    }
}

