/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.trac.core.util;

import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientException;
import org.apache.xmlrpc.client.XmlRpcHttpClientConfig;
import org.apache.xmlrpc.client.XmlRpcHttpTransport;
import org.apache.xmlrpc.client.XmlRpcStreamTransport;
import org.apache.xmlrpc.client.XmlRpcTransport;
import org.apache.xmlrpc.client.XmlRpcTransportFactory;
import org.apache.xmlrpc.common.XmlRpcStreamRequestConfig;
import org.apache.xmlrpc.util.HttpUtil;
import org.apache.xmlrpc.util.XmlRpcIOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.mylyn.internal.trac.core.util.TracXmlRpcClientRequest;
import org.eclipse.mylyn.web.core.AbstractWebLocation;
import org.eclipse.mylyn.web.core.WebClientUtil;
import org.xml.sax.SAXException;

public class TracHttpClientTransportFactory
implements XmlRpcTransportFactory {
    protected static final String USER_AGENT = "TracConnector Apache XML-RPC/3.0";
    private final XmlRpcClient xmlRpcClient;
    private Cookie[] cookies;
    private AbstractWebLocation location;
    private final HttpClient httpClient;

    public TracHttpClientTransportFactory(XmlRpcClient xmlRpcClient, HttpClient httpClient) {
        this.xmlRpcClient = xmlRpcClient;
        this.httpClient = httpClient;
    }

    public Cookie[] getCookies() {
        return this.cookies;
    }

    public AbstractWebLocation getLocation() {
        return this.location;
    }

    public XmlRpcTransport getTransport() {
        return new TracHttpClientTransport(this.xmlRpcClient, this.httpClient, this.location, this.cookies);
    }

    public void setCookies(Cookie[] cookies) {
        this.cookies = cookies;
    }

    public void setLocation(AbstractWebLocation location) {
        this.location = location;
    }

    public static class TracHttpClientTransport
    extends XmlRpcHttpTransport {
        private final HttpClient httpClient;
        private final AbstractWebLocation location;
        private final Cookie[] cookies;
        private PostMethod method;
        private int contentLength = -1;
        private XmlRpcHttpClientConfig config;
        private IProgressMonitor monitor;
        private HostConfiguration hostConfiguration;

        public TracHttpClientTransport(XmlRpcClient client, HttpClient httpClient, AbstractWebLocation location, Cookie[] cookies) {
            super(client, "");
            this.httpClient = httpClient;
            this.location = location;
            this.cookies = cookies;
        }

        protected void close() throws XmlRpcClientException {
            this.method.releaseConnection();
        }

        public int getContentLength() {
            return this.contentLength;
        }

        protected InputStream getInputStream() throws XmlRpcException {
            int responseCode = this.method.getStatusCode();
            if (responseCode != 200) {
                throw new TracHttpException(responseCode);
            }
            try {
                return this.method.getResponseBodyAsStream();
            }
            catch (HttpException e) {
                throw new XmlRpcClientException("Error in HTTP transport: " + e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                throw new XmlRpcClientException("I/O error in server communication: " + e.getMessage(), (Throwable)e);
            }
        }

        protected String getUserAgent() {
            return WebClientUtil.USER_AGENT;
        }

        protected void initHttpHeaders(XmlRpcRequest request) throws XmlRpcClientException {
            this.config = (XmlRpcHttpClientConfig)request.getConfig();
            if (request instanceof TracXmlRpcClientRequest) {
                TracXmlRpcClientRequest tracRequest = (TracXmlRpcClientRequest)request;
                this.monitor = tracRequest.getProgressMonitor();
            } else {
                this.monitor = null;
            }
            String url = this.config.getServerURL().toString();
            this.hostConfiguration = WebClientUtil.createHostConfiguration((HttpClient)this.httpClient, (String)"Apache XML RPC 3.0", (AbstractWebLocation)this.location, (IProgressMonitor)this.monitor);
            if (this.cookies != null) {
                this.httpClient.getState().addCookies(this.cookies);
            }
            this.method = new PostMethod(WebClientUtil.getRequestPath((String)url));
            super.initHttpHeaders(request);
            if (this.config.getConnectionTimeout() != 0) {
                this.httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(this.config.getConnectionTimeout());
            }
            if (this.config.getReplyTimeout() != 0) {
                this.httpClient.getHttpConnectionManager().getParams().setSoTimeout(this.config.getConnectionTimeout());
            }
            this.method.getParams().setVersion(HttpVersion.HTTP_1_1);
        }

        protected boolean isResponseGzipCompressed(XmlRpcStreamRequestConfig config) {
            Header header = this.method.getResponseHeader("Content-Encoding");
            return header != null && HttpUtil.isUsingGzipEncoding((String)header.getValue());
        }

        protected void setContentLength(int contentLength) {
            this.contentLength = contentLength;
        }

        protected void setCredentials(XmlRpcHttpClientConfig config) throws XmlRpcClientException {
            String userName = config.getBasicUserName();
            if (userName != null) {
                String encoding = config.getBasicEncoding();
                if (encoding == null) {
                    encoding = "UTF-8";
                }
                this.httpClient.getParams().setParameter("http.protocol.credential-charset", (Object)encoding);
                UsernamePasswordCredentials creds = new UsernamePasswordCredentials(userName, config.getBasicPassword());
                AuthScope scope = new AuthScope(null, -1, null, AuthScope.ANY_SCHEME);
                this.httpClient.getState().setCredentials(scope, (Credentials)creds);
                this.httpClient.getParams().setAuthenticationPreemptive(true);
            }
        }

        protected void setRequestHeader(String header, String value) {
            this.method.setRequestHeader(new Header(header, value));
        }

        protected void writeRequest(final XmlRpcStreamTransport.ReqWriter writer) throws XmlRpcException {
            this.method.setRequestEntity(new RequestEntity(){

                public long getContentLength() {
                    return TracHttpClientTransport.this.getContentLength();
                }

                public String getContentType() {
                    return "text/xml";
                }

                public boolean isRepeatable() {
                    return this.getContentLength() != -1L;
                }

                public void writeRequest(OutputStream pOut) throws IOException {
                    try {
                        FilterOutputStream ostream = TracHttpClientTransport.this.isUsingByteArrayOutput(TracHttpClientTransport.this.config) ? new FilterOutputStream(pOut){

                            public void close() throws IOException {
                                this.flush();
                            }
                        } : new BufferedOutputStream(pOut){

                            public void close() throws IOException {
                                this.flush();
                            }
                        };
                        writer.write((OutputStream)ostream);
                    }
                    catch (XmlRpcException e) {
                        throw new XmlRpcIOException((Throwable)e);
                    }
                    catch (SAXException e) {
                        throw new XmlRpcIOException((Throwable)e);
                    }
                }
            });
            try {
                WebClientUtil.execute((HttpClient)this.httpClient, (HostConfiguration)this.hostConfiguration, (HttpMethod)this.method, (IProgressMonitor)this.monitor);
            }
            catch (InterruptedIOException interruptedIOException) {
                throw new OperationCanceledException();
            }
            catch (XmlRpcIOException e) {
                Throwable t = e.getLinkedException();
                if (t instanceof XmlRpcException) {
                    throw (XmlRpcException)t;
                }
                throw new XmlRpcException("Unexpected exception: " + t.getMessage(), t);
            }
            catch (IOException e) {
                throw new XmlRpcException("I/O error while communicating with HTTP server: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static class TracHttpException
    extends XmlRpcException {
        private static final long serialVersionUID = 9032521978140685830L;

        public TracHttpException(int responseCode) {
            super(responseCode, "HTTP Error " + responseCode);
        }
    }
}

