/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.trac.ui.wizard;

import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.internal.trac.core.TracRepositoryQuery;
import org.eclipse.mylyn.internal.trac.ui.wizard.TracCustomQueryPage;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;

public class NewTracQueryWizard
extends Wizard {
    private static final String TITLE = "New Trac Query";
    private final TaskRepository repository;
    private TracCustomQueryPage queryPage;

    public NewTracQueryWizard(TaskRepository repository) {
        this.repository = repository;
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(TITLE);
        this.setDefaultPageImageDescriptor(TasksUiImages.BANNER_REPOSITORY);
    }

    public void addPages() {
        this.queryPage = new TracCustomQueryPage(this.repository);
        this.queryPage.setWizard((IWizard)this);
        this.addPage((IWizardPage)this.queryPage);
    }

    public boolean canFinish() {
        return this.queryPage.isPageComplete();
    }

    public boolean performFinish() {
        TracRepositoryQuery query = this.queryPage.getQuery();
        if (query != null) {
            TasksUiPlugin.getTaskListManager().getTaskList().addQuery((AbstractRepositoryQuery)query);
            AbstractRepositoryConnector connector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector(this.repository.getConnectorKind());
            if (connector != null) {
                TasksUiPlugin.getSynchronizationManager().synchronize(connector, (AbstractRepositoryQuery)query, null, true);
            }
        }
        return true;
    }
}

