/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.trac.ui.wizard;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.internal.trac.core.ITracClient;
import org.eclipse.mylyn.internal.trac.core.TracCorePlugin;
import org.eclipse.mylyn.internal.trac.core.TracException;
import org.eclipse.mylyn.internal.trac.core.TracRepositoryConnector;
import org.eclipse.mylyn.internal.trac.core.TracTaskDataHandler;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractAttributeFactory;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class NewTracTaskPage
extends WizardPage {
    private TaskRepository taskRepository;
    private RepositoryTaskData taskData;

    public NewTracTaskPage(TaskRepository taskRepository) {
        super("New Task");
        this.setTitle("Create via Rich Editor");
        this.setDescription("This will open an editor that can be used to create a new task.");
        this.taskRepository = taskRepository;
    }

    public void createControl(Composite parent) {
        Text text = new Text(parent, 64);
        text.setEditable(false);
        this.setControl((Control)text);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.updateAttributesFromRepository();
    }

    public boolean isPageComplete() {
        return this.taskData != null;
    }

    private void updateAttributesFromRepository() {
        TracRepositoryConnector connector = (TracRepositoryConnector)TasksUiPlugin.getRepositoryManager().getRepositoryConnector("trac");
        final ITracClient client = connector.getClientManager().getRepository(this.taskRepository);
        if (!client.hasAttributes()) {
            try {
                IRunnableWithProgress runnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            client.updateAttributes(monitor, true);
                        }
                        catch (TracException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                };
                this.getContainer().run(true, true, runnable);
            }
            catch (InvocationTargetException e) {
                StatusHandler.displayStatus((String)"Error updating attributes", (IStatus)TracCorePlugin.toStatus((Throwable)e.getCause(), (TaskRepository)this.taskRepository));
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
        TracTaskDataHandler offlineHandler = (TracTaskDataHandler)connector.getTaskDataHandler();
        AbstractAttributeFactory attributeFactory = offlineHandler.getAttributeFactory(this.taskRepository.getUrl(), this.taskRepository.getConnectorKind(), "task");
        this.taskData = new RepositoryTaskData(attributeFactory, "trac", this.taskRepository.getUrl(), TasksUiPlugin.getDefault().getNextNewRepositoryTaskId());
        this.taskData.setNew(true);
        TracTaskDataHandler.createDefaultAttributes((AbstractAttributeFactory)this.taskData.getAttributeFactory(), (RepositoryTaskData)this.taskData, (ITracClient)client, (boolean)false);
    }

    public RepositoryTaskData getRepositoryTaskData() {
        return this.taskData;
    }
}

