/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.trac.ui.wizard;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.internal.trac.core.TracRepositoryQuery;
import org.eclipse.mylyn.internal.trac.core.model.TracSearch;
import org.eclipse.mylyn.internal.trac.core.model.TracSearchFilter;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class TracQueryWizardPage
extends WizardPage {
    private static final String TITLE = "New Trac Query";
    private static final String DESCRIPTION = "Add search filters to define query.";
    private static final String TITLE_QUERY_TITLE = "Query Title";
    private TaskRepository repository;
    private TracRepositoryQuery query;
    private Text titleText;
    private Composite scrollComposite;
    private Set<SearchField> visibleSearchFields = new LinkedHashSet<SearchField>();
    private List<SearchField> searchFields;

    public TracQueryWizardPage(TaskRepository repository, AbstractRepositoryQuery query) {
        super(TITLE);
        this.repository = repository;
        this.query = (TracRepositoryQuery)query;
        this.setTitle(TITLE);
        this.setDescription(DESCRIPTION);
    }

    public TracQueryWizardPage(TaskRepository repository) {
        this(repository, null);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData());
        composite.setLayout((Layout)new GridLayout(1, false));
        this.createTitleGroup(composite);
        ScrolledComposite scrolledComposite = new ScrolledComposite(composite, 2560);
        GridData gd = new GridData(4, 4, true, true);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setLayoutData((Object)gd);
        this.scrollComposite = new Composite((Composite)scrolledComposite, 0);
        scrolledComposite.setContent((Control)this.scrollComposite);
        this.scrollComposite.setLayout((Layout)new GridLayout(4, false));
        this.createAddFilterGroup(composite);
        if (this.query != null) {
            this.titleText.setText(this.query.getSummary());
            this.restoreSearchFilterFromQuery(this.query);
        }
        this.setControl((Control)composite);
    }

    private void restoreSearchFilterFromQuery(TracRepositoryQuery query) {
        TracSearch search = query.getTracSearch();
        List filters = search.getFilters();
        for (TracSearchFilter filter : filters) {
            SearchField field = this.getSearchField(filter.getFieldName());
            if (field != null) {
                this.showSearchField(field, filter);
                continue;
            }
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.trac.ui", "Ignoring invalid search filter: " + filter));
        }
    }

    private SearchField getSearchField(String fieldName) {
        for (SearchField searchField : this.searchFields) {
            if (!searchField.getFieldName().equals(fieldName)) continue;
            return searchField;
        }
        return null;
    }

    private void createAddFilterGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        GridData gd = new GridData(769);
        composite.setLayoutData((Object)gd);
        Label label = new Label(composite, 16384);
        label.setText("Select to add filter: ");
        final Combo filterCombo = new Combo(composite, 2060);
        this.searchFields = new ArrayList<SearchField>();
        this.searchFields.add(new TextSearchField("summary", "Summary"));
        this.searchFields.add(new TextSearchField("reporter", "Reporter"));
        this.searchFields.add(new TextSearchField("owner", "Owner"));
        this.searchFields.add(new TextSearchField("type", "Type"));
        this.searchFields.add(new TextSearchField("status", "Status"));
        this.searchFields.add(new TextSearchField("priority", "Priority"));
        this.searchFields.add(new TextSearchField("milestone", "Milestone"));
        this.searchFields.add(new TextSearchField("component", "Component"));
        this.searchFields.add(new TextSearchField("version", "Version"));
        this.searchFields.add(new TextSearchField("resoution", "Resolution"));
        this.searchFields.add(new TextSearchField("keywords", "Keywords"));
        this.searchFields.add(new TextSearchField("cc", "CC"));
        filterCombo.add("");
        for (SearchField field : this.searchFields) {
            filterCombo.add(field.getDisplayName());
        }
        filterCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (filterCombo.getText().length() > 0) {
                    SearchField field = (SearchField)TracQueryWizardPage.this.searchFields.get(filterCombo.getSelectionIndex() - 1);
                    TracQueryWizardPage.this.showSearchField(field, null);
                    filterCombo.setText("");
                }
            }
        });
    }

    private void createTitleGroup(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText(TITLE_QUERY_TITLE);
        group.setLayout((Layout)new GridLayout(1, false));
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        this.titleText = new Text((Composite)group, 2048);
        gd = new GridData(768);
        this.titleText.setLayoutData((Object)gd);
        this.titleText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                TracQueryWizardPage.this.getContainer().updateButtons();
            }
        });
    }

    public boolean isPageComplete() {
        return this.titleText != null && this.titleText.getText().length() > 0;
    }

    private void showSearchField(SearchField field, TracSearchFilter filter) {
        assert (filter == null || !this.visibleSearchFields.contains(field));
        if (!this.visibleSearchFields.contains(field)) {
            field.createControls(this.scrollComposite, filter);
            this.visibleSearchFields.add(field);
        } else {
            field.addControl(this.scrollComposite);
        }
        this.updateScrollPane();
    }

    public String getQueryUrl(String repsitoryUrl) {
        TracSearch search = new TracSearch();
        for (SearchField field : this.visibleSearchFields) {
            search.addFilter(field.getFilter());
        }
        StringBuilder sb = new StringBuilder();
        sb.append(repsitoryUrl);
        sb.append("/query?format=tab");
        sb.append(search.toUrl());
        return sb.toString();
    }

    public TracRepositoryQuery getQuery() {
        return new TracRepositoryQuery(this.repository.getUrl(), this.getQueryUrl(this.repository.getUrl()), this.titleText.getText());
    }

    private void hideSearchField(SearchField field) {
        this.visibleSearchFields.remove(field);
    }

    private void updateScrollPane() {
        this.scrollComposite.setSize(this.scrollComposite.computeSize(-1, -1));
        this.scrollComposite.layout();
    }

    private abstract class SearchField {
        protected String fieldName;
        private String displayName;

        public SearchField(String fieldName, String displayName) {
            this.fieldName = fieldName;
            this.displayName = displayName;
        }

        public abstract void createControls(Composite var1, TracSearchFilter var2);

        public abstract void addControl(Composite var1);

        public String getFieldName() {
            return this.fieldName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public abstract TracSearchFilter getFilter();
    }

    private class TextSearchField
    extends SearchField {
        private TracSearchFilter.CompareOperator[] compareOperators;
        private List<TextCriterion> criterions;

        public TextSearchField(String fieldName, String displayName) {
            super(fieldName, displayName);
            this.compareOperators = new TracSearchFilter.CompareOperator[]{TracSearchFilter.CompareOperator.CONTAINS, TracSearchFilter.CompareOperator.CONTAINS_NOT, TracSearchFilter.CompareOperator.BEGINS_WITH, TracSearchFilter.CompareOperator.ENDS_WITH, TracSearchFilter.CompareOperator.IS, TracSearchFilter.CompareOperator.IS_NOT};
        }

        public void createControls(Composite parent, TracSearchFilter filter) {
            if (filter != null) {
                TextCriterion first = this.addCriterion(parent);
                first.setCondition(filter.getOperator());
                List values = filter.getValues();
                if (!values.isEmpty()) {
                    first.setSearchText((String)values.get(0));
                    int i = 1;
                    while (i < values.size()) {
                        TextCriterion criterion = this.addCriterion(parent);
                        criterion.setSearchText((String)values.get(1));
                        ++i;
                    }
                }
            } else {
                this.addCriterion(parent);
            }
        }

        public void addControl(Composite parent) {
            this.addCriterion(parent);
        }

        public TextCriterion addCriterion(Composite parent) {
            TextCriterion criterion = new TextCriterion();
            if (this.criterions == null) {
                this.criterions = new ArrayList<TextCriterion>();
                criterion.createControl(parent);
            } else {
                criterion.createControl(parent, this.criterions.get(this.criterions.size() - 1));
            }
            this.criterions.add(criterion);
            return criterion;
        }

        public TracSearchFilter getFilter() {
            TracSearchFilter newFilter = new TracSearchFilter(this.getFieldName());
            newFilter.setOperator(this.criterions.get(0).getCondition());
            for (TextCriterion criterion : this.criterions) {
                newFilter.addValue(criterion.getSearchText());
            }
            return newFilter;
        }

        public void removeCriterion(TextCriterion criterion) {
            int i = this.criterions.indexOf(criterion);
            if (i == -1) {
                throw new RuntimeException();
            }
            if (i == 0) {
                if (this.criterions.size() > 1) {
                    TextCriterion sourceCriterion = this.criterions.get(1);
                    criterion.searchText.setText(sourceCriterion.searchText.getText());
                    this.removeCriterionByIndex(1);
                } else {
                    this.removeCriterionByIndex(0);
                    TracQueryWizardPage.this.hideSearchField(this);
                }
            } else {
                this.removeCriterionByIndex(i);
            }
        }

        private void removeCriterionByIndex(int i) {
            this.criterions.get(i).remove();
            this.criterions.remove(i);
            TracQueryWizardPage.this.updateScrollPane();
        }

        private class TextCriterion {
            private Combo conditionCombo;
            private Text searchText;
            private Label label;
            private Button removeButton;

            private TextCriterion() {
            }

            public void createControl(Composite parent) {
                this.label = new Label(parent, 16384);
                this.label.setText(String.valueOf(TextSearchField.this.getDisplayName()) + ": ");
                this.conditionCombo = new Combo(parent, 2060);
                TracSearchFilter.CompareOperator[] compareOperatorArray = TextSearchField.this.compareOperators;
                int n = compareOperatorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TracSearchFilter.CompareOperator op = compareOperatorArray[n2];
                    this.conditionCombo.add(op.toString());
                    ++n2;
                }
                this.conditionCombo.setText(TextSearchField.this.compareOperators[0].toString());
                this.createSearchTextAndRemoveButton(parent);
            }

            public void createControl(Composite parent, TextCriterion top) {
                this.label = new Label(parent, 131072);
                GridData gd = new GridData();
                gd.horizontalAlignment = 0x1000008;
                gd.horizontalSpan = 2;
                this.label.setLayoutData((Object)gd);
                this.label.setText("or");
                this.createSearchTextAndRemoveButton(parent);
                this.label.moveBelow((Control)top.removeButton);
                this.searchText.moveBelow((Control)this.label);
                this.removeButton.moveBelow((Control)this.searchText);
            }

            private void createSearchTextAndRemoveButton(Composite parent) {
                this.searchText = new Text(parent, 2048);
                GridData gd = new GridData(768);
                this.searchText.setLayoutData((Object)gd);
                this.removeButton = new Button(parent, 8);
                this.removeButton.setText("-");
                this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        TextSearchField.this.removeCriterion(TextCriterion.this);
                    }
                });
            }

            public void remove() {
                this.label.dispose();
                if (this.conditionCombo != null) {
                    this.conditionCombo.dispose();
                }
                this.searchText.dispose();
                this.removeButton.dispose();
            }

            public TracSearchFilter.CompareOperator getCondition() {
                return this.conditionCombo != null ? TextSearchField.this.compareOperators[this.conditionCombo.getSelectionIndex()] : null;
            }

            public String getSearchText() {
                return this.searchText.getText();
            }

            public boolean setCondition(TracSearchFilter.CompareOperator operator) {
                int i;
                if (this.conditionCombo != null && (i = this.conditionCombo.indexOf(operator.toString())) != -1) {
                    this.conditionCombo.select(i);
                    return true;
                }
                return false;
            }

            public void setSearchText(String text) {
                this.searchText.setText(text);
            }
        }
    }
}

