/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.web.core;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.web.core.SslProtocolSocketFactory;
import org.eclipse.mylyn.web.core.WebClientUtil;

public class PollingSslProtocolSocketFactory
implements SecureProtocolSocketFactory {
    private final IProgressMonitor monitor;
    private final SslProtocolSocketFactory factory;

    public PollingSslProtocolSocketFactory(IProgressMonitor monitor) {
        this.monitor = monitor;
        this.factory = SslProtocolSocketFactory.getInstance();
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        return this.factory.createSocket(socket, host, port, autoClose);
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.factory.createSocket(host, port);
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException, UnknownHostException {
        return this.factory.createSocket(host, port, localAddress, localPort);
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        if (params == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        int timeout = params.getConnectionTimeout();
        Socket socket = this.factory.getSocketFactory().createSocket();
        socket.bind(new InetSocketAddress(localAddress, localPort));
        WebClientUtil.connect(socket, new InetSocketAddress(host, port), timeout, this.monitor);
        return socket;
    }
}

