/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.web.core;

import java.net.Proxy;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.mylyn.web.core.AbstractWebLocation;
import org.eclipse.mylyn.web.core.AuthenticationCredentials;
import org.eclipse.mylyn.web.core.AuthenticationType;
import org.eclipse.mylyn.web.core.IProxyProvider;

public class WebLocation
extends AbstractWebLocation {
    private final Map<AuthenticationType, AuthenticationCredentials> credentialsByType = new HashMap<AuthenticationType, AuthenticationCredentials>();
    private final IProxyProvider proxyProvider;

    public WebLocation(String url, String username, String password, IProxyProvider proxyProvider) {
        super(url);
        this.proxyProvider = proxyProvider;
        if (username != null && password != null) {
            this.setCredentials(AuthenticationType.REPOSITORY, username, password);
        }
    }

    public WebLocation(String url, String username, String password) {
        this(url, username, password, null);
    }

    public WebLocation(String url) {
        this(url, null, null, null);
    }

    public AuthenticationCredentials getCredentials(AuthenticationType authType) {
        return this.credentialsByType.get((Object)authType);
    }

    public Proxy getProxyForHost(String host, String proxyType) {
        if (this.proxyProvider != null) {
            return this.proxyProvider.getProxyForHost(host, proxyType);
        }
        return null;
    }

    public AbstractWebLocation.ResultType requestCredentials(AuthenticationType authType, String url) {
        return AbstractWebLocation.ResultType.NOT_SUPPORTED;
    }

    public void setCredentials(AuthenticationType authType, String username, String password) {
        this.credentialsByType.put(authType, new AuthenticationCredentials(username, password));
    }
}

