/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.dev;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextCorePlugin;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class IntrospectObjectAction
implements IViewActionDelegate {
    private ISelection currentSelection;

    public void init(IViewPart view) {
    }

    public void run(IAction action) {
        if (this.currentSelection instanceof StructuredSelection) {
            Object resourceAdapter;
            StructuredSelection selection = (StructuredSelection)this.currentSelection;
            Object object = selection.getFirstElement();
            String text = "Object class: " + object.getClass() + "\n\n";
            try {
                AbstractContextStructureBridge bridge = ContextCorePlugin.getDefault().getStructureBridge(object);
                IInteractionElement node = ContextCorePlugin.getContextManager().getElement(bridge.getHandleIdentifier(object));
                if (node != null) {
                    text = String.valueOf(text) + "Interest value: " + node.getInterest().getValue() + "\n";
                    text = String.valueOf(text) + node.getInterest().toString();
                }
            }
            catch (Throwable throwable) {
                text = String.valueOf(text) + "<no structure bridge>";
            }
            if (object instanceof IAdaptable && (resourceAdapter = ((IAdaptable)object).getAdapter(IResource.class)) != null) {
                text = String.valueOf(text) + "\nResource adapter: " + ((IResource)resourceAdapter).getFullPath().toOSString();
            }
            if (object instanceof AbstractTask) {
                AbstractTask task = null;
                if (object instanceof AbstractTask) {
                    task = (AbstractTask)object;
                }
                if (task != null) {
                    TaskRepository repository = TasksUiPlugin.getRepositoryManager().getRepository(task.getConnectorKind(), task.getRepositoryUrl());
                    text = String.valueOf(text) + "\nHandle Identifier: " + task.getHandleIdentifier();
                    text = String.valueOf(text) + "\nLast time in SYNCHRONIZED state: " + task.getLastReadTimeStamp();
                    text = repository != null ? String.valueOf(text) + "\nRepository synch time stamp: " + repository.getSynchronizationTimeStamp() : String.valueOf(text) + "\nRepository is null (!), url is: " + task.getRepositoryUrl();
                    text = String.valueOf(text) + "\nSync state: " + task.getSynchronizationState();
                    text = String.valueOf(text) + "\nParents: " + task.getParentContainers();
                    if (task.getChildren() != null && !task.getChildren().isEmpty()) {
                        text = String.valueOf(text) + "\nChildren: ";
                        for (AbstractTask subTask : task.getChildren()) {
                            text = String.valueOf(text) + "\n" + subTask;
                        }
                    }
                }
            }
            text = String.valueOf(text) + "\n\nNum tasks: " + TasksUiPlugin.getTaskListManager().getTaskList().getAllTasks().size();
            text = String.valueOf(text) + "\nNum queries: " + TasksUiPlugin.getTaskListManager().getTaskList().getQueries().size();
            MessageDialog.openInformation(null, (String)"Mylyn Sandbox", (String)text);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.currentSelection = selection;
    }
}

