/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.bridge.bugs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.AbstractRelationProvider;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaTask;
import org.eclipse.mylyn.internal.sandbox.bridge.bugs.BugzillaReportInfo;
import org.eclipse.mylyn.internal.tasks.ui.editors.ContentOutlineTools;
import org.eclipse.mylyn.internal.tasks.ui.editors.IRepositoryTaskSelection;
import org.eclipse.mylyn.internal.tasks.ui.editors.RepositoryTaskOutlineNode;
import org.eclipse.mylyn.internal.tasks.ui.editors.RepositoryTaskSelection;
import org.eclipse.ui.views.markers.internal.ProblemMarker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugzillaStructureBridge
extends AbstractContextStructureBridge {
    public static final String CONTENT_TYPE = "bugzilla";
    public List<AbstractRelationProvider> providers = new ArrayList<AbstractRelationProvider>();

    public String getContentType() {
        return CONTENT_TYPE;
    }

    public String getHandleIdentifier(Object object) {
        if (object instanceof RepositoryTaskOutlineNode) {
            RepositoryTaskOutlineNode node = (RepositoryTaskOutlineNode)object;
            return ContentOutlineTools.getHandle((IRepositoryTaskSelection)node);
        }
        if (object instanceof RepositoryTaskSelection) {
            RepositoryTaskSelection n = (RepositoryTaskSelection)object;
            return ContentOutlineTools.getHandle((IRepositoryTaskSelection)n);
        }
        return null;
    }

    public Object getObjectForHandle(String handle) {
        return null;
    }

    public String getParentHandle(String handle) {
        if (!handle.matches(".*;.*;.*")) {
            return null;
        }
        RepositoryTaskOutlineNode bon = (RepositoryTaskOutlineNode)this.getObjectForHandle(handle);
        if (bon != null && bon.getParent() != null) {
            return ContentOutlineTools.getHandle((IRepositoryTaskSelection)bon.getParent());
        }
        return null;
    }

    public String getLabel(Object object) {
        if (object instanceof RepositoryTaskOutlineNode) {
            RepositoryTaskOutlineNode b = (RepositoryTaskOutlineNode)object;
            return ContentOutlineTools.getName((IRepositoryTaskSelection)b);
        }
        if (object instanceof BugzillaReportInfo) {
            BugzillaTask hit = ((BugzillaReportInfo)object).getHit();
            return String.valueOf(hit.getRepositoryUrl()) + ": Bug#: " + hit.getTaskId() + ": " + hit.getSummary();
        }
        return "";
    }

    public boolean canBeLandmark(String handle) {
        return false;
    }

    public boolean acceptsObject(Object object) {
        return object instanceof RepositoryTaskOutlineNode || object instanceof RepositoryTaskSelection;
    }

    public boolean canFilter(Object element) {
        return true;
    }

    public boolean isDocument(String handle) {
        return handle.indexOf(59) == handle.lastIndexOf(59) && handle.indexOf(";") != -1;
    }

    public String getHandleForMarker(ProblemMarker marker) {
        return null;
    }

    public String getContentType(String elementHandle) {
        return this.getContentType();
    }

    public String getHandleForOffsetInObject(Object resource, int offset) {
        return null;
    }

    public List<String> getChildHandles(String handle) {
        return Collections.emptyList();
    }
}

