/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.bridge.bugs;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.ITaskCollector;
import org.eclipse.mylyn.tasks.core.ITaskFactory;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;
import org.eclipse.mylyn.tasks.core.TaskList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProgressQueryHitCollector
implements ITaskCollector {
    public static final int MAX_HITS = 5000;
    public static final String MAX_HITS_REACHED = "Max allowed number of hits returned exceeded. Some hits may not be displayed. Please narrow query scope.";
    protected Set<AbstractTask> taskResults = new HashSet<AbstractTask>();
    private IProgressMonitor monitor = new NullProgressMonitor();
    private int matchCount;
    private static final String STARTING = "querying the server";
    private static final String MATCH = "1 match";
    private static final String MATCHES = "{0} matches";
    private static final String DONE = "done";
    protected TaskList taskList;
    protected ITaskFactory taskFactory;

    public ProgressQueryHitCollector(TaskList tasklist, ITaskFactory taskFactory) {
        this.taskList = tasklist;
        this.taskFactory = taskFactory;
    }

    public void aboutToStart(int startMatchCount) throws CoreException {
        this.taskResults.clear();
        this.matchCount = startMatchCount;
        this.monitor.setTaskName(STARTING);
    }

    public void accept(AbstractTask task) {
        if (!this.getProgressMonitor().isCanceled()) {
            this.getProgressMonitor().subTask(this.getFormattedMatchesString(this.matchCount));
            this.getProgressMonitor().worked(1);
        }
        if (task == null) {
            return;
        }
        AbstractTask hitTask = this.taskList.getTask(task.getHandleIdentifier());
        if (hitTask == null) {
            hitTask = task;
            this.taskList.addTask(hitTask);
        }
        this.taskResults.add(hitTask);
        ++this.matchCount;
    }

    public void accept(RepositoryTaskData taskData) throws CoreException {
        if (taskData == null) {
            return;
        }
        if (!this.getProgressMonitor().isCanceled()) {
            this.getProgressMonitor().subTask(this.getFormattedMatchesString(this.matchCount));
            this.getProgressMonitor().worked(1);
        }
        AbstractTask task = this.taskFactory.createTask(taskData, (IProgressMonitor)new SubProgressMonitor(this.monitor, 1));
        this.taskResults.add(task);
        ++this.matchCount;
    }

    public void done() {
        if (this.monitor != null && !this.monitor.isCanceled()) {
            String matchesString = this.getFormattedMatchesString(this.matchCount);
            this.monitor.setTaskName(MessageFormat.format(DONE, matchesString));
            this.monitor.done();
        }
        this.monitor = null;
    }

    protected String getFormattedMatchesString(int count) {
        if (count == 1) {
            return MATCH;
        }
        Object[] messageFormatArgs = new Object[]{new Integer(count)};
        return MessageFormat.format(MATCHES, messageFormatArgs);
    }

    public IProgressMonitor getProgressMonitor() {
        return this.monitor;
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public Set<AbstractTask> getTasks() {
        return this.taskResults;
    }

    public void clear() {
        this.taskResults.clear();
    }
}

