/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.bridge.bugs;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.mylyn.internal.bugzilla.ui.BugzillaUiPlugin;
import org.eclipse.mylyn.internal.sandbox.bridge.bugs.BugzillaMylynSearchOperation;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;

public class Util {
    private static final String[] patternOperationValues = new String[]{"allwordssubstr", "anywordssubstr", "regexp"};

    public static String getExactSearchURL(String repositoryUrl, IMember je) {
        StringBuffer sb = Util.getQueryURLStart(repositoryUrl);
        String long_desc = "";
        long_desc = String.valueOf(long_desc) + BugzillaMylynSearchOperation.getFullyQualifiedName((IJavaElement)je);
        try {
            sb.append(URLEncoder.encode(long_desc, Charset.defaultCharset().toString()));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        sb.append(Util.getQueryURLEnd(repositoryUrl));
        return sb.toString();
    }

    public static String getInexactSearchURL(String repositoryUrl, IMember je) {
        StringBuffer sb = Util.getQueryURLStart(repositoryUrl);
        String long_desc = "";
        if (!(je instanceof IType)) {
            long_desc = String.valueOf(long_desc) + je.getParent().getElementName() + ".";
        }
        long_desc = String.valueOf(long_desc) + je.getElementName();
        try {
            sb.append(URLEncoder.encode(long_desc, Charset.defaultCharset().toString()));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        sb.append(Util.getQueryURLEnd(repositoryUrl));
        return sb.toString();
    }

    public static StringBuffer getQueryURLEnd(String repositoryUrl) {
        StringBuffer sb = new StringBuffer();
        String[] resolutionValues = BugzillaUiPlugin.getQueryOptions((String)"org.eclipse.mylyn.bugzilla.values.resolution", null, (String)repositoryUrl);
        String[] statusValues = BugzillaUiPlugin.getQueryOptions((String)"org.eclipse.mylyn.bugzilla.values.status", null, (String)repositoryUrl);
        sb.append("&bug_status=" + statusValues[0]);
        sb.append("&bug_status=" + statusValues[1]);
        sb.append("&bug_status=" + statusValues[2]);
        sb.append("&bug_status=" + statusValues[3]);
        sb.append("&bug_status=" + statusValues[4]);
        sb.append("&bug_status=" + statusValues[5]);
        sb.append("&bug_status=" + statusValues[6]);
        sb.append("&resolution=" + resolutionValues[0]);
        sb.append("&resolution=" + resolutionValues[3]);
        sb.append("&resolution=---");
        return sb;
    }

    public static StringBuffer getQueryURLStart(String repositoryUrl) {
        StringBuffer sb = new StringBuffer(repositoryUrl);
        if (sb.charAt(sb.length() - 1) != '/') {
            sb.append('/');
        }
        sb.append("buglist.cgi?");
        TaskRepository repository = TasksUiPlugin.getRepositoryManager().getRepository("bugzilla", repositoryUrl);
        if (repository != null && repository.hasCredentials()) {
            try {
                sb.append("GoAheadAndLogIn=1&Bugzilla_login=" + URLEncoder.encode(repository.getUserName(), Charset.defaultCharset().toString()) + "&Bugzilla_password=" + URLEncoder.encode(repository.getPassword(), Charset.defaultCharset().toString()) + "&");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        sb.append("long_desc_type=");
        sb.append(patternOperationValues[0]);
        sb.append("&long_desc=");
        return sb;
    }

    public static boolean hasElementName(String elementName, String comment) {
        String regexElement = ".*" + elementName + ".*";
        String[] lines = comment.split("\n");
        int i = 0;
        while (i < lines.length) {
            if (lines[i].matches(regexElement)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

