/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.internal.sandbox.ui.ActiveSearchViewTracker;
import org.eclipse.mylyn.internal.sandbox.ui.SharedDataDirectoryManager;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class SandboxUiPlugin
extends AbstractUIPlugin {
    public static final String ID_PLUGIN = "org.eclipse.mylyn.sandbox.ui";
    private static SandboxUiPlugin plugin;
    private SharedDataDirectoryManager sharedDataDirectoryManager = new SharedDataDirectoryManager();
    public static final String OVERLAYS_INCOMING_TIGHT = "org.eclipse.mylyn.tasks.ui.overlays.incoming.tight";
    private ActiveSearchViewTracker activeSearchViewTracker = new ActiveSearchViewTracker();

    public SandboxUiPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        final IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.getDisplay().asyncExec(new Runnable(){

            public void run() {
                try {
                    workbench.addWindowListener((IWindowListener)SandboxUiPlugin.this.activeSearchViewTracker);
                    IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
                    int i = 0;
                    while (i < windows.length) {
                        windows[i].addPageListener((IPageListener)SandboxUiPlugin.this.activeSearchViewTracker);
                        IWorkbenchPage[] pages = windows[i].getPages();
                        int j = 0;
                        while (j < pages.length) {
                            pages[j].addPartListener((IPartListener2)SandboxUiPlugin.this.activeSearchViewTracker);
                            ++j;
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    StatusHandler.log((IStatus)new Status(4, SandboxUiPlugin.ID_PLUGIN, "Sandbox UI initialization failed", (Throwable)e));
                }
            }
        });
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null) {
            workbench.removeWindowListener((IWindowListener)this.activeSearchViewTracker);
            IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
            int i = 0;
            while (i < windows.length) {
                IWorkbenchPage[] pages = windows[i].getPages();
                windows[i].removePageListener((IPageListener)this.activeSearchViewTracker);
                int j = 0;
                while (j < pages.length) {
                    pages[j].removePartListener((IPartListener2)this.activeSearchViewTracker);
                    ++j;
                }
                ++i;
            }
        }
    }

    public static SandboxUiPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.mylyn.internal.sandbox", (String)path);
    }

    public SharedDataDirectoryManager getSharedDataDirectoryManager() {
        return this.sharedDataDirectoryManager;
    }
}

