/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.views;

import java.util.HashSet;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.internal.tasks.core.ScheduledTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.ScheduledTaskDelegate;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityManager;
import org.eclipse.mylyn.tasks.core.AbstractTask;

public class TaskActivityViewContentProvider
implements IStructuredContentProvider,
ITreeContentProvider {
    private TaskActivityManager taskActivityManager;

    public TaskActivityViewContentProvider(TaskActivityManager taskActivityManager) {
        this.taskActivityManager = taskActivityManager;
    }

    public Object[] getElements(Object parent) {
        HashSet<ScheduledTaskContainer> ranges = new HashSet<ScheduledTaskContainer>();
        for (ScheduledTaskContainer container : this.taskActivityManager.getDateRanges()) {
            if (container.isFuture()) continue;
            ranges.add(container);
        }
        return ranges.toArray();
    }

    public Object getParent(Object child) {
        if (child instanceof ScheduledTaskDelegate) {
            return ((ScheduledTaskDelegate)child).getDateRangeContainer();
        }
        return null;
    }

    public Object[] getChildren(Object parent) {
        if (parent instanceof ScheduledTaskContainer) {
            ScheduledTaskContainer taskContainer = (ScheduledTaskContainer)parent;
            HashSet<ScheduledTaskDelegate> delegates = new HashSet<ScheduledTaskDelegate>();
            for (AbstractTask task : taskContainer.getChildren()) {
                delegates.add(new ScheduledTaskDelegate(taskContainer, task, null, null, 0L));
            }
            return delegates.toArray();
        }
        return new Object[0];
    }

    public boolean hasChildren(Object parent) {
        return this.getChildren(parent).length > 0;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

